/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.kew.impl.stuck.AutofixCollectorJob;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KEWServiceLocator.class})
public class AutofixCollectorJobTest {
    @Mock
    private StuckDocumentService stuckDocumentService;
    @Mock
    private JobExecutionContext context;
    @Mock
    private Scheduler scheduler;
    private JobDataMap jobDataMap;
    @InjectMocks
    private AutofixCollectorJob autofixCollectorJob;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getScheduler()).thenReturn((Object)this.scheduler);
        this.jobDataMap = new JobDataMap();
        Mockito.when((Object)this.context.getMergedJobDataMap()).thenReturn((Object)this.jobDataMap);
        this.setAutofixQuietPeriod(60);
        this.setMaxAutofixAttempts(2);
    }

    @Test
    public void testGetStuckDocumentService_FromKewServiceLocator() {
        AutofixCollectorJob autofixCollectorJob = new AutofixCollectorJob();
        StuckDocumentService stuckDocumentService1 = (StuckDocumentService)Mockito.mock(StuckDocumentService.class);
        StuckDocumentService stuckDocumentService2 = (StuckDocumentService)Mockito.mock(StuckDocumentService.class);
        PowerMockito.mockStatic(KEWServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KEWServiceLocator.getStuckDocumentService()).thenReturn(null);
        Assert.assertNull((Object)autofixCollectorJob.getStuckDocumentService());
        Mockito.when((Object)KEWServiceLocator.getStuckDocumentService()).thenReturn((Object)stuckDocumentService1);
        Assert.assertEquals((Object)stuckDocumentService1, (Object)autofixCollectorJob.getStuckDocumentService());
        autofixCollectorJob.setStuckDocumentService(stuckDocumentService2);
        Assert.assertEquals((Object)stuckDocumentService2, (Object)autofixCollectorJob.getStuckDocumentService());
    }

    @Test(expected=JobExecutionException.class)
    public void testExecute_NoDependenciesAvailable() throws JobExecutionException {
        this.autofixCollectorJob.setStuckDocumentService(null);
        PowerMockito.mockStatic(KEWServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KEWServiceLocator.getStuckDocumentService()).thenReturn(null);
        this.autofixCollectorJob.execute(this.context);
    }

    @Test
    public void testExecute_NoStuckDocuments() throws JobExecutionException {
        this.setNumberOfStuckDocumentIncidents(0);
        this.autofixCollectorJob.execute(this.context);
        ((StuckDocumentService)Mockito.verify((Object)this.stuckDocumentService, (VerificationMode)Mockito.times((int)1))).recordNewStuckDocumentIncidents();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.scheduler});
    }

    @Test
    public void testExecute_StuckDocuments_NoPartitioning() throws JobExecutionException, SchedulerException {
        Set generatedIncidentIds = this.setNumberOfStuckDocumentIncidents(5).stream().map(StuckDocumentIncident::getStuckDocumentIncidentId).collect(Collectors.toSet());
        this.autofixCollectorJob.execute(this.context);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(JobDetail.class);
        ArgumentCaptor triggerCaptor = ArgumentCaptor.forClass(Trigger.class);
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).scheduleJob((JobDetail)jobCaptor.capture(), (Trigger)triggerCaptor.capture());
        JobDetail jobDetail = (JobDetail)jobCaptor.getValue();
        String incidentIdsString = jobDetail.getJobDataMap().getString("incidentIds");
        HashSet<String> incidentIds = new HashSet<String>(Arrays.asList(incidentIdsString.split(",")));
        Assert.assertEquals(generatedIncidentIds, incidentIds);
        int currentAutofixCount = jobDetail.getJobDataMap().getInt("currentAutofixCount");
        Assert.assertEquals((long)0L, (long)currentAutofixCount);
        int autofixQuietPeriod = jobDetail.getJobDataMap().getInt("autofixQuietPeriod");
        Assert.assertEquals((long)60L, (long)autofixQuietPeriod);
        int maxAutofixAttempts = jobDetail.getJobDataMap().getInt("autofixMaxAttempts");
        Assert.assertEquals((long)2L, (long)maxAutofixAttempts);
        Trigger trigger = (Trigger)triggerCaptor.getValue();
        Assert.assertTrue((boolean)(trigger instanceof SimpleTrigger));
        SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
        Assert.assertEquals((long)2L, (long)simpleTrigger.getRepeatCount());
        Assert.assertEquals((long)60000L, (long)simpleTrigger.getRepeatInterval());
        Assert.assertEquals((long)5L, (long)simpleTrigger.getMisfireInstruction());
        Assert.assertEquals((long)0L, (long)simpleTrigger.getTimesTriggered());
    }

    @Test
    public void testExecute_StuckDocuments_Partitioning() throws JobExecutionException, SchedulerException {
        Set generatedIncidentIds = this.setNumberOfStuckDocumentIncidents(425).stream().map(StuckDocumentIncident::getStuckDocumentIncidentId).collect(Collectors.toSet());
        this.autofixCollectorJob.execute(this.context);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(JobDetail.class);
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)9))).scheduleJob((JobDetail)jobCaptor.capture(), (Trigger)Matchers.any(Trigger.class));
        HashSet incidentIds = new HashSet();
        jobCaptor.getAllValues().forEach(jobDetail -> {
            String incidentIdsString = jobDetail.getJobDataMap().getString("incidentIds");
            incidentIds.addAll(Arrays.asList(incidentIdsString.split(",")));
        });
        Assert.assertEquals(generatedIncidentIds, incidentIds);
    }

    @Test
    public void testExecute_StuckDocuments_SchedulerException() throws JobExecutionException, SchedulerException {
        this.setNumberOfStuckDocumentIncidents(5);
        Mockito.when((Object)this.scheduler.scheduleJob((JobDetail)Matchers.any(JobDetail.class), (Trigger)Matchers.any(Trigger.class))).thenThrow(new Throwable[]{new SchedulerException()});
        try {
            this.autofixCollectorJob.execute(this.context);
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SchedulerException));
        }
    }

    private void setAutofixQuietPeriod(int autofixQuietPeriod) {
        this.jobDataMap.put("autofixQuietPeriod", autofixQuietPeriod);
    }

    private void setMaxAutofixAttempts(int maxAutofixAttempts) {
        this.jobDataMap.put("autofixMaxAttempts", maxAutofixAttempts);
    }

    private List<StuckDocumentIncident> setNumberOfStuckDocumentIncidents(int numberOfIncidents) {
        ArrayList<StuckDocumentIncident> incidents = new ArrayList<StuckDocumentIncident>();
        for (int i = 0; i < numberOfIncidents; ++i) {
            incidents.add(this.generateIncident());
        }
        Mockito.when((Object)this.stuckDocumentService.recordNewStuckDocumentIncidents()).thenReturn(incidents);
        return incidents;
    }

    private StuckDocumentIncident generateIncident() {
        StuckDocumentIncident incident = StuckDocumentIncident.startNewIncident((String)UUID.randomUUID().toString());
        incident.setStuckDocumentIncidentId(UUID.randomUUID().toString());
        return incident;
    }
}

