/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.impl.stuck.AutofixDocumentsJob;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KEWServiceLocator.class, KewApiServiceLocator.class})
public class AutofixDocumentsJobTest {
    @Mock
    private StuckDocumentService stuckDocumentService;
    @Mock
    private DocumentTypeService documentTypeService;
    @Mock
    private DocumentProcessingQueue documentProcessingQueue;
    private JobExecutionContext context;
    private Scheduler scheduler;
    private JobDetail jobDetail;
    private JobKey jobKey;
    private DocumentType documentType;
    private Map<String, StuckDocumentIncident> incidentDatabase;
    @InjectMocks
    private AutofixDocumentsJob autofixDocumentsJob;

    @Before
    public void setup() {
        this.incidentDatabase = new HashMap<String, StuckDocumentIncident>();
        this.context = (JobExecutionContext)Mockito.mock(JobExecutionContext.class);
        this.scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        this.jobKey = new JobKey(this.getClass().getName());
        this.jobDetail = JobBuilder.newJob(AutofixDocumentsJob.class).withIdentity(this.jobKey).build();
        Mockito.when((Object)this.context.getMergedJobDataMap()).thenReturn((Object)this.jobDetail.getJobDataMap());
        Mockito.when((Object)this.context.getScheduler()).thenReturn((Object)this.scheduler);
        Mockito.when((Object)this.context.getJobDetail()).thenReturn((Object)this.jobDetail);
        this.setCurrentAutofixCount(0);
        this.documentType = (DocumentType)Mockito.mock(DocumentType.class);
        Mockito.when((Object)this.documentType.getApplicationId()).thenReturn((Object)"COVFEFE");
        Mockito.when((Object)this.documentTypeService.findByDocumentId((String)Matchers.any())).thenReturn((Object)this.documentType);
        PowerMockito.mockStatic(KEWServiceLocator.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(KewApiServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KEWServiceLocator.getDocumentTypeService()).thenReturn((Object)this.documentTypeService);
        Mockito.when((Object)KewApiServiceLocator.getDocumentProcessingQueue((String)((String)Matchers.any()), (String)((String)Matchers.eq((Object)"COVFEFE")))).thenReturn((Object)this.documentProcessingQueue);
    }

    @Test
    public void testGetStuckDocumentService_FromKewServiceLocator() {
        AutofixDocumentsJob autofixDocumentsJob = new AutofixDocumentsJob();
        StuckDocumentService stuckDocumentService1 = (StuckDocumentService)Mockito.mock(StuckDocumentService.class);
        StuckDocumentService stuckDocumentService2 = (StuckDocumentService)Mockito.mock(StuckDocumentService.class);
        PowerMockito.mockStatic(KEWServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KEWServiceLocator.getStuckDocumentService()).thenReturn(null);
        Assert.assertNull((Object)autofixDocumentsJob.getStuckDocumentService());
        Mockito.when((Object)KEWServiceLocator.getStuckDocumentService()).thenReturn((Object)stuckDocumentService1);
        Assert.assertEquals((Object)stuckDocumentService1, (Object)autofixDocumentsJob.getStuckDocumentService());
        autofixDocumentsJob.setStuckDocumentService(stuckDocumentService2);
        Assert.assertEquals((Object)stuckDocumentService2, (Object)autofixDocumentsJob.getStuckDocumentService());
    }

    @Test
    public void testExecute_NoneStillStuck() throws Exception {
        List<StuckDocumentIncident> incidents = this.generateAndSaveIncidents(2);
        this.setIncidentIds(incidents.get(0).getStuckDocumentIncidentId(), incidents.get(1).getStuckDocumentIncidentId());
        Mockito.when((Object)this.stuckDocumentService.resolveIncidentsIfPossible((List)Matchers.any())).thenReturn(new ArrayList());
        this.autofixDocumentsJob.execute(this.context);
        ((Scheduler)Mockito.verify((Object)this.scheduler)).deleteJob(this.jobKey);
    }

    @Test
    public void testExecute_SomeStillStuck_RetriesLeft() throws Exception {
        this.setMaxAutofixAttempts(1);
        List<StuckDocumentIncident> incidents = this.generateAndSaveIncidents(3);
        StuckDocumentIncident incident1 = incidents.get(0);
        StuckDocumentIncident incident2 = incidents.get(1);
        this.setIncidentIds(incident1.getStuckDocumentIncidentId(), incident2.getStuckDocumentIncidentId());
        Mockito.when((Object)this.stuckDocumentService.resolveIncidentsIfPossible((List)Matchers.any())).thenReturn(Collections.singletonList(incident2));
        Mockito.when((Object)this.stuckDocumentService.startFixingIncident((StuckDocumentIncident)Matchers.any())).then(invocation -> (StuckDocumentIncident)invocation.getArgumentAt(0, StuckDocumentIncident.class));
        this.autofixDocumentsJob.execute(this.context);
        List<String> stillStuckDocs = this.getIncidentIds();
        Assert.assertEquals((long)1L, (long)stillStuckDocs.size());
        Assert.assertEquals((Object)incident2.getStuckDocumentIncidentId(), (Object)stillStuckDocs.get(0));
        ((StuckDocumentService)Mockito.verify((Object)this.stuckDocumentService)).startFixingIncident((StuckDocumentIncident)Matchers.any());
        ((StuckDocumentService)Mockito.verify((Object)this.stuckDocumentService)).recordNewIncidentFixAttempt((StuckDocumentIncident)Matchers.any());
        ((StuckDocumentService)Mockito.verify((Object)this.stuckDocumentService, (VerificationMode)Mockito.never())).recordIncidentFailure((StuckDocumentIncident)Matchers.any());
        this.autofixDocumentsJob.execute(this.context);
        ((StuckDocumentService)Mockito.verify((Object)this.stuckDocumentService)).recordIncidentFailure((StuckDocumentIncident)Matchers.any());
    }

    @Test(expected=IllegalStateException.class)
    public void testExecute_SchedulerException() throws Exception {
        Mockito.when((Object)this.scheduler.deleteJob((JobKey)Matchers.any())).thenThrow(new Throwable[]{new SchedulerException()});
        this.setIncidentIds(new String[0]);
        this.autofixDocumentsJob.execute(this.context);
    }

    private List<StuckDocumentIncident> generateAndSaveIncidents(int numberOfIncidents) {
        ArrayList incidents = Lists.newArrayList();
        for (int i = 0; i < numberOfIncidents; ++i) {
            incidents.add(this.generateAndSaveIncident());
        }
        return incidents;
    }

    private StuckDocumentIncident generateAndSaveIncident() {
        String incidentId = UUID.randomUUID().toString();
        StuckDocumentIncident incident = StuckDocumentIncident.startNewIncident((String)UUID.randomUUID().toString());
        incident.setStuckDocumentIncidentId(incidentId);
        this.incidentDatabase.put(incidentId, incident);
        return incident;
    }

    private void setCurrentAutofixCount(int count) {
        this.jobDetail.getJobDataMap().put("currentAutofixCount", count);
    }

    private void setIncidentIds(String ... incidentIds) {
        this.jobDetail.getJobDataMap().put("incidentIds", String.join((CharSequence)",", incidentIds));
    }

    private List<String> getIncidentIds() {
        return Arrays.asList(this.jobDetail.getJobDataMap().getString("incidentIds").split(","));
    }

    private void setMaxAutofixAttempts(int maxAutofixAttempts) {
        this.jobDetail.getJobDataMap().put("autofixMaxAttempts", maxAutofixAttempts);
    }
}

