/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.RuntimeConfig;
import org.kuali.rice.core.api.config.property.SimpleRuntimeConfig;
import org.kuali.rice.kew.impl.stuck.StuckDocumentScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.context.event.ContextRefreshedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class StuckDocumentSchedulerTest {
    @Mock
    private Scheduler scheduler;
    @Mock
    private ContextRefreshedEvent contextRefreshedEvent;
    private SimpleRuntimeConfig notificationEnabled = new SimpleRuntimeConfig("false");
    private SimpleRuntimeConfig notificationCronExpression = new SimpleRuntimeConfig("0 0 0/1 1/1 * ? *");
    private SimpleRuntimeConfig autofixEnabled = new SimpleRuntimeConfig("false");
    private SimpleRuntimeConfig autofixCronExpression = new SimpleRuntimeConfig("0 0/15 * 1/1 * ? *");
    private SimpleRuntimeConfig autofixQuietPeriod = new SimpleRuntimeConfig("60");
    private SimpleRuntimeConfig autofixMaxAttempts = new SimpleRuntimeConfig("1");
    @InjectMocks
    private StuckDocumentScheduler stuckDocumentScheduler;

    @Before
    public void setup() throws Exception {
        this.stuckDocumentScheduler.setNotificationEnabled((RuntimeConfig)this.notificationEnabled);
        this.stuckDocumentScheduler.setNotificationCronExpression((RuntimeConfig)this.notificationCronExpression);
        this.stuckDocumentScheduler.setAutofixEnabled((RuntimeConfig)this.autofixEnabled);
        this.stuckDocumentScheduler.setAutofixCronExpression((RuntimeConfig)this.autofixCronExpression);
        this.stuckDocumentScheduler.setAutofixQuietPeriod((RuntimeConfig)this.autofixQuietPeriod);
        this.stuckDocumentScheduler.setAutofixMaxAttempts((RuntimeConfig)this.autofixMaxAttempts);
        Mockito.when((Object)this.scheduler.checkExists(StuckDocumentScheduler.NOTIFICATION_JOB_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.scheduler.checkExists(StuckDocumentScheduler.AUTOFIX_COLLECTOR_JOB_KEY)).thenReturn((Object)false);
    }

    @Test
    public void testInitialization_NotificationNotEnabled() throws Exception {
        this.stuckDocumentScheduler.onApplicationEvent(this.contextRefreshedEvent);
        JobKey jobKey = StuckDocumentScheduler.NOTIFICATION_JOB_KEY;
        ((Scheduler)Mockito.verify((Object)this.scheduler)).checkExists(jobKey);
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).deleteJob(jobKey);
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).scheduleJob((JobDetail)Mockito.any(JobDetail.class), (Trigger)Mockito.any(Trigger.class));
    }

    @Test
    public void testInitialization_ExistingNotificationJob() throws Exception {
        JobKey jobKey = StuckDocumentScheduler.NOTIFICATION_JOB_KEY;
        Mockito.when((Object)this.scheduler.checkExists(jobKey)).thenReturn((Object)true);
        this.stuckDocumentScheduler.onApplicationEvent(this.contextRefreshedEvent);
        ((Scheduler)Mockito.verify((Object)this.scheduler)).checkExists(jobKey);
        ((Scheduler)Mockito.verify((Object)this.scheduler)).deleteJob(jobKey);
    }

    @Test
    public void testEnableAfterInitialization_NotificationJob() throws Exception {
        this.stuckDocumentScheduler.onApplicationEvent(this.contextRefreshedEvent);
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).deleteJob(StuckDocumentScheduler.NOTIFICATION_JOB_KEY);
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(JobDetail.class);
        this.notificationEnabled.setValue("true");
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).scheduleJob((JobDetail)jobCaptor.capture(), (Trigger)Mockito.any(Trigger.class));
        JobDetail jobDetail = (JobDetail)jobCaptor.getValue();
        JobDataMap jobData = jobDetail.getJobDataMap();
        Assert.assertEquals((Object)StuckDocumentScheduler.NOTIFICATION_JOB_KEY, (Object)jobDetail.getKey());
    }

    @Test(expected=IllegalStateException.class)
    public void testInitialization_withSchedulerException() throws Exception {
        Mockito.when((Object)this.scheduler.checkExists((JobKey)Mockito.any(JobKey.class))).thenThrow(new Throwable[]{new SchedulerException()});
        this.stuckDocumentScheduler.onApplicationEvent(this.contextRefreshedEvent);
    }
}

