/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.RuntimeConfig;
import org.kuali.rice.core.api.config.property.SimpleRuntimeConfig;
import org.kuali.rice.kew.impl.stuck.StuckDocumentDao;
import org.kuali.rice.kew.impl.stuck.StuckDocumentFixAttempt;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentServiceImpl;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class StuckDocumentServiceImplTest {
    @Mock
    private StuckDocumentDao dao;
    private SimpleRuntimeConfig failureNotificationEnabled = new SimpleRuntimeConfig("false");
    @InjectMocks
    private StuckDocumentServiceImpl stuckDocumentService;
    private Map<String, StuckDocumentIncident> incidentDatabase;
    private Map<String, StuckDocumentFixAttempt> fixAttemptDatabase;

    @Before
    public void setup() {
        this.stuckDocumentService.setFailureNotificationEnabled((RuntimeConfig)this.failureNotificationEnabled);
        this.incidentDatabase = new HashMap<String, StuckDocumentIncident>();
        this.fixAttemptDatabase = new HashMap<String, StuckDocumentFixAttempt>();
        Mockito.when((Object)this.dao.findIncident((String)Matchers.any())).then(invocation -> this.incidentDatabase.get(invocation.getArgumentAt(0, String.class)));
        Mockito.when((Object)this.dao.saveIncident((StuckDocumentIncident)Matchers.any())).then(invocation -> {
            StuckDocumentIncident incident = (StuckDocumentIncident)invocation.getArgumentAt(0, StuckDocumentIncident.class);
            if (incident.getStuckDocumentIncidentId() == null) {
                incident.setStuckDocumentIncidentId(UUID.randomUUID().toString());
            }
            this.incidentDatabase.put(incident.getStuckDocumentIncidentId(), incident);
            return incident;
        });
        Mockito.when((Object)this.dao.saveFixAttempt((StuckDocumentFixAttempt)Matchers.any())).then(invocation -> {
            StuckDocumentFixAttempt attempt = (StuckDocumentFixAttempt)invocation.getArgumentAt(0, StuckDocumentFixAttempt.class);
            if (attempt.getStuckDocumentFixAttemptId() == null) {
                attempt.setStuckDocumentFixAttemptId(UUID.randomUUID().toString());
            }
            this.fixAttemptDatabase.put(attempt.getStuckDocumentFixAttemptId(), attempt);
            return attempt;
        });
    }

    @Test(expected=NullPointerException.class)
    public void testFindIncident_NullArgument() {
        this.stuckDocumentService.findIncident(null);
    }

    @Test
    public void testFindIncident() {
        List<StuckDocumentIncident> incidents = this.generateAndSaveIncidents(2);
        String incidentId = UUID.randomUUID().toString();
        Assert.assertNull((Object)this.stuckDocumentService.findIncident(incidentId));
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)1))).findIncident(incidentId);
        incidents.forEach(incident -> Assert.assertEquals((Object)incident, (Object)this.stuckDocumentService.findIncident(incident.getStuckDocumentIncidentId())));
    }

    @Test(expected=NullPointerException.class)
    public void testFindIncidents_NullArgument() {
        this.stuckDocumentService.findIncidents(null);
    }

    @Test
    public void testFindIncidents_EmptyList() {
        Assert.assertTrue((boolean)this.stuckDocumentService.findIncidents(Collections.emptyList()).isEmpty());
    }

    @Test
    public void testFindIncidents_BadId() {
        List<StuckDocumentIncident> generatedIncidents = this.generateAndSaveIncidents(5);
        ArrayList<String> incidentIds = new ArrayList<String>();
        incidentIds.add(UUID.randomUUID().toString());
        List incidents = this.stuckDocumentService.findIncidents(incidentIds);
        Assert.assertEquals((long)0L, (long)incidents.size());
        incidentIds.add(generatedIncidents.get(1).getStuckDocumentIncidentId());
        incidents = this.stuckDocumentService.findIncidents(incidentIds);
        Assert.assertEquals((long)1L, (long)incidents.size());
    }

    @Test
    public void testFindIncidents() {
        List<StuckDocumentIncident> incidents = this.generateAndSaveIncidents(5);
        StuckDocumentIncident incident1 = incidents.get(0);
        StuckDocumentIncident incident2 = incidents.get(2);
        StuckDocumentIncident incident3 = incidents.get(4);
        ArrayList<String> incidentIdsToFind = new ArrayList<String>();
        incidentIdsToFind.add(incident1.getStuckDocumentIncidentId());
        incidentIdsToFind.add(incident2.getStuckDocumentIncidentId());
        incidentIdsToFind.add(incident3.getStuckDocumentIncidentId());
        List results = this.stuckDocumentService.findIncidents(incidentIdsToFind);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(incident1));
        Assert.assertTrue((boolean)results.contains(incident2));
        Assert.assertTrue((boolean)results.contains(incident3));
    }

    @Test
    public void testRecordNewStuckDocumentIncidents_NoStuckDocuments() {
        Mockito.when((Object)this.dao.identifyNewStuckDocuments()).thenReturn(Collections.emptyList());
        Assert.assertTrue((boolean)this.stuckDocumentService.recordNewStuckDocumentIncidents().isEmpty());
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)1))).identifyNewStuckDocuments();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.dao});
    }

    @Test
    public void testRecordNewStuckDocumentIncidents() {
        String documentId1 = "123456789";
        String documentId2 = "987654321";
        ArrayList stuckDocumentIds = Lists.newArrayList((Object[])new String[]{documentId1, documentId2});
        Mockito.when((Object)this.dao.identifyNewStuckDocuments()).thenReturn((Object)stuckDocumentIds);
        List newIncidents = this.stuckDocumentService.recordNewStuckDocumentIncidents();
        Assert.assertEquals((long)2L, (long)newIncidents.size());
        List newIncidentDocIds = newIncidents.stream().map(StuckDocumentIncident::getDocumentId).collect(Collectors.toList());
        Assert.assertTrue((boolean)newIncidentDocIds.contains(documentId1));
        Assert.assertTrue((boolean)newIncidentDocIds.contains(documentId2));
        newIncidents.forEach(newIncident -> {
            Assert.assertNotNull((Object)newIncident.getStuckDocumentIncidentId());
            Assert.assertNotNull((Object)newIncident.getDocumentId());
            Assert.assertNotNull((Object)newIncident.getStartDate());
            Assert.assertEquals((Object)StuckDocumentIncident.Status.PENDING, (Object)newIncident.getStatus());
            Assert.assertNull((Object)newIncident.getEndDate());
        });
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)1))).identifyNewStuckDocuments();
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)2))).saveIncident((StuckDocumentIncident)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.dao});
    }

    @Test(expected=NullPointerException.class)
    public void testRecordNewIncidentFixAttempt_NullArgument() {
        this.stuckDocumentService.recordNewIncidentFixAttempt(null);
    }

    @Test
    public void testRecordNewIncidentFixAttempt() {
        StuckDocumentIncident incident = this.generateAndSaveIncident();
        StuckDocumentFixAttempt attempt1 = this.stuckDocumentService.recordNewIncidentFixAttempt(incident);
        Assert.assertNotNull((Object)attempt1.getStuckDocumentFixAttemptId());
        Assert.assertEquals((Object)attempt1, (Object)this.fixAttemptDatabase.get(attempt1.getStuckDocumentFixAttemptId()));
        this.assertRecentTimestamp(attempt1.getTimestamp());
        Assert.assertEquals((Object)incident.getStuckDocumentIncidentId(), (Object)attempt1.getStuckDocumentIncidentId());
        StuckDocumentFixAttempt attempt2 = this.stuckDocumentService.recordNewIncidentFixAttempt(incident);
        Assert.assertNotEquals((Object)attempt1, (Object)attempt2);
        Assert.assertNotNull((Object)attempt2.getStuckDocumentFixAttemptId());
        Assert.assertEquals((Object)attempt2, (Object)this.fixAttemptDatabase.get(attempt2.getStuckDocumentFixAttemptId()));
        this.assertRecentTimestamp(attempt2.getTimestamp());
        Assert.assertEquals((Object)incident.getStuckDocumentIncidentId(), (Object)attempt2.getStuckDocumentIncidentId());
    }

    @Test(expected=NullPointerException.class)
    public void testResolveIncidentsIfPossible_NullArgument() {
        this.stuckDocumentService.resolveIncidentsIfPossible(null);
    }

    @Test
    public void testResolveIncidentsIfPossible_EmptyList() {
        Mockito.when((Object)this.dao.identifyStillStuckDocuments((List)Matchers.any())).thenReturn(Collections.emptyList());
        Assert.assertTrue((boolean)this.stuckDocumentService.resolveIncidentsIfPossible(Collections.emptyList()).isEmpty());
    }

    @Test
    public void testResolveIncidentsIfPossible() {
        List<StuckDocumentIncident> stuck = this.generateAndSaveIncidents(3);
        StuckDocumentIncident incident1 = stuck.get(0);
        StuckDocumentIncident incident2 = stuck.get(1);
        StuckDocumentIncident incident3 = stuck.get(2);
        Mockito.when((Object)this.dao.identifyStillStuckDocuments((List)Matchers.any())).thenReturn((Object)Lists.newArrayList((Object[])new StuckDocumentIncident[]{incident3}));
        List stillStuck = this.stuckDocumentService.resolveIncidentsIfPossible((List)Lists.newArrayList((Object[])new String[]{incident1.getStuckDocumentIncidentId(), incident2.getStuckDocumentIncidentId(), incident3.getStuckDocumentIncidentId()}));
        Assert.assertEquals((long)1L, (long)stillStuck.size());
        Assert.assertEquals((Object)incident3.getStuckDocumentIncidentId(), (Object)((StuckDocumentIncident)stillStuck.get(0)).getStuckDocumentIncidentId());
        StuckDocumentIncident stillStuckIncident = (StuckDocumentIncident)stillStuck.get(0);
        Assert.assertNotEquals((Object)StuckDocumentIncident.Status.FIXED, (Object)stillStuckIncident.getStatus());
        ((StuckDocumentDao)Mockito.verify((Object)this.dao)).deleteIncident(incident1);
        ((StuckDocumentDao)Mockito.verify((Object)this.dao)).deleteIncident(incident2);
    }

    @Test(expected=NullPointerException.class)
    public void testResolve_NullArgument() {
        this.stuckDocumentService.resolve(null);
    }

    @Test
    public void testResolve() {
        StuckDocumentIncident incident = this.generateAndSaveIncident();
        Assert.assertEquals((Object)StuckDocumentIncident.Status.PENDING, (Object)incident.getStatus());
        Assert.assertNull((Object)incident.getEndDate());
        incident = this.stuckDocumentService.startFixingIncident(incident);
        incident = this.stuckDocumentService.resolve(incident);
        Assert.assertEquals((Object)StuckDocumentIncident.Status.FIXED, (Object)incident.getStatus());
        this.assertRecentTimestamp(incident.getEndDate());
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)3))).saveIncident((StuckDocumentIncident)Matchers.any());
    }

    @Test(expected=NullPointerException.class)
    public void testStartFixingIncident_NullArgument() {
        this.stuckDocumentService.startFixingIncident(null);
    }

    @Test
    public void testStartFixingIncident() {
        StuckDocumentIncident incident = this.generateAndSaveIncident();
        Assert.assertEquals((Object)StuckDocumentIncident.Status.PENDING, (Object)incident.getStatus());
        incident = this.stuckDocumentService.startFixingIncident(incident);
        Assert.assertEquals((Object)StuckDocumentIncident.Status.FIXING, (Object)incident.getStatus());
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)2))).saveIncident((StuckDocumentIncident)Matchers.any());
    }

    @Test(expected=NullPointerException.class)
    public void testRecordIncidentFailure_NullArgument() {
        this.stuckDocumentService.recordIncidentFailure(null);
    }

    @Test
    public void testRecordIncidentFailure() {
        StuckDocumentIncident incident = this.generateAndSaveIncident();
        Assert.assertEquals((Object)StuckDocumentIncident.Status.PENDING, (Object)incident.getStatus());
        Assert.assertNull((Object)incident.getEndDate());
        incident = this.stuckDocumentService.recordIncidentFailure(incident);
        Assert.assertEquals((Object)StuckDocumentIncident.Status.FAILED, (Object)incident.getStatus());
        this.assertRecentTimestamp(incident.getEndDate());
        ((StuckDocumentDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.times((int)2))).saveIncident((StuckDocumentIncident)Matchers.any());
    }

    private List<StuckDocumentIncident> generateAndSaveIncidents(int numberOfIncidents) {
        ArrayList incidents = Lists.newArrayList();
        for (int i = 0; i < numberOfIncidents; ++i) {
            incidents.add(this.generateAndSaveIncident());
        }
        return incidents;
    }

    private StuckDocumentIncident generateAndSaveIncident() {
        return this.dao.saveIncident(StuckDocumentIncident.startNewIncident((String)UUID.randomUUID().toString()));
    }

    private void assertRecentTimestamp(Timestamp timestamp) {
        long diff = System.currentTimeMillis() - timestamp.getTime();
        Assert.assertTrue((diff >= 0L && diff < 1000L ? 1 : 0) != 0);
    }
}

