/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.service.impl;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.service.impl.AmazonS3AttachmentServiceImpl;
import org.mockito.ArgumentMatcher;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@RunWith(value=MockitoJUnitRunner.class)
public class AmazonS3AttachmentServiceImplTest {
    private String bucketName = "bucket";
    private String folderName = "folder";
    @Mock
    private ResourceLoader resourceLoader;
    @Mock
    private AmazonS3 amazonS3;
    @InjectMocks
    private AmazonS3AttachmentServiceImpl attachmentService;

    @Before
    public void setUp() throws Exception {
        this.attachmentService.setBucketName(this.bucketName);
        this.attachmentService.setFolderName(this.folderName);
        this.attachmentService.afterPropertiesSet();
    }

    @Test(expected=IllegalStateException.class)
    public void testAfterPropertiesSet_Empty() throws Exception {
        new AmazonS3AttachmentServiceImpl().afterPropertiesSet();
    }

    @Test(expected=IllegalStateException.class)
    public void testAfterPropertiesSet_NoBucket() throws Exception {
        AmazonS3AttachmentServiceImpl service = new AmazonS3AttachmentServiceImpl();
        service.setFolderName("folder");
        service.afterPropertiesSet();
    }

    @Test(expected=IllegalStateException.class)
    public void testAfterPropertiesSet_NoFolder() throws Exception {
        AmazonS3AttachmentServiceImpl service = new AmazonS3AttachmentServiceImpl();
        service.setBucketName("bucket");
        service.afterPropertiesSet();
    }

    public void testPersistAttachedFileAndSetAttachmentBusinessObjectValue() throws Exception {
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFindAttachedFile() throws Exception {
        String fileUrl = "s3://" + this.bucketName + "/" + this.folderName + "/" + UUID.randomUUID().toString();
        Attachment attachment = new Attachment();
        attachment.setFileLoc(fileUrl);
        this.attachmentService.findAttachedFile(attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindAttachedResource() throws Exception {
        String fileUrl = "s3://" + this.bucketName + "/" + this.folderName + "/" + UUID.randomUUID().toString();
        Attachment attachment = new Attachment();
        attachment.setFileLoc(fileUrl);
        File tmpFile = File.createTempFile("testFindAttachedResource_" + this.getClass().getName(), null);
        Assert.assertTrue((boolean)tmpFile.exists());
        FileWriter writer = new FileWriter(tmpFile);
        String fileContent = "testFindAttachedResource";
        writer.write(fileContent);
        writer.close();
        Mockito.when((Object)this.resourceLoader.getResource(fileUrl)).thenReturn((Object)new FileSystemResource(tmpFile));
        try {
            Resource attachedResource = this.attachmentService.findAttachedResource(attachment);
            InputStreamReader reader = new InputStreamReader(attachedResource.getInputStream());
            char[] charbuf = new char[fileContent.length()];
            reader.read(charbuf, 0, fileContent.length());
            reader.close();
            Assert.assertEquals((Object)fileContent, (Object)new String(charbuf));
        }
        finally {
            tmpFile.delete();
        }
    }

    @Test
    public void testDeleteAttachedFile() throws Exception {
        final String generatedObjectKey = UUID.randomUUID().toString();
        String fileUrl = "s3://" + this.bucketName + "/" + this.folderName + "/" + generatedObjectKey;
        Attachment attachment = new Attachment();
        attachment.setFileLoc(fileUrl);
        this.attachmentService.deleteAttachedFile(attachment);
        ((AmazonS3)Mockito.verify((Object)this.amazonS3)).deleteObject((DeleteObjectRequest)Matchers.argThat((Matcher)new ArgumentMatcher<DeleteObjectRequest>(){

            public boolean matches(Object deleteObjectRequest) {
                DeleteObjectRequest request = (DeleteObjectRequest)deleteObjectRequest;
                return AmazonS3AttachmentServiceImplTest.this.bucketName.equals(request.getBucketName()) && request.getKey().equals(AmazonS3AttachmentServiceImplTest.this.folderName + "/" + generatedObjectKey);
            }
        }));
    }
}

