/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.DocumentTypeWindowTargets;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KEWServiceLocator.class})
public class DocumentTypeWindowTargetsTest {
    private static final String _BLANK = "_blank";
    private static final String _SELF = "_self";
    private static final String _PARENT = "_parent";
    private static final String _TOP = "_top";
    private static final List<DocType> DOC_TYPES = new ArrayList<DocType>();
    private static final Map<String, DocType> DOC_TYPE_INDEX = new HashMap<String, DocType>();
    private static final Map<String, DocumentType> DOCUMENT_TYPE_INDEX = new HashMap<String, DocumentType>();
    @Mock
    private DocumentTypeService documentTypeService;

    @Before
    public void setUp() {
        Mockito.when((Object)this.documentTypeService.findParentNameByName(Matchers.anyString())).then(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DocType docType = (DocType)DOC_TYPE_INDEX.get(invocationOnMock.getArguments()[0].toString());
                return docType == null ? null : docType.parentName;
            }
        });
        Mockito.when((Object)this.documentTypeService.findByName(Matchers.anyString())).then(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return DOCUMENT_TYPE_INDEX.get(invocationOnMock.getArguments()[0].toString());
            }
        });
        PowerMockito.mockStatic(KEWServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KEWServiceLocator.getDocumentTypeService()).thenReturn((Object)this.documentTypeService);
    }

    @Test
    public void testNullTargetSpec() throws Exception {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets(null, null, _BLANK, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("whatever"));
    }

    @Test
    public void testBlankTargetSpec() throws Exception {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("", "", _SELF, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_SELF, (Object)targets.getDocumentTarget("whatever"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDefaultDocumentTarget() throws Exception {
        new DocumentTypeWindowTargets("", "", null, "rlt", this.documentTypeService);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDefaultRouteLogTarget() throws Exception {
        new DocumentTypeWindowTargets("", "", "dt", null, this.documentTypeService);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBlankDefaultDocumentTarget() throws Exception {
        new DocumentTypeWindowTargets("", "", "", "rlt", this.documentTypeService);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBlankDefaultRouteLogTarget() throws Exception {
        new DocumentTypeWindowTargets("", "", "dt", "", this.documentTypeService);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDocumentTypeService() throws Exception {
        new DocumentTypeWindowTargets("", "", _TOP, "rlt", null);
    }

    @Test
    public void testFullTargetSpec_NoDefault() throws Exception {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("B:_blank,G:_top,E:_parent", "B:custom,G:_parent,E:_top", _SELF, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("B"));
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("D"));
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("C"));
        Assert.assertEquals((Object)_SELF, (Object)targets.getDocumentTarget("A"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("G"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("H"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("E"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("F"));
        Assert.assertEquals((Object)"custom", (Object)targets.getRouteLogTarget("B"));
        Assert.assertEquals((Object)"custom", (Object)targets.getRouteLogTarget("D"));
        Assert.assertEquals((Object)"custom", (Object)targets.getRouteLogTarget("C"));
        Assert.assertEquals((Object)"rlt", (Object)targets.getRouteLogTarget("A"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getRouteLogTarget("G"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getRouteLogTarget("H"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getRouteLogTarget("E"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getRouteLogTarget("F"));
    }

    @Test
    public void testFullTargetSpec_WithDefinedDefault() throws Exception {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("B:_blank,G:_top,*:_parent", null, _SELF, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("B"));
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("D"));
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("C"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("A"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("G"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("H"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("E"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("F"));
        Assert.assertEquals((Object)"rlt", (Object)targets.getRouteLogTarget("A"));
        Assert.assertEquals((Object)"rlt", (Object)targets.getRouteLogTarget("E"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getRouteLogTarget("I"));
    }

    @Test
    public void testInvalidTargetSpec_IsIgnored() {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("blahblahblah", "blahblahblah", _BLANK, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("A"));
        Assert.assertEquals((Object)"rlt", (Object)targets.getRouteLogTarget("A"));
        targets = new DocumentTypeWindowTargets("blah,blah,B:_top", "blah,blah,B:_parent", _BLANK, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("B"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("C"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("D"));
        Assert.assertEquals((Object)_BLANK, (Object)targets.getDocumentTarget("A"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getRouteLogTarget("B"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getRouteLogTarget("C"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getRouteLogTarget("D"));
        Assert.assertEquals((Object)"rlt", (Object)targets.getRouteLogTarget("A"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTarget_NullValue() {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("", "", _SELF, "rlt", this.documentTypeService);
        targets.getDocumentTarget(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTarget_BlankValue() {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("", "", _SELF, "rlt", this.documentTypeService);
        targets.getDocumentTarget("");
    }

    @Test
    public void testGetTarget_WithDocumentTypePolicy() {
        DocumentTypeWindowTargets targets = new DocumentTypeWindowTargets("", "", _BLANK, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("I"));
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("J"));
        targets = new DocumentTypeWindowTargets("J:_top", null, _BLANK, "rlt", this.documentTypeService);
        Assert.assertEquals((Object)_PARENT, (Object)targets.getDocumentTarget("I"));
        Assert.assertEquals((Object)_TOP, (Object)targets.getDocumentTarget("J"));
    }

    static {
        DocType A = new DocType("A", null);
        DocType B = new DocType("B", "A");
        DocType C = new DocType("C", "B");
        DocType D = new DocType("D", "B");
        DocType E = new DocType("E", null);
        DocType F = new DocType("F", "E");
        DocType G = new DocType("G", "F");
        DocType H = new DocType("H", "G");
        DocType I = new DocType("I", null);
        DocType J = new DocType("J", "I");
        DOC_TYPES.add(A);
        DOC_TYPES.add(B);
        DOC_TYPES.add(C);
        DOC_TYPES.add(D);
        DOC_TYPES.add(E);
        DOC_TYPES.add(F);
        DOC_TYPES.add(G);
        DOC_TYPES.add(H);
        DOC_TYPES.add(I);
        DOC_TYPES.add(J);
        for (DocType docType : DOC_TYPES) {
            DOC_TYPE_INDEX.put(docType.name, docType);
        }
        DocumentType docTypeA = new DocumentType();
        docTypeA.setName("A");
        DOCUMENT_TYPE_INDEX.put("A", docTypeA);
        DocumentType docTypeB = new DocumentType();
        docTypeB.setName("B");
        DOCUMENT_TYPE_INDEX.put("B", docTypeB);
        DocumentType docTypeC = new DocumentType();
        docTypeC.setName("C");
        DOCUMENT_TYPE_INDEX.put("C", docTypeC);
        DocumentType docTypeD = new DocumentType();
        docTypeD.setName("D");
        DOCUMENT_TYPE_INDEX.put("D", docTypeD);
        DocumentType docTypeE = new DocumentType();
        docTypeE.setName("E");
        DOCUMENT_TYPE_INDEX.put("E", docTypeE);
        DocumentType docTypeF = new DocumentType();
        docTypeF.setName("F");
        DOCUMENT_TYPE_INDEX.put("F", docTypeF);
        DocumentType docTypeG = new DocumentType();
        docTypeG.setName("G");
        DOCUMENT_TYPE_INDEX.put("G", docTypeG);
        DocumentType docTypeH = new DocumentType();
        docTypeH.setName("H");
        DOCUMENT_TYPE_INDEX.put("H", docTypeH);
        DocumentType docTypeI = new DocumentType();
        docTypeI.setName("I");
        DOCUMENT_TYPE_INDEX.put("I", docTypeI);
        DocumentType docTypeJ = new DocumentType();
        docTypeJ.setName("J");
        DOCUMENT_TYPE_INDEX.put("J", docTypeJ);
        org.kuali.rice.kew.doctype.DocumentTypePolicy targetPolicy = new org.kuali.rice.kew.doctype.DocumentTypePolicy();
        targetPolicy.setDocumentType(docTypeI);
        targetPolicy.setPolicyName(DocumentTypePolicy.DOC_SEARCH_TARGET.getCode());
        targetPolicy.setPolicyStringValue(_PARENT);
        docTypeI.setDocumentTypePolicies(Collections.singletonList(targetPolicy));
    }

    private static class DocType {
        private final String name;
        private final String parentName;

        DocType(String name, String parentName) {
            this.name = name;
            this.parentName = parentName;
        }
    }
}

