/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import javax.transaction.UserTransaction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.transaction.jta.JtaTransactionManager;

public class TracingTransactionInterceptor
implements MethodInterceptor {
    private static final Logger LOG = Logger.getLogger(TracingTransactionInterceptor.class);
    private Level level;
    private JtaTransactionManager txManager;

    public void setLevel(String lvl) {
        this.level = Level.toLevel((String)lvl);
    }

    public void setJtaTransactionManager(JtaTransactionManager manager) {
        this.txManager = manager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuilder sb = new StringBuilder();
        UserTransaction tx = this.txManager.getUserTransaction();
        if (tx == null) {
            sb.append("null");
        } else {
            sb.append(TracingTransactionInterceptor.toString(tx.getStatus()));
        }
        LOG.log((Priority)this.level, (Object)(invocation.getMethod() + " UserTransaction: " + sb));
        return invocation.proceed();
    }

    private static final String toString(int txStatus) {
        switch (txStatus) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "unknown status: " + txStatus;
    }
}

