/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLSearchableAttributeContent {
    private static final Logger LOG = Logger.getLogger(XMLSearchableAttributeContent.class);
    private ExtensionDefinition def;
    private Element attributeConfig;
    private Node searchingConfig;
    private String searchContent;
    private Map<String, FieldDef> fieldDefs;

    XMLSearchableAttributeContent(ExtensionDefinition ed) {
        this.def = ed;
    }

    XMLSearchableAttributeContent(String configXML) throws SAXException, IOException, ParserConfigurationException {
        this.attributeConfig = XmlHelper.readXml((String)configXML).getDocumentElement();
    }

    XMLSearchableAttributeContent(Element configXML) {
        if (configXML == null) {
            throw new IllegalArgumentException("Configuration element must not be nil");
        }
        this.attributeConfig = configXML;
    }

    Node getSearchingConfig() throws XPathExpressionException, ParserConfigurationException {
        if (this.searchingConfig == null) {
            XPath xpath = XPathHelper.newXPath();
            String searchingConfigExpr = "//searchingConfig";
            this.searchingConfig = (Node)xpath.evaluate(searchingConfigExpr, this.getAttributeConfig(), XPathConstants.NODE);
        }
        return this.searchingConfig;
    }

    String getSearchContent() throws XPathExpressionException, ParserConfigurationException {
        if (this.searchContent == null) {
            Node cfg = this.getSearchingConfig();
            XPath xpath = XPathHelper.newXPath();
            Node n = (Node)xpath.evaluate("xmlSearchContent", cfg, XPathConstants.NODE);
            if (n != null) {
                StringBuilder sb = new StringBuilder();
                NodeList list = n.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    sb.append(XmlJotter.jotNode((Node)list.item(i)));
                }
                this.searchContent = sb.toString();
            }
        }
        return this.searchContent;
    }

    String generateSearchContent(Map<String, String> properties) throws XPathExpressionException, ParserConfigurationException {
        List<FieldDef> fields;
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if ((fields = this.getFieldDefList()).size() == 0) {
            return "";
        }
        String searchContent = this.getSearchContent();
        if (searchContent != null) {
            String generatedContent = searchContent;
            for (FieldDef field : fields) {
                String propValue;
                if (!StringUtils.isNotBlank((String)field.name) || !StringUtils.isNotBlank((String)(propValue = properties.get(field.name)))) continue;
                generatedContent = generatedContent.replaceAll("%" + field.name + "%", propValue);
            }
            return generatedContent;
        }
        StringBuilder buf = new StringBuilder("<xmlRouting>");
        for (FieldDef field : fields) {
            String propValue;
            if (!StringUtils.isNotBlank((String)field.name) || !StringUtils.isNotBlank((String)(propValue = properties.get(field.name)))) continue;
            buf.append("<field name=\"");
            buf.append(field.name);
            buf.append("\"><value>");
            buf.append(propValue);
            buf.append("</value></field>");
        }
        buf.append("</xmlRouting>");
        return buf.toString();
    }

    List<FieldDef> getFieldDefList() throws XPathExpressionException, ParserConfigurationException {
        return Collections.unmodifiableList(new ArrayList<FieldDef>(this.getFieldDefs().values()));
    }

    Map<String, FieldDef> getFieldDefs() throws XPathExpressionException, ParserConfigurationException {
        if (this.fieldDefs == null) {
            this.fieldDefs = new LinkedHashMap<String, FieldDef>();
            XPath xpath = XPathHelper.newXPath();
            Node searchingConfig = this.getSearchingConfig();
            if (searchingConfig != null) {
                NodeList list = (NodeList)xpath.evaluate("fieldDef", searchingConfig, XPathConstants.NODESET);
                for (int i = 0; i < list.getLength(); ++i) {
                    FieldDef def = new FieldDef(list.item(i));
                    this.fieldDefs.put(def.name, def);
                }
            }
        }
        return this.fieldDefs;
    }

    protected Element getAttributeConfig() {
        if (this.attributeConfig == null) {
            try {
                String xmlConfigData = (String)this.def.getConfiguration().get("xmlConfigData");
                this.attributeConfig = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new BufferedReader(new StringReader(xmlConfigData)))).getDocumentElement();
            }
            catch (Exception e) {
                String ruleAttrStr = this.def == null ? null : this.def.getName();
                LOG.error((Object)("error parsing xml data from search attribute: " + ruleAttrStr), (Throwable)e);
                throw new RuntimeException("error parsing xml data from searchable attribute: " + ruleAttrStr, e);
            }
        }
        return this.attributeConfig;
    }

    private static Boolean getBooleanAttr(Node n, String attributeName, Boolean dflt) {
        String nodeValue = XMLSearchableAttributeContent.getStringAttr(n, attributeName);
        return nodeValue == null ? dflt : Boolean.valueOf(nodeValue);
    }

    private static String getStringAttr(Node n, String attributeName) {
        Node attr = n.getAttributes().getNamedItem(attributeName);
        return attr == null ? null : attr.getNodeValue();
    }

    private static String getNodeText(XPath xpath, Node n, String expression) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(expression, n, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    private static Boolean getBoolean(XPath xpath, Node n, String expression) throws XPathExpressionException {
        String val = XMLSearchableAttributeContent.getNodeText(xpath, n, expression);
        return val == null ? null : Boolean.valueOf(val);
    }

    static class FieldDef {
        final String name;
        final String title;
        final String defaultValue;
        final Display display;
        final Validation validation;
        final Visibility visibility;
        final SearchDefinition searchDefinition;
        final String fieldEvaluationExpr;
        final Boolean showResultColumn;
        final Lookup lookup;

        FieldDef(Node n) throws XPathExpressionException {
            XPath xpath = XPathHelper.newXPath();
            this.name = XMLSearchableAttributeContent.getStringAttr(n, "name");
            this.title = XMLSearchableAttributeContent.getStringAttr(n, "title");
            this.defaultValue = XMLSearchableAttributeContent.getNodeText(xpath, n, "value");
            this.fieldEvaluationExpr = XMLSearchableAttributeContent.getNodeText(xpath, n, "fieldEvaluation/xpathexpression");
            this.showResultColumn = XMLSearchableAttributeContent.getBoolean(xpath, n, "resultColumn/@show");
            this.display = new Display(xpath, n);
            this.validation = new Validation(xpath, n);
            this.visibility = new Visibility(xpath, n);
            this.searchDefinition = new SearchDefinition(xpath, n);
            this.lookup = new Lookup(xpath, n, this.name);
        }

        boolean isDisplayedInSearchResults() {
            return this.showResultColumn != null ? this.showResultColumn : (this.visibility.visible != null ? this.visibility.visible : true);
        }

        static class Lookup {
            final String dataObjectClass;
            final Map<String, String> fieldConversions;

            Lookup(XPath xpath, Node n, String fieldName) throws XPathExpressionException {
                String dataObjectClass = null;
                HashMap<String, String> fieldConversions = new HashMap<String, String>();
                Node lookupNode = (Node)xpath.evaluate("lookup", n, XPathConstants.NODE);
                if (lookupNode != null) {
                    NamedNodeMap quickfinderAttributes = lookupNode.getAttributes();
                    Node dataObjectNode = quickfinderAttributes.getNamedItem("dataObjectClass");
                    if (dataObjectNode == null) {
                        dataObjectNode = quickfinderAttributes.getNamedItem("businessObjectClass");
                        if (dataObjectNode != null) {
                            LOG.warn((Object)("Field is using deprecated 'businessObjectClass' instead of 'dataObjectClass' for lookup definition, field name is: " + fieldName));
                        } else {
                            throw new ConfigurationException("Failed to locate 'dataObjectClass' for lookup definition.");
                        }
                    }
                    dataObjectClass = dataObjectNode.getNodeValue();
                    NodeList list = (NodeList)xpath.evaluate("fieldConversions/fieldConversion", lookupNode, XPathConstants.NODESET);
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node fieldConversionChildNode = list.item(i);
                        NamedNodeMap fieldConversionAttributes = fieldConversionChildNode.getAttributes();
                        String lookupFieldName = fieldConversionAttributes.getNamedItem("lookupFieldName").getNodeValue();
                        String localFieldName = fieldConversionAttributes.getNamedItem("localFieldName").getNodeValue();
                        fieldConversions.put(lookupFieldName, localFieldName);
                    }
                }
                this.dataObjectClass = dataObjectClass;
                this.fieldConversions = Collections.unmodifiableMap(fieldConversions);
            }
        }

        static class SearchDefinition {
            final RangeOptions DEFAULTS = new RangeOptions(null, false, false);
            final String dataType;
            final boolean rangeSearch;
            final RangeOptions searchDef;
            final RangeOptions rangeDef;
            final RangeBound lowerBound;
            final RangeBound upperBound;

            SearchDefinition(XPath xpath, Node n) throws XPathExpressionException {
                String dataType = "string";
                RangeOptions searchDefDefaults = new RangeOptions();
                RangeOptions rangeDef = null;
                RangeBound lowerBound = null;
                RangeBound upperBound = null;
                boolean rangeSearch = false;
                Node searchDefNode = (Node)xpath.evaluate("searchDefinition", n, XPathConstants.NODE);
                if (searchDefNode != null) {
                    String s = XMLSearchableAttributeContent.getStringAttr(searchDefNode, "dataType");
                    if (StringUtils.isNotEmpty((String)s)) {
                        dataType = s;
                    }
                    rangeSearch = XMLSearchableAttributeContent.getBooleanAttr(searchDefNode, "rangeSearch", false);
                    searchDefDefaults = new RangeOptions(xpath, searchDefNode, this.DEFAULTS);
                    Node rangeDefinition = (Node)xpath.evaluate("rangeDefinition", searchDefNode, XPathConstants.NODE);
                    if (rangeDefinition != null) {
                        rangeDef = new RangeOptions(xpath, rangeDefinition, searchDefDefaults);
                        Node lower = (Node)xpath.evaluate("lower", rangeDefinition, XPathConstants.NODE);
                        lowerBound = lower == null ? new RangeBound(SearchDefinition.defaultInclusive(rangeDef, true)) : new RangeBound(xpath, lower, SearchDefinition.defaultInclusive(rangeDef, true));
                        Node upper = (Node)xpath.evaluate("upper", rangeDefinition, XPathConstants.NODE);
                        upperBound = upper == null ? new RangeBound(SearchDefinition.defaultInclusive(rangeDef, false)) : new RangeBound(xpath, upper, SearchDefinition.defaultInclusive(rangeDef, false));
                    } else if (rangeSearch) {
                        lowerBound = new RangeBound(SearchDefinition.defaultInclusive(searchDefDefaults, true));
                        upperBound = new RangeBound(SearchDefinition.defaultInclusive(searchDefDefaults, false));
                    }
                }
                this.dataType = dataType;
                this.rangeSearch = rangeSearch;
                this.searchDef = searchDefDefaults;
                this.rangeDef = rangeDef;
                this.lowerBound = lowerBound;
                this.upperBound = upperBound;
            }

            private static BaseRangeOptions defaultInclusive(BaseRangeOptions opts, boolean inclusive) {
                boolean inc = opts.inclusive == null ? inclusive : opts.inclusive;
                return new BaseRangeOptions(inc, opts.datePicker);
            }

            public RangeOptions getRangeBoundOptions() {
                return this.rangeDef == null ? this.searchDef : this.rangeDef;
            }

            public boolean isRangedSearch() {
                return this.rangeSearch || this.rangeDef != null;
            }

            static class RangeBound
            extends BaseRangeOptions {
                final String label;

                RangeBound(BaseRangeOptions defaults) {
                    super(defaults);
                    this.label = null;
                }

                RangeBound(XPath xpath, Node n, BaseRangeOptions defaults) {
                    super(xpath, n, defaults);
                    this.label = XMLSearchableAttributeContent.getStringAttr(n, "label");
                }
            }

            static class RangeOptions
            extends BaseRangeOptions {
                protected final Boolean caseSensitive;

                RangeOptions() {
                    this.caseSensitive = null;
                }

                RangeOptions(Boolean inclusive, Boolean caseSensitive, Boolean datePicker) {
                    super(inclusive, datePicker);
                    this.caseSensitive = caseSensitive;
                }

                RangeOptions(RangeOptions defaults) {
                    super(defaults);
                    this.caseSensitive = defaults.caseSensitive;
                }

                RangeOptions(XPath xpath, Node n, RangeOptions defaults) {
                    super(xpath, n, defaults);
                    this.caseSensitive = XMLSearchableAttributeContent.getBooleanAttr(n, "caseSensitive", defaults.caseSensitive);
                }
            }

            static class BaseRangeOptions {
                protected final Boolean inclusive;
                protected final Boolean datePicker;

                BaseRangeOptions() {
                    this.datePicker = null;
                    this.inclusive = null;
                }

                BaseRangeOptions(Boolean inclusive, Boolean datePicker) {
                    this.inclusive = inclusive;
                    this.datePicker = datePicker;
                }

                BaseRangeOptions(BaseRangeOptions defaults) {
                    this.inclusive = defaults.inclusive;
                    this.datePicker = defaults.datePicker;
                }

                BaseRangeOptions(XPath xpath, Node n, BaseRangeOptions defaults) {
                    this.inclusive = XMLSearchableAttributeContent.getBooleanAttr(n, "inclusive", defaults.inclusive);
                    this.datePicker = XMLSearchableAttributeContent.getBooleanAttr(n, "datePicker", defaults.datePicker);
                }
            }
        }

        static class Visibility {
            final Boolean visible;
            final String type;
            final String groupName;
            final String groupNamespace;

            Visibility(XPath xpath, Node n) throws XPathExpressionException {
                Boolean visible = null;
                String type = null;
                String groupName = null;
                String groupNamespace = null;
                Node node = (Node)xpath.evaluate("(visibility/field | visibility/column | visibility/fieldAndColumn)", n, XPathConstants.NODE);
                if (node != null && node instanceof Element) {
                    Node groupMember;
                    Element visibilityEl = (Element)node;
                    type = visibilityEl.getNodeName();
                    Attr attr = visibilityEl.getAttributeNode("visible");
                    if (attr != null) {
                        visible = Boolean.valueOf(attr.getValue());
                    }
                    if ((groupMember = (Node)xpath.evaluate("(isMemberOfGroup|isMemberOfWorkgroup)", visibilityEl, XPathConstants.NODE)) != null && groupMember instanceof Element) {
                        Element groupMemberEl = (Element)groupMember;
                        boolean group_def_found = false;
                        if ("isMemberOfGroup".equals(groupMember.getNodeName())) {
                            group_def_found = true;
                            groupName = Utilities.substituteConfigParameters(groupMember.getTextContent().trim());
                            groupNamespace = Utilities.substituteConfigParameters(groupMemberEl.getAttribute("namespace")).trim();
                        } else if ("isMemberOfWorkgroup".equals(groupMember.getNodeName())) {
                            group_def_found = true;
                            LOG.warn((Object)"Rule Attribute XML is using deprecated element 'isMemberOfWorkgroup', please use 'isMemberOfGroup' instead.");
                            String workgroupName = Utilities.substituteConfigParameters(groupMember.getTextContent());
                            groupNamespace = Utilities.parseGroupNamespaceCode(workgroupName);
                            groupName = Utilities.parseGroupName(workgroupName);
                        }
                        if (group_def_found) {
                            if (StringUtils.isEmpty((String)groupName) || StringUtils.isEmpty(groupNamespace)) {
                                throw new RuntimeException("Both group name and group namespace must be present for group-based visibility.");
                            }
                            GroupService groupService = KimApiServiceLocator.getGroupService();
                            Group group = groupService.getGroupByNamespaceCodeAndName(groupNamespace, groupName);
                            UserSession session = GlobalVariables.getUserSession();
                            if (session != null) {
                                visible = group == null ? false : groupService.isMemberOfGroup(session.getPerson().getPrincipalId(), group.getId());
                            }
                        }
                    }
                }
                this.visible = visible;
                this.type = type;
                this.groupName = groupName;
                this.groupNamespace = groupNamespace;
            }
        }

        static class Validation {
            final boolean required;
            final String regex;
            final String message;

            Validation(XPath xpath, Node n) throws XPathExpressionException {
                this.required = Boolean.parseBoolean(XMLSearchableAttributeContent.getNodeText(xpath, n, "validation/@required"));
                this.regex = XMLSearchableAttributeContent.getNodeText(xpath, n, "validation/regex");
                this.message = XMLSearchableAttributeContent.getNodeText(xpath, n, "validation/message");
            }
        }

        static class Display {
            final String type;
            final String meta;
            final String formatter;
            final Collection<KeyValue> options;
            final Collection<String> selectedOptions;

            Display(XPath xpath, Node n) throws XPathExpressionException {
                this.type = XMLSearchableAttributeContent.getNodeText(xpath, n, "display/type");
                this.meta = XMLSearchableAttributeContent.getNodeText(xpath, n, "display/meta");
                this.formatter = XMLSearchableAttributeContent.getNodeText(xpath, n, "display/formatter");
                ArrayList<ConcreteKeyValue> options = new ArrayList<ConcreteKeyValue>();
                ArrayList<String> selectedOptions = new ArrayList<String>();
                NodeList nodes = (NodeList)xpath.evaluate("display[1]/values", n, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    boolean selected = XMLSearchableAttributeContent.getBooleanAttr(node, "selected", false);
                    String title = XMLSearchableAttributeContent.getStringAttr(node, "title");
                    String value = node.getTextContent();
                    if (value == null) {
                        value = "";
                    }
                    options.add(new ConcreteKeyValue(value, title));
                    if (!selected) continue;
                    selectedOptions.add(node.getTextContent());
                }
                this.options = Collections.unmodifiableCollection(options);
                this.selectedOptions = Collections.unmodifiableCollection(selectedOptions);
            }
        }
    }
}

