/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.NodeGraphContext;
import org.kuali.rice.kew.engine.node.NodeGraphSearchCriteria;
import org.kuali.rice.kew.engine.node.NodeGraphSearchResult;
import org.kuali.rice.kew.engine.node.NodeMatcher;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.RouteNodeUtils;
import org.kuali.rice.kew.engine.node.dao.RouteNodeDAO;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class RouteNodeServiceImpl
implements RouteNodeService {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    public static final String REVOKED_NODE_INSTANCES_STATE_KEY = "NodeInstances.Revoked";
    private static final Comparator NODE_INSTANCE_FORWARD_SORT = new NodeInstanceIdSorter();
    private static final Comparator NODE_INSTANCE_BACKWARD_SORT = ComparatorUtils.reversedComparator((Comparator)NODE_INSTANCE_FORWARD_SORT);
    private RouteHelper helper = new RouteHelper();
    private RouteNodeDAO routeNodeDAO;
    private DataObjectService dataObjectService;

    @Override
    public RouteNode save(RouteNode node) {
        return (RouteNode)this.dataObjectService.save((Object)node, new PersistenceOption[0]);
    }

    @Override
    public RouteNodeInstance save(RouteNodeInstance nodeInstance) {
        return (RouteNodeInstance)this.dataObjectService.save((Object)nodeInstance, new PersistenceOption[0]);
    }

    @Override
    public void save(NodeState nodeState) {
        this.dataObjectService.save((Object)nodeState, new PersistenceOption[0]);
    }

    @Override
    public Branch save(Branch branch) {
        return (Branch)this.dataObjectService.save((Object)branch, new PersistenceOption[0]);
    }

    @Override
    public RouteNode findRouteNodeById(String nodeId) {
        return (RouteNode)this.dataObjectService.find(RouteNode.class, (Object)nodeId);
    }

    @Override
    public RouteNodeInstance findRouteNodeInstanceById(String nodeInstanceId) {
        return this.routeNodeDAO.findRouteNodeInstanceById(nodeInstanceId);
    }

    @Override
    public RouteNodeInstance findRouteNodeInstanceById(String nodeInstanceId, DocumentRouteHeaderValue document) {
        return RouteNodeUtils.findRouteNodeInstanceById(nodeInstanceId, document);
    }

    @Override
    public List<RouteNodeInstance> getCurrentNodeInstances(String documentId) {
        List<RouteNodeInstance> currentNodeInstances = this.getActiveNodeInstances(documentId);
        if (currentNodeInstances.isEmpty()) {
            currentNodeInstances = this.getTerminalNodeInstances(documentId);
        }
        return currentNodeInstances;
    }

    @Override
    public List<RouteNodeInstance> getActiveNodeInstances(String documentId) {
        return this.routeNodeDAO.getActiveNodeInstances(documentId);
    }

    @Override
    public List<RouteNodeInstance> getActiveNodeInstances(DocumentRouteHeaderValue document) {
        List<RouteNodeInstance> flattenedNodeInstances = this.getFlattenedNodeInstances(document, true);
        ArrayList<RouteNodeInstance> activeNodeInstances = new ArrayList<RouteNodeInstance>();
        for (RouteNodeInstance nodeInstance : flattenedNodeInstances) {
            if (!nodeInstance.isActive()) continue;
            activeNodeInstances.add(nodeInstance);
        }
        return activeNodeInstances;
    }

    @Override
    public List<String> getCurrentRouteNodeNames(String documentId) {
        return this.routeNodeDAO.getCurrentRouteNodeNames(documentId);
    }

    @Override
    public List<String> getCurrentSimpleRouteNodeNames(String documentId) {
        return this.routeNodeDAO.getCurrentSimpleRouteNodeNames(documentId);
    }

    @Override
    public List<String> getActiveRouteNodeNames(String documentId) {
        return this.routeNodeDAO.getActiveRouteNodeNames(documentId);
    }

    @Override
    public List<String> getActiveSimpleRouteNodeNames(String documentId) {
        return this.routeNodeDAO.getActiveSimpleRouteNodeNames(documentId);
    }

    @Override
    public List<RouteNodeInstance> getTerminalNodeInstances(String documentId) {
        return this.routeNodeDAO.getTerminalNodeInstances(documentId);
    }

    @Override
    public List<String> getTerminalRouteNodeNames(String documentId) {
        return this.routeNodeDAO.getTerminalRouteNodeNames(documentId);
    }

    @Override
    public List getInitialNodeInstances(String documentId) {
        return this.routeNodeDAO.getInitialNodeInstances(documentId);
    }

    @Override
    public NodeState findNodeState(Long nodeInstanceId, String key) {
        return this.routeNodeDAO.findNodeState(nodeInstanceId, key);
    }

    @Override
    public RouteNode findRouteNodeByName(String documentTypeId, String name) {
        return this.routeNodeDAO.findRouteNodeByName(documentTypeId, name);
    }

    @Override
    public List<RouteNode> findFinalApprovalRouteNodes(String documentTypeId) {
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findById(documentTypeId);
        documentType = documentType.getRouteDefiningDocumentType();
        return this.routeNodeDAO.findFinalApprovalRouteNodes(documentType.getDocumentTypeId());
    }

    @Override
    public List findNextRouteNodesInPath(RouteNodeInstance nodeInstance, String nodeName) {
        ArrayList<RouteNode> nodesInPath = new ArrayList<RouteNode>();
        for (RouteNode nextNode : nodeInstance.getRouteNode().getNextNodes()) {
            nodesInPath.addAll(this.findNextRouteNodesInPath(nodeName, nextNode, new HashSet<String>()));
        }
        return nodesInPath;
    }

    private List<RouteNode> findNextRouteNodesInPath(String nodeName, RouteNode node, Set<String> inspected) {
        ArrayList<RouteNode> nextNodesInPath = new ArrayList<RouteNode>();
        if (inspected.contains(node.getRouteNodeId())) {
            return nextNodesInPath;
        }
        inspected.add(node.getRouteNodeId());
        if (node.getRouteNodeName().equals(nodeName)) {
            nextNodesInPath.add(node);
        } else {
            ProcessDefinitionBo subProcess;
            RouteNode subNode;
            if (this.helper.isSubProcessNode(node) && (subNode = (subProcess = node.getDocumentType().getNamedProcess(node.getRouteNodeName())).getInitialRouteNode()) != null) {
                nextNodesInPath.addAll(this.findNextRouteNodesInPath(nodeName, subNode, inspected));
            }
            for (RouteNode nextNode : node.getNextNodes()) {
                nextNodesInPath.addAll(this.findNextRouteNodesInPath(nodeName, nextNode, inspected));
            }
        }
        return nextNodesInPath;
    }

    @Override
    public boolean isNodeInPath(DocumentRouteHeaderValue document, String nodeName) {
        boolean isInPath = false;
        List<RouteNodeInstance> activeNodes = this.getActiveNodeInstances(document.getDocumentId());
        for (RouteNodeInstance nodeInstance : activeNodes) {
            List nextNodesInPath = this.findNextRouteNodesInPath(nodeInstance, nodeName);
            isInPath = isInPath || !nextNodesInPath.isEmpty();
        }
        return isInPath;
    }

    @Override
    public List findRouteNodeInstances(String documentId) {
        return this.routeNodeDAO.findRouteNodeInstances(documentId);
    }

    public void setRouteNodeDAO(RouteNodeDAO dao) {
        this.routeNodeDAO = dao;
    }

    @Override
    public List findProcessNodeInstances(RouteNodeInstance process) {
        return this.routeNodeDAO.findProcessNodeInstances(process);
    }

    @Override
    public List<String> findPreviousNodeNames(String documentId) {
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        List<Object> revokedIds = Collections.emptyList();
        ArrayList<String> nodeNames = new ArrayList<String>();
        if (document.getRootBranch() != null) {
            String revoked;
            String string = revoked = document.getRootBranch().getBranchState(REVOKED_NODE_INSTANCES_STATE_KEY) == null ? null : document.getRootBranch().getBranchState(REVOKED_NODE_INSTANCES_STATE_KEY).getValue();
            if (revoked != null) {
                revokedIds = Arrays.asList(revoked.split(","));
            }
            List<RouteNodeInstance> currentNodeInstances = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(documentId);
            ArrayList<RouteNodeInstance> nodeInstances = new ArrayList<RouteNodeInstance>();
            for (RouteNodeInstance nodeInstance : currentNodeInstances) {
                nodeInstances.addAll(nodeInstance.getPreviousNodeInstances());
            }
            while (!nodeInstances.isEmpty()) {
                RouteNodeInstance nodeInstance = (RouteNodeInstance)nodeInstances.remove(0);
                if (!revokedIds.contains(nodeInstance.getRouteNodeInstanceId())) {
                    nodeNames.add(nodeInstance.getName());
                }
                nodeInstances.addAll(nodeInstance.getPreviousNodeInstances());
            }
            Collections.reverse(nodeNames);
        }
        return nodeNames;
    }

    @Override
    public List<String> findFutureNodeNames(String documentId) {
        List<RouteNodeInstance> currentNodeInstances = KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(documentId);
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        for (RouteNodeInstance nodeInstance : currentNodeInstances) {
            nodes.addAll(nodeInstance.getRouteNode().getNextNodes());
        }
        ArrayList<String> nodeNames = new ArrayList<String>();
        while (!nodes.isEmpty()) {
            RouteNode node = (RouteNode)nodes.remove(0);
            if (!nodeNames.contains(node.getRouteNodeName())) {
                nodeNames.add(node.getRouteNodeName());
            }
            nodes.addAll(node.getNextNodes());
        }
        return nodeNames;
    }

    @Override
    public List<RouteNode> getFlattenedNodes(DocumentType documentType, boolean climbHierarchy) {
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        if (!documentType.isRouteInherited() || climbHierarchy) {
            for (ProcessDefinitionBo process : documentType.getProcesses()) {
                nodes.addAll(this.getFlattenedNodes(process));
            }
        }
        Collections.sort(nodes, new RouteNodeSorter());
        return nodes;
    }

    @Override
    public List<RouteNode> getFlattenedNodes(ProcessDefinitionBo process) {
        HashMap<String, RouteNode> nodesMap = new HashMap<String, RouteNode>();
        if (process.getInitialRouteNode() != null) {
            this.flattenNodeGraph(nodesMap, process.getInitialRouteNode());
            ArrayList<RouteNode> nodes = new ArrayList<RouteNode>(nodesMap.values());
            Collections.sort(nodes, new RouteNodeSorter());
            return nodes;
        }
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        nodes.add(new RouteNode());
        return nodes;
    }

    private void flattenNodeGraph(Map<String, RouteNode> nodes, RouteNode node) {
        if (node != null) {
            if (nodes.containsKey(node.getRouteNodeName())) {
                return;
            }
            nodes.put(node.getRouteNodeName(), node);
            for (RouteNode nextNode : node.getNextNodes()) {
                this.flattenNodeGraph(nodes, nextNode);
            }
        } else {
            return;
        }
    }

    @Override
    public List<RouteNodeInstance> getFlattenedNodeInstances(DocumentRouteHeaderValue document, boolean includeProcesses) {
        ArrayList<RouteNodeInstance> nodeInstances = new ArrayList<RouteNodeInstance>();
        HashSet<String> visitedNodeInstanceIds = new HashSet<String>();
        for (RouteNodeInstance initialNodeInstance : document.getInitialRouteNodeInstances()) {
            this.flattenNodeInstanceGraph(nodeInstances, visitedNodeInstanceIds, initialNodeInstance, includeProcesses);
        }
        return nodeInstances;
    }

    private void flattenNodeInstanceGraph(List<RouteNodeInstance> nodeInstances, Set<String> visitedNodeInstanceIds, RouteNodeInstance nodeInstance, boolean includeProcesses) {
        if (nodeInstance != null) {
            if (visitedNodeInstanceIds.contains(nodeInstance.getRouteNodeInstanceId())) {
                return;
            }
            if (includeProcesses && nodeInstance.getProcess() != null) {
                this.flattenNodeInstanceGraph(nodeInstances, visitedNodeInstanceIds, nodeInstance.getProcess(), includeProcesses);
            }
            visitedNodeInstanceIds.add(nodeInstance.getRouteNodeInstanceId());
            nodeInstances.add(nodeInstance);
            for (RouteNodeInstance nextNodeInstance : nodeInstance.getNextNodeInstances()) {
                this.flattenNodeInstanceGraph(nodeInstances, visitedNodeInstanceIds, nextNodeInstance, includeProcesses);
            }
        }
    }

    @Override
    public NodeGraphSearchResult searchNodeGraph(NodeGraphSearchCriteria criteria) {
        NodeGraphContext context = new NodeGraphContext();
        if (criteria.getSearchDirection() != 2) {
            throw new UnsupportedOperationException("Search feature can only search backward currently.");
        }
        this.searchNodeGraphBackward(context, criteria.getMatcher(), null, criteria.getStartingNodeInstances());
        List exactPath = this.determineExactPath(context, criteria.getSearchDirection(), criteria.getStartingNodeInstances());
        return new NodeGraphSearchResult(context.getCurrentNodeInstance(), exactPath);
    }

    private void searchNodeGraphBackward(NodeGraphContext context, NodeMatcher matcher, RouteNodeInstance previousNodeInstance, Collection nodeInstances) {
        if (nodeInstances == null) {
            return;
        }
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            context.setPreviousNodeInstance(previousNodeInstance);
            context.setCurrentNodeInstance(nodeInstance);
            this.searchNodeGraphBackward(context, matcher);
            if (context.getResultNodeInstance() == null) continue;
            break;
        }
    }

    private void searchNodeGraphBackward(NodeGraphContext context, NodeMatcher matcher) {
        RouteNodeInstance current = context.getCurrentNodeInstance();
        int numBranches = current.getNextNodeInstances().size();
        if (numBranches > 1) {
            Integer joinCount = context.getSplitState().get(current.getRouteNodeInstanceId());
            if (joinCount == null) {
                joinCount = new Integer(0);
            }
            if (context.getPreviousNodeInstance() != null) {
                joinCount = new Integer(joinCount + 1);
            }
            context.getSplitState().put(current.getRouteNodeInstanceId(), joinCount);
            if (joinCount != numBranches) {
                return;
            }
        }
        if (matcher.isMatch(context)) {
            context.setResultNodeInstance(current);
        } else {
            context.getVisited().put(current.getRouteNodeInstanceId(), current);
            this.searchNodeGraphBackward(context, matcher, current, current.getPreviousNodeInstances());
        }
    }

    @Override
    public List<RouteNodeInstance> getActiveNodeInstances(DocumentRouteHeaderValue document, String nodeName) {
        List<RouteNodeInstance> activeNodes = this.getActiveNodeInstances(document.getDocumentId());
        ArrayList<RouteNodeInstance> foundNodes = new ArrayList<RouteNodeInstance>();
        for (RouteNodeInstance nodeInstance : activeNodes) {
            if (!nodeInstance.getName().equals(nodeName)) continue;
            foundNodes.add(nodeInstance);
        }
        return foundNodes;
    }

    private List determineExactPath(NodeGraphContext context, int searchDirection, Collection<RouteNodeInstance> startingNodeInstances) {
        ArrayList<RouteNodeInstance> exactPath = new ArrayList<RouteNodeInstance>();
        if (context.getResultNodeInstance() == null) {
            exactPath.addAll(context.getVisited().values());
        } else {
            this.determineExactPath(exactPath, new HashMap<String, RouteNodeInstance>(), startingNodeInstances, context.getResultNodeInstance());
        }
        if (1 == searchDirection) {
            Collections.sort(exactPath, NODE_INSTANCE_BACKWARD_SORT);
        } else {
            Collections.sort(exactPath, NODE_INSTANCE_FORWARD_SORT);
        }
        return exactPath;
    }

    private void determineExactPath(List<RouteNodeInstance> exactPath, Map<String, RouteNodeInstance> visited, Collection<RouteNodeInstance> startingNodeInstances, RouteNodeInstance nodeInstance) {
        if (nodeInstance == null) {
            return;
        }
        if (visited.containsKey(nodeInstance.getRouteNodeInstanceId())) {
            return;
        }
        visited.put(nodeInstance.getRouteNodeInstanceId(), nodeInstance);
        exactPath.add(nodeInstance);
        for (RouteNodeInstance startingNode : startingNodeInstances) {
            if (!startingNode.getRouteNodeInstanceId().equals(nodeInstance.getRouteNodeInstanceId())) continue;
            return;
        }
        for (RouteNodeInstance nextNodeInstance : nodeInstance.getNextNodeInstances()) {
            this.determineExactPath(exactPath, visited, startingNodeInstances, nextNodeInstance);
        }
    }

    @Override
    public void deleteByRouteNodeInstance(RouteNodeInstance routeNodeInstance) {
        this.routeNodeDAO.deleteLinksToPreNodeInstances(routeNodeInstance);
        this.routeNodeDAO.deleteRouteNodeInstancesHereAfter(routeNodeInstance);
    }

    @Override
    public void deleteNodeStateById(Long nodeStateId) {
        this.routeNodeDAO.deleteNodeStateById(nodeStateId);
    }

    @Override
    public void deleteNodeStates(List statesToBeDeleted) {
        this.routeNodeDAO.deleteNodeStates(statesToBeDeleted);
    }

    @Override
    public void revokeNodeInstance(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        if (document == null) {
            throw new IllegalArgumentException("Document must not be null.");
        }
        if (nodeInstance == null || nodeInstance.getRouteNodeInstanceId() == null) {
            throw new IllegalArgumentException("In order to revoke a final approval node the node instance must be persisent and have an id.");
        }
        Branch rootBranch = document.getRootBranch();
        BranchState state = null;
        if (rootBranch != null) {
            state = rootBranch.getBranchState(REVOKED_NODE_INSTANCES_STATE_KEY);
        }
        if (state == null) {
            state = new BranchState();
            state.setKey(REVOKED_NODE_INSTANCES_STATE_KEY);
            state.setValue("");
            rootBranch.addBranchState(state);
        }
        if (state.getValue() == null) {
            state.setValue("");
        }
        state.setValue(state.getValue() + nodeInstance.getRouteNodeInstanceId() + ",");
        this.save(rootBranch);
    }

    @Override
    public List getRevokedNodeInstances(DocumentRouteHeaderValue document) {
        if (document == null) {
            throw new IllegalArgumentException("Document must not be null.");
        }
        ArrayList<RouteNodeInstance> revokedNodeInstances = new ArrayList<RouteNodeInstance>();
        Branch rootBranch = document.getRootBranch();
        BranchState state = null;
        if (rootBranch != null) {
            state = rootBranch.getBranchState(REVOKED_NODE_INSTANCES_STATE_KEY);
        }
        if (state == null || StringUtils.isEmpty((String)state.getValue())) {
            return revokedNodeInstances;
        }
        String[] revokedNodes = state.getValue().split(",");
        for (int index = 0; index < revokedNodes.length; ++index) {
            String revokedNodeInstanceId = revokedNodes[index];
            RouteNodeInstance revokedNodeInstance = this.findRouteNodeInstanceById(revokedNodeInstanceId);
            if (revokedNodeInstance == null) {
                this.LOG.warn((Object)("Could not locate revoked RouteNodeInstance with the given id: " + revokedNodeInstanceId));
                continue;
            }
            revokedNodeInstances.add(revokedNodeInstance);
        }
        return revokedNodeInstances;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    private static class NodeInstanceIdSorter
    implements Comparator {
        private NodeInstanceIdSorter() {
        }

        public int compare(Object arg0, Object arg1) {
            RouteNodeInstance nodeInstance1 = (RouteNodeInstance)arg0;
            RouteNodeInstance nodeInstance2 = (RouteNodeInstance)arg1;
            return nodeInstance1.getRouteNodeInstanceId().compareTo(nodeInstance2.getRouteNodeInstanceId());
        }
    }

    private static class RouteNodeSorter
    implements Comparator {
        private RouteNodeSorter() {
        }

        public int compare(Object arg0, Object arg1) {
            RouteNode rn1 = (RouteNode)arg0;
            RouteNode rn2 = (RouteNode)arg1;
            return rn1.getRouteNodeId().compareTo(rn2.getRouteNodeId());
        }
    }
}

