/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kuali.rice.kew.impl.stuck.AutofixDocumentsJob;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutofixCollectorJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(AutofixCollectorJob.class);
    private static final int PARTITION_SIZE = 50;
    private static final String AUTOFIX_JOB_KEY_PREFIX = "Autofix Documents Job - ";
    static final String AUTOFIX_QUIET_PERIOD_KEY = "autofixQuietPeriod";
    static final String AUTOFIX_MAX_ATTEMPTS_KEY = "autofixMaxAttempts";
    private volatile StuckDocumentService stuckDocumentService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.checkDependenciesAvailable();
        List<StuckDocumentIncident> newIncidents = this.getStuckDocumentService().recordNewStuckDocumentIncidents();
        if (!newIncidents.isEmpty()) {
            LOG.info("Identified " + newIncidents.size() + " new stuck documents");
            LOG.info("Scheduling jobs to attempt to fix the following documents: " + newIncidents.stream().map(StuckDocumentIncident::getDocumentId).collect(Collectors.joining(", ")));
            this.partitionAndScheduleAutofixJobs(newIncidents, context);
        }
    }

    private void checkDependenciesAvailable() throws JobExecutionException {
        if (this.getStuckDocumentService() == null) {
            String message = "Dependencies are not available for the autofix collector job";
            LOG.warn(message);
            throw new JobExecutionException(message);
        }
    }

    private void partitionAndScheduleAutofixJobs(List<StuckDocumentIncident> incidents, JobExecutionContext context) {
        Lists.partition(incidents, (int)50).forEach(incidentsPartition -> this.scheduleAutofixJobs((List<StuckDocumentIncident>)incidentsPartition, context));
    }

    private void scheduleAutofixJobs(List<StuckDocumentIncident> incidents, JobExecutionContext context) {
        List incidentIds = incidents.stream().map(StuckDocumentIncident::getStuckDocumentIncidentId).collect(Collectors.toList());
        String jobKey = this.generateAutofixJobKey();
        int autofixQuietPeriod = this.autofixQuietPeriod(context);
        int autofixMaxAttempts = this.autofixMaxAttempts(context);
        JobDetail job = JobBuilder.newJob(AutofixDocumentsJob.class).withIdentity(jobKey).usingJobData(context.getMergedJobDataMap()).usingJobData("incidentIds", String.join((CharSequence)",", incidentIds)).usingJobData("currentAutofixCount", Integer.valueOf(0)).build();
        Trigger trigger = TriggerBuilder.newTrigger().forJob(job).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(autofixQuietPeriod).withRepeatCount(autofixMaxAttempts).withMisfireHandlingInstructionNextWithExistingCount()).startAt(DateBuilder.futureDate((int)autofixQuietPeriod, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).build();
        try {
            context.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Failed to schedule autofix job", e);
        }
    }

    private String generateAutofixJobKey() {
        return AUTOFIX_JOB_KEY_PREFIX + UUID.randomUUID().toString();
    }

    private int autofixMaxAttempts(JobExecutionContext context) {
        return context.getMergedJobDataMap().getInt(AUTOFIX_MAX_ATTEMPTS_KEY);
    }

    private int autofixQuietPeriod(JobExecutionContext context) {
        return context.getMergedJobDataMap().getInt(AUTOFIX_QUIET_PERIOD_KEY);
    }

    protected StuckDocumentService getStuckDocumentService() {
        if (this.stuckDocumentService == null) {
            this.stuckDocumentService = KEWServiceLocator.getStuckDocumentService();
        }
        return this.stuckDocumentService;
    }

    public void setStuckDocumentService(StuckDocumentService stuckDocumentService) {
        this.stuckDocumentService = stuckDocumentService;
    }
}

