/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import java.util.List;
import org.kuali.rice.kew.impl.stuck.StuckDocument;
import org.kuali.rice.kew.impl.stuck.StuckDocumentNotifier;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StuckDocumentNotificationJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(StuckDocumentNotificationJob.class);
    private volatile StuckDocumentService stuckDocumentService;
    private volatile StuckDocumentNotifier notifier;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.checkDependenciesAvailable();
        List<StuckDocument> stuckDocuments = this.getStuckDocumentService().findAllStuckDocuments();
        if (!stuckDocuments.isEmpty()) {
            this.getNotifier().notify(stuckDocuments);
        }
    }

    private void checkDependenciesAvailable() throws JobExecutionException {
        if (this.getStuckDocumentService() == null || this.getNotifier() == null) {
            String message = "Dependencies are not available for the stuck document notification job";
            LOG.warn(message);
            throw new JobExecutionException(message);
        }
    }

    protected StuckDocumentService getStuckDocumentService() {
        if (this.stuckDocumentService == null) {
            this.stuckDocumentService = KEWServiceLocator.getStuckDocumentService();
        }
        return this.stuckDocumentService;
    }

    public void setStuckDocumentService(StuckDocumentService stuckDocumentService) {
        this.stuckDocumentService = stuckDocumentService;
    }

    protected StuckDocumentNotifier getNotifier() {
        if (this.notifier == null) {
            this.notifier = KEWServiceLocator.getStuckDocumentNotifier();
        }
        return this.notifier;
    }

    public void setNotifier(StuckDocumentNotifier notifier) {
        this.notifier = notifier;
    }
}

