/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import org.kuali.rice.core.api.config.property.RuntimeConfig;
import org.kuali.rice.core.api.config.property.RuntimeConfigSet;
import org.kuali.rice.kew.impl.stuck.AutofixCollectorJob;
import org.kuali.rice.kew.impl.stuck.StuckDocumentNotificationJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class StuckDocumentScheduler
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(StuckDocumentScheduler.class);
    protected static final JobKey NOTIFICATION_JOB_KEY = JobKey.jobKey((String)"StuckDocuments", (String)"Notification");
    protected static final JobKey AUTOFIX_COLLECTOR_JOB_KEY = JobKey.jobKey((String)"StuckDocuments", (String)"AutofixCollector");
    private Scheduler scheduler;
    private RuntimeConfig notificationEnabled;
    private RuntimeConfig notificationCronExpression;
    private RuntimeConfig autofixEnabled;
    private RuntimeConfig autofixCronExpression;
    private RuntimeConfig autofixQuietPeriod;
    private RuntimeConfig autofixMaxAttempts;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        this.achieveDesiredState();
        RuntimeConfigSet configSet = new RuntimeConfigSet(new RuntimeConfig[]{this.notificationEnabled, this.notificationCronExpression, this.autofixEnabled, this.autofixCronExpression, this.autofixQuietPeriod, this.autofixMaxAttempts});
        configSet.listen(this::configChanged);
    }

    private void configChanged(RuntimeConfigSet configSet) {
        LOG.info("StuckDocumentScheduler config was changed, rebuilding job.");
        this.achieveDesiredState();
    }

    private void achieveDesiredState() {
        try {
            this.scheduleNotificationJob();
            this.scheduleAutofixCollectorJob();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Scheduling failure when attempting to configure Stuck Document jobs", e);
        }
    }

    private void scheduleNotificationJob() throws SchedulerException {
        this.unscheduleJobIfExists(NOTIFICATION_JOB_KEY);
        if (this.notificationEnabled.getValueAsBoolean().booleanValue()) {
            JobDetail job = JobBuilder.newJob(StuckDocumentNotificationJob.class).withIdentity(NOTIFICATION_JOB_KEY).build();
            LOG.info("Stuck Documents Notification job is enabled, scheduling with cron expression " + this.notificationCronExpression.getValue());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.notificationCronExpression.getValue()).withMisfireHandlingInstructionDoNothing();
            Trigger trigger = TriggerBuilder.newTrigger().forJob(job).startNow().withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(job, trigger);
        } else {
            LOG.info("Stuck Documents Notification job is disabled.");
        }
    }

    private void scheduleAutofixCollectorJob() throws SchedulerException {
        this.unscheduleJobIfExists(AUTOFIX_COLLECTOR_JOB_KEY);
        if (this.autofixEnabled.getValueAsBoolean().booleanValue()) {
            JobDetail job = JobBuilder.newJob(AutofixCollectorJob.class).withIdentity(AUTOFIX_COLLECTOR_JOB_KEY).usingJobData("autofixQuietPeriod", this.autofixQuietPeriod.getValueAsInteger()).usingJobData("autofixMaxAttempts", this.autofixMaxAttempts.getValueAsInteger()).build();
            LOG.info("Stuck Documents Autofix job is enabled, scheduling with cron expression " + this.autofixCronExpression.getValue());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.autofixCronExpression.getValue()).withMisfireHandlingInstructionDoNothing();
            Trigger trigger = TriggerBuilder.newTrigger().forJob(job).startNow().withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(job, trigger);
        } else {
            LOG.info("Stuck Documents Autofix job is disabled.");
        }
    }

    private void unscheduleJobIfExists(JobKey jobKey) throws SchedulerException {
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
        }
    }

    @Required
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Required
    public void setNotificationEnabled(RuntimeConfig notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    @Required
    public void setNotificationCronExpression(RuntimeConfig notificationCronExpression) {
        this.notificationCronExpression = notificationCronExpression;
    }

    @Required
    public void setAutofixEnabled(RuntimeConfig autofixEnabled) {
        this.autofixEnabled = autofixEnabled;
    }

    @Required
    public void setAutofixCronExpression(RuntimeConfig autofixCronExpression) {
        this.autofixCronExpression = autofixCronExpression;
    }

    @Required
    public void setAutofixQuietPeriod(RuntimeConfig autofixQuietPeriod) {
        this.autofixQuietPeriod = autofixQuietPeriod;
    }

    @Required
    public void setAutofixMaxAttempts(RuntimeConfig autofixMaxAttempts) {
        this.autofixMaxAttempts = autofixMaxAttempts;
    }
}

