/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.BSFRuleExpression;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleExpressionResult;

public class AccumulatingBSFRuleExpression
extends BSFRuleExpression {
    private static final Logger LOG = Logger.getLogger(AccumulatingBSFRuleExpression.class);

    @Override
    protected void declareBeans(ScriptEngine engine, Rule rule, RouteContext context) throws ScriptException {
        super.declareBeans(engine, rule, context);
        RuleHelper rh = new RuleHelper(rule, context);
        engine.put("metarule", rh);
        engine.put("rulehelper", rh);
    }

    private static final class RuleHelper {
        private Rule rule;
        private BSFRuleExpression.WorkflowRuleAPI workflow;
        private List<RuleResponsibility> responsibilities = new ArrayList<RuleResponsibility>();
        private int responsibilityPriority = 0;

        private RuleHelper(Rule rule, RouteContext context) {
            this.workflow = new BSFRuleExpression.WorkflowRuleAPI(context);
            this.rule = rule;
        }

        public List<RuleResponsibility> getResponsibilities() {
            return this.responsibilities;
        }

        public RuleExpressionResult getResult(boolean success) {
            return new RuleExpressionResult(this.rule, success, this.responsibilities);
        }

        public void accumulate(RuleExpressionResult result) {
            if (result.getResponsibilities() == null || result.getResponsibilities().size() == 0) {
                return;
            }
            Integer curPriority = this.responsibilityPriority;
            for (RuleResponsibility responsibility : result.getResponsibilities()) {
                RuleResponsibility.Builder builder = RuleResponsibility.Builder.create((RuleResponsibilityContract)responsibility);
                builder.setPriority(curPriority);
                this.responsibilities.add(builder.build());
            }
            ++this.responsibilityPriority;
        }

        public boolean evalRule(String ruleName) throws WorkflowException {
            RuleExpressionResult result = this.workflow.invokeRule(ruleName);
            this.accumulate(result);
            return result.isSuccess();
        }

        public boolean evalRule(String ruleName, boolean accumOnSuccess) throws WorkflowException {
            RuleExpressionResult result = this.workflow.invokeRule(ruleName);
            if (accumOnSuccess == result.isSuccess()) {
                this.accumulate(result);
            }
            return result.isSuccess();
        }
    }
}

