/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeContract;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.group.GroupEbo;
import org.kuali.rice.kim.framework.identity.EntityTypeEbo;
import org.kuali.rice.kim.framework.identity.address.EntityAddressTypeEbo;
import org.kuali.rice.kim.framework.identity.affiliation.EntityAffiliationTypeEbo;
import org.kuali.rice.kim.framework.identity.citizenship.EntityCitizenshipStatusEbo;
import org.kuali.rice.kim.framework.identity.email.EntityEmailTypeEbo;
import org.kuali.rice.kim.framework.identity.employment.EntityEmploymentStatusEbo;
import org.kuali.rice.kim.framework.identity.employment.EntityEmploymentTypeEbo;
import org.kuali.rice.kim.framework.identity.external.EntityExternalIdentifierTypeEbo;
import org.kuali.rice.kim.framework.identity.name.EntityNameTypeEbo;
import org.kuali.rice.kim.framework.identity.phone.EntityPhoneTypeEbo;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.EntityTypeBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipStatusBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierTypeBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.impl.ModuleServiceBase;

public class KimModuleService
extends ModuleServiceBase {
    private PersonService personService;
    private RoleService kimRoleService;
    private GroupService groupService;
    private IdentityService identityService;
    private KimTypeInfoService kimTypeInfoService;

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (Person.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("principalId")) {
                return (T)this.getPersonService().getPerson((String)fieldValues.get("principalId"));
            }
            if (fieldValues.containsKey("principalName")) {
                return (T)this.getPersonService().getPersonByPrincipalName((String)fieldValues.get("principalName"));
            }
        } else if (RoleContract.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("id")) {
                Role role = this.getKimRoleService().getRole((String)fieldValues.get("id"));
                return (T)RoleBo.from((Role)role);
            }
            if (fieldValues.containsKey("name") && fieldValues.containsKey("namespaceCode")) {
                Role role = this.getKimRoleService().getRoleByNamespaceCodeAndName((String)fieldValues.get("namespaceCode"), (String)fieldValues.get("name"));
                return (T)RoleBo.from((Role)role);
            }
        } else if (GroupContract.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("id")) {
                Group group = this.getGroupService().getGroup((String)fieldValues.get("id"));
                return (T)GroupBo.from((Group)group);
            }
            if (fieldValues.containsKey("name") && fieldValues.containsKey("namespaceCode")) {
                Group group = this.getGroupService().getGroupByNamespaceCodeAndName((String)fieldValues.get("namespaceCode"), (String)fieldValues.get("name"));
                return (T)GroupBo.from((Group)group);
            }
        } else if (EntityEmailTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEmailType((String)fieldValues.get("code"));
                return (T)EntityEmailTypeBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityAddressTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getAddressType((String)fieldValues.get("code"));
                return (T)EntityAddressTypeBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityAffiliationTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                EntityAffiliationType codedAttribute = this.getIdentityService().getAffiliationType((String)fieldValues.get("code"));
                return (T)EntityAffiliationTypeBo.from((EntityAffiliationType)codedAttribute);
            }
        } else if (EntityCitizenshipStatusEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getCitizenshipStatus((String)fieldValues.get("code"));
                return (T)EntityCitizenshipStatusBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityEmploymentStatusEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEmploymentStatus((String)fieldValues.get("code"));
                return (T)EntityEmploymentStatusBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityEmploymentTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEmploymentType((String)fieldValues.get("code"));
                return (T)EntityEmploymentTypeBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityNameTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getNameType((String)fieldValues.get("code"));
                return (T)EntityNameTypeBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEntityType((String)fieldValues.get("code"));
                return (T)EntityTypeBo.from((CodedAttribute)codedAttribute);
            }
        } else if (EntityExternalIdentifierTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                EntityExternalIdentifierType codedAttribute = this.getIdentityService().getExternalIdentifierType((String)fieldValues.get("code"));
                return (T)EntityExternalIdentifierTypeBo.from((EntityExternalIdentifierType)codedAttribute);
            }
        } else if (EntityPhoneTypeEbo.class.isAssignableFrom(businessObjectClass) && fieldValues.containsKey("code")) {
            CodedAttribute codedAttribute = this.getIdentityService().getPhoneType((String)fieldValues.get("code"));
            return (T)EntityPhoneTypeBo.from((CodedAttribute)codedAttribute);
        }
        return (T)super.getExternalizableBusinessObject(businessObjectClass, fieldValues);
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues) {
        if (Person.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            return this.getPersonService().findPeople(fieldValues);
        }
        if (RoleContract.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List roles = this.getKimRoleService().findRoles(this.toQuery(fieldValues)).getResults();
            ArrayList<RoleBo> roleEbos = new ArrayList<RoleBo>(roles.size());
            for (Role role : roles) {
                roleEbos.add(RoleBo.from((Role)role));
            }
            return roleEbos;
        }
        if (GroupContract.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List groups = this.getGroupService().findGroups(this.toQuery(fieldValues)).getResults();
            ArrayList<GroupBo> groupEbos = new ArrayList<GroupBo>(groups.size());
            for (Group group : groups) {
                groupEbos.add(GroupBo.from((Group)group));
            }
            return groupEbos;
        }
        return super.getExternalizableBusinessObjectsList(externalizableBusinessObjectClass, fieldValues);
    }

    private QueryByCriteria toQuery(Map<String, ?> fieldValues) {
        HashSet<Predicate> preds = new HashSet<Predicate>();
        for (String key : fieldValues.keySet()) {
            preds.add(PredicateFactory.equal((String)key, fieldValues.get(key)));
        }
        Predicate[] predicates = new Predicate[]{};
        predicates = preds.toArray(predicates);
        return QueryByCriteria.Builder.fromPredicates((Predicate[])predicates);
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsListForLookup(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues, boolean unbounded) {
        if (Person.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            return this.getPersonService().findPeople(fieldValues, unbounded);
        }
        if (RoleContract.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List roles = this.getKimRoleService().findRoles(this.toQuery(fieldValues)).getResults();
            ArrayList<RoleBo> roleEbos = new ArrayList<RoleBo>(roles.size());
            for (Role role : roles) {
                roleEbos.add(RoleBo.from((Role)role));
            }
            return roleEbos;
        }
        if (GroupContract.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List groups = this.getGroupService().findGroups(this.toQuery(fieldValues)).getResults();
            ArrayList<GroupBo> groupEbos = new ArrayList<GroupBo>(groups.size());
            for (Group group : groups) {
                groupEbos.add(GroupBo.from((Group)group));
            }
            return groupEbos;
        }
        return super.getExternalizableBusinessObjectsListForLookup(externalizableBusinessObjectClass, fieldValues, unbounded);
    }

    public List listPrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        if (Person.class.isAssignableFrom(businessObjectInterfaceClass)) {
            return Collections.singletonList("principalId");
        }
        if (RoleEbo.class.isAssignableFrom(businessObjectInterfaceClass)) {
            return Collections.singletonList("id");
        }
        if (GroupEbo.class.isAssignableFrom(businessObjectInterfaceClass)) {
            return Collections.singletonList("id");
        }
        if (KimType.class.isAssignableFrom(businessObjectInterfaceClass)) {
            return Collections.singletonList("id");
        }
        if (KimTypeContract.class.isAssignableFrom(businessObjectInterfaceClass)) {
            return Collections.singletonList("id");
        }
        return super.listPrimaryKeyFieldNames(businessObjectInterfaceClass);
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    protected RoleService getKimRoleService() {
        if (this.kimRoleService == null) {
            this.kimRoleService = KimApiServiceLocator.getRoleService();
        }
        return this.kimRoleService;
    }

    protected GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected KimTypeInfoService getTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }

    protected Properties getUrlParameters(String businessObjectClassAttribute, Map<String, String[]> parameters) {
        Properties urlParameters = new Properties();
        for (String paramName : parameters.keySet()) {
            String[] parameterValues = parameters.get(paramName);
            if (parameterValues.length <= 0) continue;
            urlParameters.put(paramName, parameterValues[0]);
        }
        urlParameters.put("businessObjectClassName", businessObjectClassAttribute);
        try {
            Class<?> inquiryBusinessObjectClass = Class.forName(businessObjectClassAttribute);
            if (RoleContract.class.isAssignableFrom(inquiryBusinessObjectClass) || GroupContract.class.isAssignableFrom(inquiryBusinessObjectClass) || Person.class.isAssignableFrom(inquiryBusinessObjectClass)) {
                urlParameters.put("methodToCall", "inquiry");
            } else {
                urlParameters.put("methodToCall", "continueWithInquiry");
            }
        }
        catch (Exception eix) {
            urlParameters.put("methodToCall", "continueWithInquiry");
        }
        urlParameters.put("command", "initiate");
        return urlParameters;
    }

    public boolean isExternalizable(Class boClazz) {
        if (boClazz == null) {
            return false;
        }
        if (RoleContract.class.isAssignableFrom(boClazz)) {
            return true;
        }
        if (GroupContract.class.isAssignableFrom(boClazz)) {
            return true;
        }
        if (Person.class.isAssignableFrom(boClazz)) {
            return true;
        }
        return ExternalizableBusinessObject.class.isAssignableFrom(boClazz);
    }

    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String inquiryUrl = KimCommonUtilsInternal.getKimBasePath();
        if (!inquiryUrl.endsWith("/")) {
            inquiryUrl = inquiryUrl + "/";
        }
        if (RoleContract.class.isAssignableFrom(inquiryBusinessObjectClass)) {
            return inquiryUrl + "identityManagementRoleInquiry.do";
        }
        if (GroupContract.class.isAssignableFrom(inquiryBusinessObjectClass)) {
            return inquiryUrl + "identityManagementGroupInquiry.do";
        }
        if (Person.class.isAssignableFrom(inquiryBusinessObjectClass)) {
            return inquiryUrl + "identityManagementPersonInquiry.do";
        }
        return super.getInquiryUrl(inquiryBusinessObjectClass);
    }

    public List<List<String>> listAlternatePrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        if (Person.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<List<String>> retList = new ArrayList<List<String>>();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add("principalName");
            retList.add(keyList);
            return retList;
        }
        if (RoleBo.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<List<String>> retList = new ArrayList<List<String>>();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add("name");
            keyList.add("namespaceCode");
            retList.add(keyList);
            return retList;
        }
        if (GroupBo.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<List<String>> retList = new ArrayList<List<String>>();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add("name");
            keyList.add("namespaceCode");
            retList.add(keyList);
            return retList;
        }
        return null;
    }

    public boolean goToCentralRiceForInquiry() {
        RunMode runMode = this.getRunMode("kim");
        return RunMode.EMBEDDED.equals((Object)runMode);
    }
}

