/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.web.struts.action.IdentityManagementBaseInquiryAction;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementPersonDocumentForm;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementPersonInquiry
extends IdentityManagementBaseInquiryAction {
    private static final Logger LOG = Logger.getLogger(IdentityManagementPersonInquiry.class);

    @Override
    protected void loadKimObject(HttpServletRequest request, IdentityManagementDocumentFormBase form) {
        Principal principal;
        IdentityManagementPersonDocumentForm personDocumentForm = (IdentityManagementPersonDocumentForm)form;
        String principalId = request.getParameter("principalId");
        String principalName = request.getParameter("principalName");
        if (StringUtils.isBlank((String)principalId) && StringUtils.isNotBlank((String)principalName) && (principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName)) != null) {
            principalId = principal.getPrincipalId();
        }
        if (principalId != null) {
            principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal != null) {
                personDocumentForm.setPrincipalId(principalId);
                this.getUiDocumentService().loadEntityToPersonDoc(personDocumentForm.getPersonDocument(), personDocumentForm.getPrincipalId());
                personDocumentForm.setCanOverrideEntityPrivacyPreferences(this.getUiDocumentService().canOverrideEntityPrivacyPreferences(GlobalVariables.getUserSession().getPrincipalId(), personDocumentForm.getPrincipalId()));
                this.populateRoleInformation(personDocumentForm.getPersonDocument());
            } else {
                LOG.error((Object)"No records found for Person Inquiry.");
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inquiry", new String[0]);
            }
        }
    }

    protected void populateRoleInformation(IdentityManagementPersonDocument personDoc) {
        for (PersonDocumentRole role : personDoc.getRoles()) {
            KimTypeService kimTypeService = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(this.getKimTypeServiceName(KimTypeBo.to((KimTypeBo)role.getKimRoleType()))));
            try {
                role.setDefinitions(kimTypeService.getAttributeDefinitions(role.getKimTypeId()));
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve KimTypeService from remote system for KIM Type Id: " + role.getKimTypeId()), (Throwable)ex);
            }
            role.setNewRolePrncpl(new KimDocumentRoleMember());
            for (KimAttributeField key : role.getDefinitions()) {
                KimDocumentRoleQualifier qualifier = new KimDocumentRoleQualifier();
                this.setAttrDefnIdForQualifier(qualifier, key);
                role.getNewRolePrncpl().getQualifiers().add(qualifier);
            }
            role.setAttributeEntry(this.getUiDocumentService().getAttributeEntries(role.getDefinitions()));
        }
    }

    private void setAttrDefnIdForQualifier(KimDocumentRoleQualifier qualifier, KimAttributeField definition) {
        qualifier.setKimAttrDefnId(definition.getId());
        qualifier.refreshReferenceObject("kimAttribute");
    }

    private String getKimTypeServiceName(KimType kimType) {
        String serviceName = kimType.getServiceName();
        if (StringUtils.isBlank((String)serviceName)) {
            serviceName = "kimTypeService";
        }
        return serviceName;
    }
}

