/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class SaveActionEvent
extends ActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(SaveActionEvent.class);
    private static final String RESPONSIBILITY_DESCRIPTION = "Initiator needs to complete document.";

    public SaveActionEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("S", routeHeader, principal);
    }

    public SaveActionEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation) {
        super("S", routeHeader, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRulesCustom(true);
    }

    private String validateActionRulesCustom(boolean checkIfActionIsValid) {
        if (checkIfActionIsValid && !this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be saved";
        }
        if (!StringUtils.equals((String)this.getPrincipal().getPrincipalName(), (String)"kr") && !KEWServiceLocator.getDocumentTypePermissionService().canSave(this.getPrincipal().getPrincipalId(), this.getRouteHeader())) {
            return "User is not authorized to Save document";
        }
        return "";
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        String errorMessage;
        MDC.put((String)"docId", (Object)this.getRouteHeader().getDocumentId());
        LOG.debug((Object)"Checking to see if the action is legal");
        boolean checkIfActionIsValid = true;
        if (this.getRouteHeader().isEnroute() || this.getRouteHeader().isInException()) {
            checkIfActionIsValid = false;
        }
        if (!StringUtils.isEmpty((String)(errorMessage = this.validateActionRulesCustom(checkIfActionIsValid)))) {
            throw new InvalidActionTakenException(errorMessage);
        }
        this.updateSearchableAttributesIfPossible();
        if (this.getRouteHeader().isStateInitiated()) {
            LOG.debug((Object)"Record the save action");
            ActionTakenValue actionTaken = this.saveActionTaken();
            this.getActionRequestService().saveActionRequest(this.generateSaveRequest());
            this.notifyActionTaken(actionTaken);
            LOG.debug((Object)"Marking document saved");
            try {
                String oldStatus = this.getRouteHeader().getDocRouteStatus();
                this.getRouteHeader().markDocumentSaved();
                String newStatus = this.getRouteHeader().getDocRouteStatus();
                this.notifyStatusChange(newStatus, oldStatus);
                DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.routeHeader);
                this.setRouteHeader(routeHeaderValue);
            }
            catch (WorkflowException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
                throw new InvalidActionTakenException(ex.getMessage());
            }
        }
    }

    protected ActionRequestValue generateSaveRequest() {
        RouteNodeInstance initialNode = null;
        List initialNodes = KEWServiceLocator.getRouteNodeService().getInitialNodeInstances(this.getDocumentId());
        if (!initialNodes.isEmpty()) {
            initialNode = (RouteNodeInstance)initialNodes.get(0);
        }
        ActionRequestFactory arFactory = new ActionRequestFactory(this.getRouteHeader(), initialNode);
        ActionRequestValue saveRequest = arFactory.createActionRequest("C", 0, new KimPrincipalRecipient(this.getPrincipal()), RESPONSIBILITY_DESCRIPTION, "-3", Boolean.TRUE, this.annotation);
        return this.getActionRequestService().activateRequest(saveRequest);
    }
}

