/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.dao.DocumentTypeDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Required;

public class DocumentTypeDAOJpa
implements DocumentTypeDAO {
    public static final Logger LOG = Logger.getLogger(DocumentTypeDAOJpa.class);
    private EntityManager entityManager;
    private DataObjectService dataObjectService;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public DocumentType findByName(String name) {
        return this.findByName(name, true);
    }

    @Override
    public DocumentType findByName(String name, boolean caseSensitive) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (caseSensitive) {
            if (StringUtils.contains((String)name, (String)"*")) {
                name = StringUtils.replace((String)name, (String)"*", (String)"%");
                predicates.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)name.trim()));
            } else {
                predicates.add(PredicateFactory.equal((String)"name", (Object)name));
            }
        } else if (name.contains("*") || name.contains("%")) {
            name = name.replace("*", "%");
            predicates.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)name));
        } else {
            predicates.add(PredicateFactory.equalIgnoreCase((String)"name", (CharSequence)name));
        }
        predicates.add(PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE));
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        if (results != null && !results.getResults().isEmpty()) {
            return (DocumentType)results.getResults().get(0);
        }
        return null;
    }

    @Override
    public Integer getMaxVersionNumber(String docTypeName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.GetMaxVersionNumber", Integer.class);
        query.setParameter("docTypeName", (Object)docTypeName);
        return (Integer)query.getSingleResult();
    }

    @Override
    public List<String> getChildDocumentTypeIds(String parentDocumentTypeId) {
        try {
            this.getEntityManager().flush();
            TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.GetChildDocumentTypeIds", String.class);
            query.setParameter("parentDocumentTypeId", (Object)parentDocumentTypeId);
            return query.getResultList();
        }
        catch (Exception e) {
            LOG.error((Object)("Error occured fetching children document type ids for document type " + parentDocumentTypeId), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<DocumentType> find(DocumentType documentType, DocumentType docTypeParent, boolean climbHierarchy) {
        DocumentType searchDocumentType;
        LOG.debug((Object)("documentType: " + documentType));
        LOG.debug((Object)("docTypeParent: " + docTypeParent));
        LOG.debug((Object)("climbHierarchy: " + climbHierarchy));
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (documentType != null && !StringUtils.isEmpty((String)documentType.getLabel())) {
            predicates.add(PredicateFactory.likeIgnoreCase((String)"label", (CharSequence)documentType.getLabel().trim()));
        }
        if (documentType != null && !StringUtils.isEmpty((String)documentType.getName())) {
            String docTypeName = documentType.getName();
            predicates.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)("%" + docTypeName.trim() + "%")));
        }
        if (documentType != null && documentType.getActive() != null) {
            predicates.add(PredicateFactory.equal((String)"active", (Object)documentType.getActive()));
        }
        if (documentType != null && documentType.getDocumentTypeId() != null) {
            predicates.add(PredicateFactory.equal((String)"documentTypeId", (Object)documentType.getDocumentTypeId()));
        }
        if (documentType != null && documentType.getActualApplicationId() != null) {
            predicates.add(PredicateFactory.equal((String)"actualApplicationId", (Object)documentType.getActualApplicationId()));
        }
        if (docTypeParent != null) {
            if (StringUtils.isNotBlank((String)docTypeParent.getName())) {
                ArrayList<Predicate> parentCriteria = new ArrayList<Predicate>();
                ArrayList<Predicate> childCriteria = new ArrayList<Predicate>();
                this.addParentIdOrCriteria(docTypeParent.getDocumentTypeId(), parentCriteria);
                if (climbHierarchy) {
                    this.assembleChildrenCriteria(docTypeParent.getChildrenDocTypes(), childCriteria);
                }
                parentCriteria.add(PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE));
                predicates.add(PredicateFactory.and((Predicate[])parentCriteria.toArray(new Predicate[parentCriteria.size()])));
                if (!childCriteria.isEmpty()) {
                    predicates.add(PredicateFactory.or((Predicate[])childCriteria.toArray(new Predicate[childCriteria.size()])));
                }
            }
        } else if (documentType != null && StringUtils.isNotBlank((String)documentType.getName()) && (searchDocumentType = this.findByName(documentType.getName())) != null && climbHierarchy) {
            LOG.debug((Object)("searchDocumentType: " + searchDocumentType));
            ArrayList<Predicate> parentPredicates = new ArrayList<Predicate>();
            this.addParentIdOrCriteria(searchDocumentType.getDocumentTypeId(), parentPredicates);
            this.assembleChildrenCriteria(searchDocumentType.getChildrenDocTypes(), parentPredicates);
            parentPredicates.add(PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE));
            predicates.add(PredicateFactory.or((Predicate[])parentPredicates.toArray(new Predicate[parentPredicates.size()])));
        }
        predicates.add(PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE));
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        return results.getResults();
    }

    private void addParentIdOrCriteria(String parentId, List<Predicate> parentPredicates) {
        parentPredicates.add(PredicateFactory.equal((String)"docTypeParentId", (Object)parentId));
    }

    private void assembleChildrenCriteria(Collection<DocumentType> childrenDocTypes, List<Predicate> parentPredicates) {
        if (childrenDocTypes != null) {
            for (DocumentType child : childrenDocTypes) {
                this.addParentIdOrCriteria(child.getParentId(), parentPredicates);
                this.assembleChildrenCriteria(child.getChildrenDocTypes(), parentPredicates);
            }
        }
    }

    @Override
    public List<DocumentType> findAllCurrent() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        return results.getResults();
    }

    @Override
    public List<DocumentType> findAllCurrentByName(String name) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        return results.getResults();
    }

    @Override
    public String findDocumentTypeIdByName(String documentTypeName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.GetIdByName", String.class);
        query.setParameter("docTypeName", (Object)documentTypeName);
        try {
            return (String)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public String findDocumentTypeNameById(String documentTypeId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.FindDocumentTypeNameById", String.class);
        query.setParameter("documentTypeId", (Object)documentTypeId);
        try {
            return (String)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public DocumentType findDocumentTypeByDocumentId(String documentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.GetDocumentTypeByDocumentId", DocumentType.class);
        query.setParameter("documentId", (Object)documentId);
        try {
            return (DocumentType)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public void incrementOptimisticLock(String documentTypeId) {
        DocumentType documentType = (DocumentType)this.getEntityManager().getReference(DocumentType.class, (Object)documentTypeId);
        this.getEntityManager().lock((Object)documentType, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
    }

    @Override
    public String findParentNameByName(String documentTypeName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentType.parentNameByName", String.class);
        query.setParameter("docTypeName", (Object)documentTypeName);
        try {
            return (String)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

