/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.service.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.doctype.DocumentTypeSecurity;
import org.kuali.rice.kew.doctype.SecurityPermissionInfo;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentSecurityService;
import org.kuali.rice.kew.framework.KewFrameworkServiceLocator;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityAttribute;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityDirective;
import org.kuali.rice.kew.framework.document.security.DocumentSecurityHandlerService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.UserUtils;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class DocumentSecurityServiceImpl
implements DocumentSecurityService {
    public static final Logger LOG = Logger.getLogger(DocumentSecurityServiceImpl.class);
    private ExtensionRepositoryService extensionRepositoryService;

    @Override
    public boolean routeLogAuthorized(String principalId, DocumentRouteHeaderValue routeHeader, SecuritySession securitySession) {
        Document document = DocumentRouteHeaderValue.to(routeHeader);
        if (document != null) {
            Set<String> authorizationResults = this.checkAuthorizations(principalId, securitySession, Collections.singletonList(document));
            return authorizationResults.contains(routeHeader.getDocumentId());
        }
        return false;
    }

    @Override
    public Set<String> documentSearchResultAuthorized(String principalId, DocumentSearchResults results, SecuritySession securitySession) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (DocumentSearchResult result : results.getSearchResults()) {
            documents.add(result.getDocument());
        }
        return this.checkAuthorizations(principalId, securitySession, documents);
    }

    protected Set<String> checkAuthorizations(String principalId, SecuritySession securitySession, List<Document> documents) {
        HashSet<String> authorizations = new HashSet<String>();
        ArrayList<Document> documentsRequiringExtensionProcessing = new ArrayList<Document>();
        boolean admin = this.isAdmin(securitySession);
        for (Document document : documents) {
            if (admin) {
                authorizations.add(document.getDocumentId());
                continue;
            }
            DocumentTypeSecurity security = null;
            try {
                security = this.getDocumentTypeSecurity(document.getDocumentTypeName(), securitySession);
                if (security == null || !security.isActive() || this.checkStandardAuthorization(security, principalId, document, securitySession)) {
                    authorizations.add(document.getDocumentId());
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(security.getSecurityAttributeExtensionNames())) continue;
                documentsRequiringExtensionProcessing.add(document);
            }
            catch (Exception e) {
                LOG.warn((Object)("Not able to retrieve DocumentTypeSecurity from remote system for documentTypeName: " + document.getDocumentTypeName()), (Throwable)e);
            }
        }
        this.processDocumentRequiringExtensionProcessing(documentsRequiringExtensionProcessing, securitySession, authorizations);
        return authorizations;
    }

    protected void processDocumentRequiringExtensionProcessing(List<Document> documentsRequiringExtensionProcessing, SecuritySession securitySession, Set<String> authorizations) {
        if (CollectionUtils.isNotEmpty(documentsRequiringExtensionProcessing)) {
            LOG.info((Object)("Beginning processing of documents requiring extension processing (total: " + documentsRequiringExtensionProcessing.size() + " documents)"));
            long start = System.currentTimeMillis();
            MultiValueMap<PartitionKey, Document> partitions = this.partitionDocumentsForSecurity(documentsRequiringExtensionProcessing, securitySession);
            LinkedMultiValueMap applicationSecurityDirectives = new LinkedMultiValueMap();
            for (PartitionKey partitionKey : partitions.keySet()) {
                DocumentSecurityDirective directive = DocumentSecurityDirective.create(partitionKey.getDocumentSecurityAttributeNameList(), (List)((List)partitions.get((Object)partitionKey)));
                applicationSecurityDirectives.add((Object)partitionKey.applicationId, (Object)directive);
            }
            for (String applicationId : applicationSecurityDirectives.keySet()) {
                List documentSecurityDirectives = (List)applicationSecurityDirectives.get((Object)applicationId);
                DocumentSecurityHandlerService securityHandler = this.loadSecurityHandler(applicationId);
                List authorizedDocumentIds = securityHandler.getAuthorizedDocumentIds(securitySession.getPrincipalId(), documentSecurityDirectives);
                if (!CollectionUtils.isNotEmpty((Collection)authorizedDocumentIds)) continue;
                authorizations.addAll(authorizedDocumentIds);
            }
            long end = System.currentTimeMillis();
            LOG.info((Object)("Finished processing of documents requiring extension processing (total time: " + (start - end) + ")"));
        }
    }

    protected MultiValueMap<PartitionKey, Document> partitionDocumentsForSecurity(List<Document> documents, SecuritySession securitySession) {
        LinkedMultiValueMap partitions = new LinkedMultiValueMap();
        for (Document document : documents) {
            DocumentTypeSecurity security = this.getDocumentTypeSecurity(document.getDocumentTypeName(), securitySession);
            MultiValueMap<String, ExtensionDefinition> securityAttributeExtensionDefinitions = this.loadExtensionDefinitions(security, securitySession);
            for (String applicationId : securityAttributeExtensionDefinitions.keySet()) {
                List extensionDefinitions = (List)securityAttributeExtensionDefinitions.get((Object)applicationId);
                PartitionKey key = new PartitionKey(applicationId, extensionDefinitions);
                partitions.add((Object)key, (Object)document);
            }
        }
        return partitions;
    }

    protected MultiValueMap<String, ExtensionDefinition> loadExtensionDefinitions(DocumentTypeSecurity security, SecuritySession securitySession) {
        LinkedMultiValueMap securityAttributeExtensionDefinitions = new LinkedMultiValueMap();
        List<String> securityAttributeExtensionNames = security.getSecurityAttributeExtensionNames();
        for (String securityAttributeExtensionName : securityAttributeExtensionNames) {
            ExtensionDefinition extensionDefinition = this.extensionRepositoryService.getExtensionByName(securityAttributeExtensionName);
            securityAttributeExtensionDefinitions.add((Object)extensionDefinition.getApplicationId(), (Object)extensionDefinition);
        }
        return securityAttributeExtensionDefinitions;
    }

    protected DocumentSecurityHandlerService loadSecurityHandler(String applicationId) {
        DocumentSecurityHandlerService service = KewFrameworkServiceLocator.getDocumentSecurityHandlerService((String)applicationId);
        if (service == null) {
            throw new WorkflowRuntimeException("Failed to locate DocumentSecurityHandlerService for applicationId: " + applicationId);
        }
        return service;
    }

    protected boolean isAdmin(SecuritySession session) {
        if (session.getPrincipalId() == null) {
            return false;
        }
        return KimApiServiceLocator.getPermissionService().isAuthorized(session.getPrincipalId(), "KR-WKFLW", "Unrestricted Document Search", new HashMap());
    }

    protected boolean checkStandardAuthorization(DocumentTypeSecurity security, String principalId, Document document, SecuritySession securitySession) {
        List<DocumentSecurityAttribute> immediateSecurityAttributes;
        List<KeyValue> list;
        List<Group> securityWorkgroups;
        boolean isInitiator;
        String documentId = document.getDocumentId();
        String initiatorPrincipalId = document.getInitiatorPrincipalId();
        LOG.debug((Object)("auth check user=" + principalId + " docId=" + documentId));
        if (security.getInitiatorOk() != null && security.getInitiatorOk().booleanValue() && (isInitiator = StringUtils.equals((String)initiatorPrincipalId, (String)principalId))) {
            return true;
        }
        List<SecurityPermissionInfo> securityPermissions = security.getPermissions();
        if (securityPermissions != null) {
            for (SecurityPermissionInfo securityPermissionInfo : securityPermissions) {
                if (!this.isAuthenticatedByPermission(documentId, securityPermissionInfo.getPermissionNamespaceCode(), securityPermissionInfo.getPermissionName(), securityPermissionInfo.getPermissionDetails(), securityPermissionInfo.getQualifications(), securitySession)) continue;
                return true;
            }
        }
        if ((securityWorkgroups = security.getWorkgroups()) != null) {
            for (Group securityWorkgroup : securityWorkgroups) {
                if (!this.isGroupAuthenticated(securityWorkgroup.getNamespaceCode(), securityWorkgroup.getName(), securitySession)) continue;
                return true;
            }
        }
        if ((list = security.getSearchableAttributes()) != null) {
            for (KeyValue searchableAttr : list) {
                String attrName = searchableAttr.getKey();
                String idType = searchableAttr.getValue();
                String idValue = UserUtils.getIdValue(idType, principalId);
                if (StringUtils.isEmpty((String)idValue) || !KEWServiceLocator.getRouteHeaderService().hasSearchableAttributeValue(documentId, attrName, idValue)) continue;
                return true;
            }
        }
        if (security.getRouteLogAuthenticatedOk() != null && security.getRouteLogAuthenticatedOk().booleanValue()) {
            boolean isInitiator2 = StringUtils.equals((String)initiatorPrincipalId, (String)principalId);
            if (isInitiator2) {
                return true;
            }
            boolean hasTakenAction = KEWServiceLocator.getActionTakenService().hasUserTakenAction(principalId, documentId);
            if (hasTakenAction) {
                return true;
            }
            boolean hasRequest = KEWServiceLocator.getActionRequestService().doesPrincipalHaveRequest(principalId, documentId);
            if (hasRequest) {
                return true;
            }
        }
        if ((immediateSecurityAttributes = this.getImmediateSecurityAttributes(document, security, securitySession)) != null) {
            for (DocumentSecurityAttribute immediateSecurityAttribute : immediateSecurityAttributes) {
                boolean isAuthorized = immediateSecurityAttribute.isAuthorizedForDocument(principalId, document);
                if (!isAuthorized) continue;
                return true;
            }
        }
        LOG.debug((Object)"user not authorized");
        return false;
    }

    protected List<DocumentSecurityAttribute> getImmediateSecurityAttributes(Document document, DocumentTypeSecurity security, SecuritySession securitySession) {
        ArrayList<DocumentSecurityAttribute> securityAttributes = new ArrayList<DocumentSecurityAttribute>();
        for (String securityAttributeClassName : security.getSecurityAttributeClassNames()) {
            DocumentSecurityAttribute securityAttribute = securitySession.getSecurityAttributeForClass(securityAttributeClassName);
            if (securityAttribute == null) {
                securityAttribute = (DocumentSecurityAttribute)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(securityAttributeClassName));
                securitySession.setSecurityAttributeForClass(securityAttributeClassName, securityAttribute);
            }
            securityAttributes.add(securityAttribute);
        }
        return securityAttributes;
    }

    protected DocumentTypeSecurity getDocumentTypeSecurity(String documentTypeName, SecuritySession session) {
        DocumentType docType;
        DocumentTypeSecurity security = session.getDocumentTypeSecurity().get(documentTypeName);
        if (security == null && (docType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName)) != null) {
            security = docType.getDocumentTypeSecurity();
            session.getDocumentTypeSecurity().put(documentTypeName, security);
        }
        return security;
    }

    protected boolean isGroupAuthenticated(String namespace, String groupName, SecuritySession session) {
        String key = namespace.trim() + ":" + groupName.trim();
        Boolean existingAuth = session.getAuthenticatedWorkgroups().get(key);
        if (existingAuth != null) {
            return existingAuth;
        }
        boolean memberOfGroup = this.isMemberOfGroupWithName(namespace, groupName, session.getPrincipalId());
        session.getAuthenticatedWorkgroups().put(key, memberOfGroup);
        return memberOfGroup;
    }

    private boolean isMemberOfGroupWithName(String namespace, String groupName, String principalId) {
        for (Group group : KimApiServiceLocator.getGroupService().getGroupsByPrincipalId(principalId)) {
            if (!StringUtils.equals((String)namespace, (String)group.getNamespaceCode()) || !StringUtils.equals((String)groupName, (String)group.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthenticatedByPermission(String documentId, String permissionNamespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> qualification, SecuritySession session) {
        try {
            String replacementValue;
            Document document = KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
            for (String qualificationKey : qualification.keySet()) {
                String qualificationValue = qualification.get(qualificationKey);
                replacementValue = this.getReplacementString(document, qualificationValue);
                qualification.put(qualificationKey, replacementValue);
            }
            for (String permissionDetailKey : permissionDetails.keySet()) {
                String detailValue = qualification.get(permissionDetailKey);
                replacementValue = this.getReplacementString(document, detailValue);
                qualification.put(permissionDetailKey, replacementValue);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return KimApiServiceLocator.getPermissionService().isAuthorized(session.getPrincipalId(), permissionNamespaceCode, permissionName, qualification);
    }

    private String getReplacementString(Document document, String value) throws Exception {
        String startsWith = "${document.";
        String endsWith = "}";
        if (value.startsWith(startsWith)) {
            int tokenStart = value.indexOf(startsWith);
            int tokenEnd = value.indexOf(endsWith, tokenStart + startsWith.length());
            if (tokenEnd == -1) {
                throw new RuntimeException("No ending bracket on token in value " + value);
            }
            String token = value.substring(tokenStart + startsWith.length(), tokenEnd);
            return this.getRouteHeaderVariableValue(document, token);
        }
        return value;
    }

    private String getRouteHeaderVariableValue(Document document, String variableName) throws Exception {
        Field field;
        try {
            field = document.getClass().getDeclaredField(variableName);
        }
        catch (NoSuchFieldException nsfe) {
            LOG.error((Object)("Field '" + variableName + "' not found on Document object."));
            return null;
        }
        field.setAccessible(true);
        Object fieldValue = field.get(document);
        Class<?> clazzType = field.getType();
        if (clazzType.equals(String.class)) {
            return (String)fieldValue;
        }
        if (clazzType.getName().equals("boolean") || clazzType.getName().equals("java.lang.Boolean")) {
            if (((Boolean)fieldValue).booleanValue()) {
                return "Y";
            }
            return "N";
        }
        if (clazzType.getName().equals("java.util.Calendar")) {
            DateTimeService dateTimeService = (DateTimeService)GlobalResourceLoader.getService((String)"dateTimeService");
            return dateTimeService.toDateString(((Calendar)fieldValue).getTime());
        }
        return String.valueOf(fieldValue);
    }

    public ExtensionRepositoryService getExtensionRepositoryService() {
        return this.extensionRepositoryService;
    }

    public void setExtensionRepositoryService(ExtensionRepositoryService extensionRepositoryService) {
        this.extensionRepositoryService = extensionRepositoryService;
    }

    private static final class PartitionKey {
        String applicationId;
        Set<String> documentSecurityAttributeNames;

        PartitionKey(String applicationId, Collection<ExtensionDefinition> extensionDefinitions) {
            this.applicationId = applicationId;
            this.documentSecurityAttributeNames = new HashSet<String>();
            for (ExtensionDefinition extensionDefinition : extensionDefinitions) {
                this.documentSecurityAttributeNames.add(extensionDefinition.getName());
            }
        }

        List<String> getDocumentSecurityAttributeNameList() {
            return new ArrayList<String>(this.documentSecurityAttributeNames);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PartitionKey)) {
                return false;
            }
            PartitionKey key = (PartitionKey)o;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.applicationId, (Object)key.applicationId);
            builder.append(this.documentSecurityAttributeNames, key.documentSecurityAttributeNames);
            return builder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.applicationId);
            builder.append(this.documentSecurityAttributeNames);
            return builder.hashCode();
        }
    }
}

