/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;

public class OrchestrationConfig {
    private final EngineCapability capability;
    private final boolean sendNotifications;
    private final String notificationType = "K";
    private final Set<String> destinationNodeNames;
    private final ActionTakenValue cause;
    private final boolean runPostProcessorLogic;
    private final boolean deactivateAcknowledgements;
    private final boolean deactivateFYIs;
    private final boolean supressRequestsNodePolicyErrors;

    public OrchestrationConfig(EngineCapability capability) {
        this(capability, Collections.emptySet(), null, true, true);
    }

    public OrchestrationConfig(EngineCapability capability, boolean isRunPostProcessorLogic) {
        this(capability, Collections.emptySet(), null, true, isRunPostProcessorLogic);
    }

    public OrchestrationConfig(EngineCapability capability, Set<String> destinationNodeNames, ActionTakenValue cause) {
        this(capability, destinationNodeNames, cause, true, true);
    }

    public OrchestrationConfig(EngineCapability capability, Set<String> destinationNodeNames, ActionTakenValue cause, boolean sendNotifications, boolean doRunPostProcessorLogic) {
        this(capability, destinationNodeNames, cause, sendNotifications, doRunPostProcessorLogic, false, false, false);
    }

    public OrchestrationConfig(EngineCapability capability, Set<String> destinationNodeNames, ActionTakenValue cause, boolean sendNotifications, boolean doRunPostProcessorLogic, boolean deactivateAcknowledgements, boolean deactivateFYIs, boolean supressRequestsNodePolicyErrors) {
        this.capability = capability;
        this.destinationNodeNames = Collections.unmodifiableSet(new HashSet<String>(destinationNodeNames));
        this.cause = cause;
        this.sendNotifications = sendNotifications;
        this.runPostProcessorLogic = doRunPostProcessorLogic;
        this.deactivateAcknowledgements = deactivateAcknowledgements;
        this.deactivateFYIs = deactivateFYIs;
        this.supressRequestsNodePolicyErrors = supressRequestsNodePolicyErrors;
    }

    public boolean isSupressRequestsNodePolicyErrors() {
        return this.supressRequestsNodePolicyErrors;
    }

    public Set<String> getDestinationNodeNames() {
        return this.destinationNodeNames;
    }

    public String getNotificationType() {
        return "K";
    }

    public boolean isSendNotifications() {
        return this.sendNotifications;
    }

    public ActionTakenValue getCause() {
        return this.cause;
    }

    public boolean isRunPostProcessorLogic() {
        return this.runPostProcessorLogic;
    }

    public EngineCapability getCapability() {
        return this.capability;
    }

    public boolean isDeactivateAcknowledgements() {
        return this.deactivateAcknowledgements;
    }

    public boolean isDeactivateFYIs() {
        return this.deactivateFYIs;
    }

    public static enum EngineCapability {
        STANDARD,
        BLANKET_APPROVAL,
        SIMULATION;

    }
}

