/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.service.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.service.BranchService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class BranchServiceImpl
implements BranchService {
    private static final Logger LOG = Logger.getLogger(BranchServiceImpl.class);
    private DataObjectService dataObjectService;

    @Override
    public void save(Branch branch) {
        this.dataObjectService.save((Object)branch, new PersistenceOption[0]);
    }

    @Override
    public void deleteBranchStates(List<BranchState> statesToBeDeleted) {
        for (BranchState bs : statesToBeDeleted) {
            this.dataObjectService.delete((Object)bs);
        }
    }

    private BranchState resolveScopedVariable(Branch branch, String name) {
        for (Branch b = branch; b != null; b = b.getParentBranch()) {
            for (BranchState bs : b.getBranchState()) {
                LOG.debug((Object)bs);
            }
            LOG.debug((Object)("Resolving variable: '" + name + "' in scope (branch): '" + branch.getName() + "' (" + branch.getBranchId() + ")"));
            BranchState bs = b.getBranchState(name);
            if (bs == null) continue;
            return bs;
        }
        return null;
    }

    @Override
    public String getScopedVariableValue(Branch branch, String name) {
        BranchState bs = this.resolveScopedVariable(branch, name);
        if (bs != null) {
            return bs.getValue();
        }
        return null;
    }

    @Override
    public String setScopedVariableValue(Branch branch, String name, String value) {
        LOG.debug((Object)("Setting scoped variable value: " + name + " " + value));
        BranchState bs = this.resolveScopedVariable(branch, name);
        String oldValue = null;
        if (bs == null) {
            LOG.debug((Object)("Defining new variable named '" + name + "' at scope '" + branch + "'"));
            bs = new BranchState();
            bs.setKey(name);
            bs.setValue(value);
            bs.setBranch(branch);
            branch.addBranchState(bs);
        } else {
            oldValue = bs.getValue();
            LOG.debug((Object)("Replacing old value of variable '" + name + "' (" + oldValue + ") at scope '" + branch + "' with new value: " + value));
            bs.setValue(value);
        }
        this.save(bs.getBranch());
        return oldValue;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

