/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.export;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;

public class KewExportDataSet {
    public static final QName DOCUMENT_TYPES = new QName("KEW", "documentTypes");
    public static final QName GROUPS = new QName("KEW", "groups");
    public static final QName RULE_ATTRIBUTES = new QName("KEW", "ruleAttributes");
    public static final QName RULE_TEMPLATES = new QName("KEW", "ruleTemplates");
    public static final QName RULES = new QName("KEW", "rules");
    public static final QName RULE_DELEGATIONS = new QName("KEW", "ruleDelegations");
    public static final QName HELP = new QName("KEW", "help");
    public static final QName EDOCLITES = new QName("KEW", "eDocLites");
    private List<DocumentType> documentTypes = new ArrayList<DocumentType>();
    private List<Group> groups = new ArrayList<Group>();
    private List<RuleAttribute> ruleAttributes = new ArrayList<RuleAttribute>();
    private List<RuleTemplateBo> ruleTemplates = new ArrayList<RuleTemplateBo>();
    private List<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
    private List<RuleDelegationBo> ruleDelegations = new ArrayList<RuleDelegationBo>();

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public List<RuleAttribute> getRuleAttributes() {
        return this.ruleAttributes;
    }

    public List<RuleBaseValues> getRules() {
        return this.rules;
    }

    public List<RuleTemplateBo> getRuleTemplates() {
        return this.ruleTemplates;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public List<RuleDelegationBo> getRuleDelegations() {
        return this.ruleDelegations;
    }

    public void populateExportDataSet(ExportDataSet exportDataSet) {
        if (this.documentTypes != null && !this.documentTypes.isEmpty()) {
            ArrayList<DocumentType> correctDocumentTypes = new ArrayList<DocumentType>();
            for (DocumentType docType : this.documentTypes) {
                correctDocumentTypes.add(KEWServiceLocator.getDocumentTypeService().findById(docType.getDocumentTypeId()));
            }
            exportDataSet.addDataSet(DOCUMENT_TYPES, correctDocumentTypes);
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            exportDataSet.addDataSet(GROUPS, this.groups);
        }
        if (this.ruleAttributes != null && !this.ruleAttributes.isEmpty()) {
            exportDataSet.addDataSet(RULE_ATTRIBUTES, this.ruleAttributes);
        }
        if (this.ruleTemplates != null && !this.ruleTemplates.isEmpty()) {
            exportDataSet.addDataSet(RULE_TEMPLATES, this.ruleTemplates);
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            exportDataSet.addDataSet(RULES, this.rules);
        }
        if (this.ruleDelegations != null && !this.ruleDelegations.isEmpty()) {
            exportDataSet.addDataSet(RULE_DELEGATIONS, this.ruleDelegations);
        }
    }

    public ExportDataSet createExportDataSet() {
        ExportDataSet exportDataSet = new ExportDataSet();
        this.populateExportDataSet(exportDataSet);
        return exportDataSet;
    }

    public static KewExportDataSet fromExportDataSet(ExportDataSet exportDataSet) {
        List ruleDelegations;
        List rules;
        List ruleTemplates;
        List ruleAttributes;
        List groups;
        KewExportDataSet kewExportDataSet = new KewExportDataSet();
        List documentTypes = (List)exportDataSet.getDataSets().get(DOCUMENT_TYPES);
        if (documentTypes != null) {
            kewExportDataSet.getDocumentTypes().addAll(documentTypes);
        }
        if ((groups = (List)exportDataSet.getDataSets().get(GROUPS)) != null) {
            kewExportDataSet.getGroups().addAll(groups);
        }
        if ((ruleAttributes = (List)exportDataSet.getDataSets().get(RULE_ATTRIBUTES)) != null) {
            kewExportDataSet.getRuleAttributes().addAll(ruleAttributes);
        }
        if ((ruleTemplates = (List)exportDataSet.getDataSets().get(RULE_TEMPLATES)) != null) {
            kewExportDataSet.getRuleTemplates().addAll(ruleTemplates);
        }
        if ((rules = (List)exportDataSet.getDataSets().get(RULES)) != null) {
            kewExportDataSet.getRules().addAll(rules);
        }
        if ((ruleDelegations = (List)exportDataSet.getDataSets().get(RULE_DELEGATIONS)) != null) {
            kewExportDataSet.getRuleDelegations().addAll(ruleDelegations);
        }
        return kewExportDataSet;
    }
}

