/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class AutofixDocumentsJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(AutofixDocumentsJob.class);
    static final String INCIDENT_IDS = "incidentIds";
    static final String CURRENT_AUTOFIX_COUNT = "currentAutofixCount";
    private volatile StuckDocumentService stuckDocumentService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        List<String> incidentIds = this.incidentIds(context);
        this.checkDependenciesAvailable(incidentIds);
        int currentAutofixCount = this.incrementAutofixCount(context);
        List<StuckDocumentIncident> stillStuck = this.getStuckDocumentService().resolveIncidentsIfPossible(incidentIds);
        if (stillStuck.isEmpty()) {
            LOG.info("All stuck document incidents have been resolved, deleting autofix job.");
            JobKey key = context.getJobDetail().getKey();
            try {
                context.getScheduler().deleteJob(key);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Failed to delete job with key: " + key, e);
            }
        } else if (currentAutofixCount > this.autofixMaxAttempts(context)) {
            LOG.info("Exceeded autofixMaxAttempts of " + this.autofixMaxAttempts(context) + ". Marking remaining " + stillStuck.size() + " stuck document incidents as failures.");
            stillStuck.forEach(stuck -> this.getStuckDocumentService().recordIncidentFailure((StuckDocumentIncident)stuck));
        } else {
            LOG.info("There are " + stillStuck.size() + " stuck documents still remaining at autofix attempt " + currentAutofixCount + ", will try again.");
            this.updateIncidentIds(stillStuck, context);
            stillStuck.forEach(this::processIncident);
        }
    }

    private void checkDependenciesAvailable(List<String> incidentIds) throws JobExecutionException {
        if (this.getStuckDocumentService() == null) {
            String message = "Dependencies are not available for this autofix documents job for stuck document incidents: " + incidentIds.toString();
            LOG.warn(message);
            throw new JobExecutionException(message);
        }
    }

    private int incrementAutofixCount(JobExecutionContext context) {
        int currentAutofixCount = context.getJobDetail().getJobDataMap().getInt(CURRENT_AUTOFIX_COUNT);
        context.getJobDetail().getJobDataMap().put(CURRENT_AUTOFIX_COUNT, ++currentAutofixCount);
        return currentAutofixCount;
    }

    private List<String> incidentIds(JobExecutionContext context) {
        String incidentIdValues = context.getJobDetail().getJobDataMap().getString(INCIDENT_IDS);
        String[] incidentIds = incidentIdValues.split(",");
        return Arrays.asList(incidentIds);
    }

    private void updateIncidentIds(List<StuckDocumentIncident> incidents, JobExecutionContext context) {
        List incidentIds = incidents.stream().map(StuckDocumentIncident::getStuckDocumentIncidentId).collect(Collectors.toList());
        context.getJobDetail().getJobDataMap().put(INCIDENT_IDS, incidentIds.stream().collect(Collectors.joining(",")));
    }

    private void processIncident(StuckDocumentIncident incident) {
        if (StuckDocumentIncident.Status.PENDING.equals((Object)incident.getStatus())) {
            incident = this.getStuckDocumentService().startFixingIncident(incident);
        }
        try {
            this.tryToFix(incident);
        }
        catch (Throwable t) {
            LOG.error("Error occurred when attmpting to fix stuck document incident for doc id " + incident.getDocumentId(), t);
        }
    }

    private void tryToFix(StuckDocumentIncident incident) {
        this.getStuckDocumentService().recordNewIncidentFixAttempt(incident);
        String docId = incident.getDocumentId();
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByDocumentId(docId);
        KewApiServiceLocator.getDocumentRequeuerService((String)documentType.getApplicationId(), (String)docId, (long)0L).refreshDocument(docId);
    }

    private int autofixMaxAttempts(JobExecutionContext context) {
        return context.getMergedJobDataMap().getInt("autofixMaxAttempts");
    }

    protected StuckDocumentService getStuckDocumentService() {
        if (this.stuckDocumentService == null) {
            this.stuckDocumentService = KEWServiceLocator.getStuckDocumentService();
        }
        return this.stuckDocumentService;
    }

    public void setStuckDocumentService(StuckDocumentService stuckDocumentService) {
        this.stuckDocumentService = stuckDocumentService;
    }
}

