/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.kuali.rice.kew.impl.stuck.StuckDocument;
import org.kuali.rice.kew.impl.stuck.StuckDocumentDao;
import org.kuali.rice.kew.impl.stuck.StuckDocumentFixAttempt;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.springframework.beans.factory.annotation.Required;

public class StuckDocumentDaoJpa
implements StuckDocumentDao {
    private static final String NEW_STUCK_DOCUMENT_ACTION_ITEM_SQL = "select DH.DOC_HDR_ID from KREW_DOC_HDR_T DH left outer join KREW_ACTN_ITM_T AI on DH.DOC_HDR_ID=AI.DOC_HDR_ID left outer join (select DOC_HDR_ID, STATUS, START_DT, END_DT from KREW_STUCK_DOC_INCIDENT_T where (DOC_HDR_ID, START_DT) in (select DOC_HDR_ID, MAX(START_DT) from KREW_STUCK_DOC_INCIDENT_T group by DOC_HDR_ID)) SD on DH.DOC_HDR_ID=SD.DOC_HDR_ID where DH.DOC_HDR_STAT_CD='R' AND AI.DOC_HDR_ID IS NULL and (SD.DOC_HDR_ID IS NULL OR SD.STATUS='FIXED' OR (SD.STATUS='FAILED' AND DH.STAT_MDFN_DT > SD.END_DT))";
    private static final String NEW_STUCK_DOCUMENT_ACTION_REQUEST_SQL = "select DH.DOC_HDR_ID from KREW_DOC_HDR_T DH left outer join (select DOC_HDR_ID, STAT_CD from KREW_ACTN_RQST_T AR where AR.STAT_CD='A') AR on DH.DOC_HDR_ID=AR.DOC_HDR_ID left outer join (select DOC_HDR_ID, STATUS, START_DT, END_DT from KREW_STUCK_DOC_INCIDENT_T where (DOC_HDR_ID, START_DT) in (select DOC_HDR_ID, MAX(START_DT) from KREW_STUCK_DOC_INCIDENT_T group by DOC_HDR_ID)) as SD on DH.DOC_HDR_ID=SD.DOC_HDR_ID where DH.DOC_HDR_STAT_CD='R' and AR.DOC_HDR_ID IS NULL and (SD.DOC_HDR_ID IS NULL OR SD.STATUS='FIXED' OR (SD.STATUS='FAILED' AND DH.STAT_MDFN_DT > SD.END_DT))";
    private static final String ALL_STUCK_DOCUMENT_ACTION_ITEM_SQL = "select DH.DOC_HDR_ID, DH.CRTE_DT, DT.LBL from KREW_DOC_HDR_T DH left outer join KREW_ACTN_ITM_T AI on DH.DOC_HDR_ID=AI.DOC_HDR_ID join KREW_DOC_TYP_T DT on DH.DOC_TYP_ID=DT.DOC_TYP_ID where DH.DOC_HDR_STAT_CD='R' AND AI.DOC_HDR_ID IS NULL";
    private static final String ALL_STUCK_DOCUMENT_ACTION_REQUEST_SQL = "select DH.DOC_HDR_ID, DH.CRTE_DT, DT.LBL from KREW_DOC_HDR_T DH left outer join KREW_ACTN_RQST_T AR on DH.DOC_HDR_ID=AR.DOC_HDR_ID AND AR.STAT_CD = 'A' join KREW_DOC_TYP_T DT on DH.DOC_TYP_ID=DT.DOC_TYP_ID where DH.DOC_HDR_STAT_CD='R' AND AR.DOC_HDR_ID IS NULL";
    private static final String IS_STUCK_DOCUMENT_ACTION_ITEM_SQL = "select DH.DOC_HDR_ID, DH.CRTE_DT, DT.LBL from KREW_DOC_HDR_T DH left outer join KREW_ACTN_ITM_T AI on DH.DOC_HDR_ID=AI.DOC_HDR_ID join KREW_DOC_TYP_T DT on DH.DOC_TYP_ID=DT.DOC_TYP_ID where DH.DOC_HDR_STAT_CD='R' AND AI.DOC_HDR_ID IS NULL AND DH.DOC_HDR_ID = ?";
    private static final String IS_STUCK_DOCUMENT_ACTION_REQUEST_SQL = "select DH.DOC_HDR_ID, DH.CRTE_DT, DT.LBL from KREW_DOC_HDR_T DH left outer join KREW_ACTN_RQST_T AR on DH.DOC_HDR_ID=AR.DOC_HDR_ID AND AR.STAT_CD = 'A' join KREW_DOC_TYP_T DT on DH.DOC_TYP_ID=DT.DOC_TYP_ID where DH.DOC_HDR_STAT_CD='R' AND AR.DOC_HDR_ID IS NULL AND DH.DOC_HDR_ID = ?";
    static final String FIX_ATTEMPTS_FOR_INCIDENT_NAME = "StuckDocumentFixAttempt.FixAttemptsForIncident";
    static final String FIX_ATTEMPTS_FOR_INCIDENT_QUERY = "select fa from StuckDocumentFixAttempt fa where fa.stuckDocumentIncidentId = :stuckDocumentIncidentId";
    private EntityManager entityManager;

    @Override
    public List<String> findAllStuckDocumentIds() {
        return this.findAllStuckDocuments().stream().map(StuckDocument::getDocumentId).collect(Collectors.toList());
    }

    @Override
    public List<StuckDocument> findAllStuckDocuments() {
        ArrayList stuckDocumentResults = new ArrayList();
        stuckDocumentResults.addAll(this.entityManager.createNativeQuery(ALL_STUCK_DOCUMENT_ACTION_ITEM_SQL).getResultList());
        stuckDocumentResults.addAll(this.entityManager.createNativeQuery(ALL_STUCK_DOCUMENT_ACTION_REQUEST_SQL).getResultList());
        List<StuckDocument> unfilteredStuckDocuments = stuckDocumentResults.stream().map(result -> new StuckDocument((String)result[0], (String)result[2], ((Timestamp)result[1]).toLocalDateTime())).collect(Collectors.toList());
        return this.filterDuplicateStuckDocuments(unfilteredStuckDocuments);
    }

    private List<StuckDocument> filterDuplicateStuckDocuments(List<StuckDocument> unfilteredStuckDocuments) {
        HashSet processedDocumentIds = new HashSet();
        return unfilteredStuckDocuments.stream().filter(stuckDocument -> {
            if (processedDocumentIds.contains(stuckDocument.getDocumentId())) {
                return false;
            }
            processedDocumentIds.add(stuckDocument.getDocumentId());
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public StuckDocumentIncident findIncident(String stuckDocumentIncidentId) {
        return (StuckDocumentIncident)this.entityManager.find(StuckDocumentIncident.class, (Object)stuckDocumentIncidentId);
    }

    @Override
    public StuckDocumentIncident saveIncident(StuckDocumentIncident incident) {
        return (StuckDocumentIncident)this.entityManager.merge((Object)incident);
    }

    @Override
    public void deleteIncident(StuckDocumentIncident incident) {
        this.entityManager.remove((Object)incident);
    }

    @Override
    public List<StuckDocumentIncident> findAllIncidents(int maxIncidents) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(StuckDocumentIncident.class);
        Root incident = q.from(StuckDocumentIncident.class);
        q.select((Selection)incident).orderBy(new Order[]{cb.desc((Expression)incident.get("startDate"))});
        TypedQuery query = this.getEntityManager().createQuery(q);
        query.setMaxResults(maxIncidents);
        return new ArrayList<StuckDocumentIncident>(query.getResultList());
    }

    @Override
    public List<StuckDocumentIncident> findIncidentsByStatus(int maxIncidents, StuckDocumentIncident.Status status) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(StuckDocumentIncident.class);
        Root incident = q.from(StuckDocumentIncident.class);
        q.select((Selection)incident).orderBy(new Order[]{cb.desc((Expression)incident.get("startDate"))});
        ParameterExpression statusParameter = cb.parameter(StuckDocumentIncident.Status.class);
        q.where((Expression)cb.equal((Expression)incident.get("status"), (Expression)statusParameter));
        TypedQuery query = this.getEntityManager().createQuery(q);
        query.setParameter((Parameter)statusParameter, (Object)status);
        query.setMaxResults(maxIncidents);
        return new ArrayList<StuckDocumentIncident>(query.getResultList());
    }

    @Override
    public List<StuckDocumentFixAttempt> findAllFixAttempts(String stuckDocumentIncidentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery(FIX_ATTEMPTS_FOR_INCIDENT_NAME, StuckDocumentFixAttempt.class);
        query.setParameter("stuckDocumentIncidentId", (Object)stuckDocumentIncidentId);
        return new ArrayList<StuckDocumentFixAttempt>(query.getResultList());
    }

    @Override
    public StuckDocumentFixAttempt saveFixAttempt(StuckDocumentFixAttempt auditEntry) {
        return (StuckDocumentFixAttempt)this.entityManager.merge((Object)auditEntry);
    }

    @Override
    public List<String> identifyNewStuckDocuments() {
        HashSet documentIds = new HashSet();
        documentIds.addAll(this.entityManager.createNativeQuery(NEW_STUCK_DOCUMENT_ACTION_ITEM_SQL).getResultList());
        documentIds.addAll(this.entityManager.createNativeQuery(NEW_STUCK_DOCUMENT_ACTION_REQUEST_SQL).getResultList());
        return Collections.unmodifiableList(new ArrayList(documentIds));
    }

    public boolean isStuck(String documentId) {
        Query aiQuery = this.entityManager.createNativeQuery(IS_STUCK_DOCUMENT_ACTION_ITEM_SQL);
        Query arQuery = this.entityManager.createNativeQuery(IS_STUCK_DOCUMENT_ACTION_REQUEST_SQL);
        aiQuery.setParameter(1, (Object)documentId);
        arQuery.setParameter(1, (Object)documentId);
        return !aiQuery.getResultList().isEmpty() || !arQuery.getResultList().isEmpty();
    }

    @Override
    public List<StuckDocumentIncident> identifyStillStuckDocuments(List<String> incidentIds) {
        return incidentIds.stream().map(this::findIncident).filter(incident -> this.isStuck(incident.getDocumentId())).collect(Collectors.toList());
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Required
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

