/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.rice.core.api.config.property.RuntimeConfig;
import org.kuali.rice.kew.impl.stuck.StuckDocument;
import org.kuali.rice.kew.impl.stuck.StuckDocumentDao;
import org.kuali.rice.kew.impl.stuck.StuckDocumentFixAttempt;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentNotifier;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.springframework.beans.factory.annotation.Required;

public class StuckDocumentServiceImpl
implements StuckDocumentService {
    private StuckDocumentDao stuckDocumentDao;
    private StuckDocumentNotifier notifier;
    private RuntimeConfig failureNotificationEnabled;

    @Override
    public List<String> findAllStuckDocumentIds() {
        return this.getStuckDocumentDao().findAllStuckDocumentIds();
    }

    @Override
    public List<StuckDocument> findAllStuckDocuments() {
        return this.getStuckDocumentDao().findAllStuckDocuments();
    }

    @Override
    public StuckDocumentIncident findIncident(String stuckDocumentIncidentId) {
        Preconditions.checkNotNull((Object)stuckDocumentIncidentId);
        return this.getStuckDocumentDao().findIncident(stuckDocumentIncidentId);
    }

    @Override
    public List<StuckDocumentIncident> findIncidents(List<String> stuckDocumentIncidentIds) {
        Preconditions.checkNotNull(stuckDocumentIncidentIds);
        ArrayList<StuckDocumentIncident> incidents = new ArrayList<StuckDocumentIncident>(stuckDocumentIncidentIds.size());
        for (String stuckDocumentIncidentId : stuckDocumentIncidentIds) {
            StuckDocumentIncident incident = this.findIncident(stuckDocumentIncidentId);
            if (incident == null) continue;
            incidents.add(incident);
        }
        return incidents;
    }

    @Override
    public List<StuckDocumentIncident> findAllIncidents(int maxIncidents) {
        return this.getStuckDocumentDao().findAllIncidents(maxIncidents);
    }

    @Override
    public List<StuckDocumentIncident> findIncidentsByStatus(int maxIncidents, StuckDocumentIncident.Status status) {
        return this.getStuckDocumentDao().findIncidentsByStatus(maxIncidents, status);
    }

    @Override
    public List<StuckDocumentIncident> recordNewStuckDocumentIncidents() {
        List<String> newStuckDocuments = this.getStuckDocumentDao().identifyNewStuckDocuments();
        return newStuckDocuments.stream().map(documentId -> this.getStuckDocumentDao().saveIncident(StuckDocumentIncident.startNewIncident(documentId))).collect(Collectors.toList());
    }

    @Override
    public StuckDocumentFixAttempt recordNewIncidentFixAttempt(StuckDocumentIncident stuckDocumentIncident) {
        Preconditions.checkNotNull((Object)stuckDocumentIncident);
        StuckDocumentFixAttempt auditEntry = new StuckDocumentFixAttempt();
        auditEntry.setStuckDocumentIncidentId(stuckDocumentIncident.getStuckDocumentIncidentId());
        auditEntry.setTimestamp(new Timestamp(System.currentTimeMillis()));
        return this.getStuckDocumentDao().saveFixAttempt(auditEntry);
    }

    @Override
    public List<StuckDocumentFixAttempt> findAllFixAttempts(String stuckDocumentIncidentId) {
        return this.getStuckDocumentDao().findAllFixAttempts(stuckDocumentIncidentId);
    }

    @Override
    public List<StuckDocumentIncident> resolveIncidentsIfPossible(List<String> stuckDocumentIncidentIds) {
        Preconditions.checkNotNull(stuckDocumentIncidentIds);
        List<StuckDocumentIncident> stuckIncidents = this.getStuckDocumentDao().identifyStillStuckDocuments(stuckDocumentIncidentIds);
        List stuckIncidentIds = stuckIncidents.stream().map(StuckDocumentIncident::getStuckDocumentIncidentId).collect(Collectors.toList());
        ArrayList<String> notStuckIncidentIds = new ArrayList<String>(stuckDocumentIncidentIds);
        notStuckIncidentIds.removeAll(stuckIncidentIds);
        if (!notStuckIncidentIds.isEmpty()) {
            List<StuckDocumentIncident> notStuckIncidents = this.findIncidents(notStuckIncidentIds);
            notStuckIncidents.forEach(this::resolve);
        }
        return stuckIncidents;
    }

    protected StuckDocumentIncident resolve(StuckDocumentIncident stuckDocumentIncident) {
        Preconditions.checkNotNull((Object)stuckDocumentIncident);
        if (stuckDocumentIncident.getStatus().equals((Object)StuckDocumentIncident.Status.PENDING)) {
            this.getStuckDocumentDao().deleteIncident(stuckDocumentIncident);
            return stuckDocumentIncident;
        }
        stuckDocumentIncident.setStatus(StuckDocumentIncident.Status.FIXED);
        stuckDocumentIncident.setEndDate(new Timestamp(System.currentTimeMillis()));
        return this.getStuckDocumentDao().saveIncident(stuckDocumentIncident);
    }

    @Override
    public StuckDocumentIncident startFixingIncident(StuckDocumentIncident stuckDocumentIncident) {
        Preconditions.checkNotNull((Object)stuckDocumentIncident);
        stuckDocumentIncident.setStatus(StuckDocumentIncident.Status.FIXING);
        return this.getStuckDocumentDao().saveIncident(stuckDocumentIncident);
    }

    @Override
    public StuckDocumentIncident recordIncidentFailure(StuckDocumentIncident stuckDocumentIncident) {
        Preconditions.checkNotNull((Object)stuckDocumentIncident);
        stuckDocumentIncident.setStatus(StuckDocumentIncident.Status.FAILED);
        stuckDocumentIncident.setEndDate(new Timestamp(System.currentTimeMillis()));
        stuckDocumentIncident = this.getStuckDocumentDao().saveIncident(stuckDocumentIncident);
        this.notifyIncidentFailure(stuckDocumentIncident);
        return stuckDocumentIncident;
    }

    protected void notifyIncidentFailure(StuckDocumentIncident stuckDocumentIncident) {
        if (this.getFailureNotificationEnabled().getValueAsBoolean().booleanValue()) {
            List<StuckDocumentFixAttempt> attempts = this.getStuckDocumentDao().findAllFixAttempts(stuckDocumentIncident.getStuckDocumentIncidentId());
            this.notifier.notifyIncidentFailure(stuckDocumentIncident, attempts);
        }
    }

    protected StuckDocumentDao getStuckDocumentDao() {
        return this.stuckDocumentDao;
    }

    @Required
    public void setStuckDocumentDao(StuckDocumentDao stuckDocumentDao) {
        this.stuckDocumentDao = stuckDocumentDao;
    }

    protected StuckDocumentNotifier getNotifier() {
        return this.notifier;
    }

    @Required
    public void setNotifier(StuckDocumentNotifier notifier) {
        this.notifier = notifier;
    }

    protected RuntimeConfig getFailureNotificationEnabled() {
        return this.failureNotificationEnabled;
    }

    @Required
    public void setFailureNotificationEnabled(RuntimeConfig failureNotificationEnabled) {
        this.failureNotificationEnabled = failureNotificationEnabled;
    }
}

