/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.lifecycle;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.kew.batch.ExternalActnListNotificationService;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class ExternalActnListNotificationLifecycle
extends BaseLifecycle {
    protected final Logger LOG = Logger.getLogger(ExternalActnListNotificationLifecycle.class);
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture future;

    public void start() throws Exception {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        ExternalActnListNotificationService alcPoller = KEWServiceLocator.getExternalActnListNotificationService();
        this.LOG.info((Object)("Starting the external action list notification service.  Polling at " + alcPoller.getExternalActnListNotificationPollIntervalSeconds() + " second intervals!"));
        this.future = this.scheduledExecutor.scheduleWithFixedDelay(alcPoller, alcPoller.getExternalActnListNotificationInitialDelaySeconds(), alcPoller.getExternalActnListNotificationPollIntervalSeconds(), TimeUnit.SECONDS);
        super.start();
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            this.LOG.warn((Object)"Shutting down the external action list notification service");
            try {
                if (this.future != null) {
                    if (!this.future.cancel(false)) {
                        this.LOG.warn((Object)"Failed to cancel the external action list notification service.");
                    }
                    this.future = null;
                }
                if (this.scheduledExecutor != null) {
                    this.scheduledExecutor.shutdownNow();
                    this.scheduledExecutor = null;
                }
            }
            finally {
                super.stop();
            }
        }
    }
}

