/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.AbstractWorkflowAttribute;
import org.kuali.rice.kew.rule.GenericAttributeContent;
import org.kuali.rice.kew.rule.RuleExtensionValue;

public abstract class GenericWorkflowAttribute
extends AbstractWorkflowAttribute {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final String attributeName;
    protected final GenericAttributeContent content;

    public GenericWorkflowAttribute() {
        this(null);
    }

    public GenericWorkflowAttribute(String uniqueName) {
        this.attributeName = uniqueName != null ? uniqueName : this.getClass().getName();
        this.content = new GenericAttributeContent(this.attributeName);
    }

    public abstract Map<String, String> getProperties();

    @Override
    public String getDocContent() {
        String dc = this.content.generateContent(this.getProperties());
        return dc;
    }

    @Override
    public boolean isMatch(DocumentContent docContent, List<RuleExtension> ruleExtensions) {
        this.log.info((Object)("isMatch: " + docContent + " " + ruleExtensions));
        try {
            List<Map<String, String>> propertiesList = this.content.parseContent(docContent.getAttributeContent());
            return this.isMatch(propertiesList, ruleExtensions);
        }
        catch (XPathExpressionException xpee) {
            String message = "Error parsing attribute '" + this.attributeName + "' content: " + docContent.getDocContent();
            this.log.error((Object)message, (Throwable)xpee);
            throw new RuntimeException(xpee);
        }
    }

    protected boolean isMatch(List<Map<String, String>> propertiesList, List<RuleExtension> ruleExtensions) {
        Iterator<Map<String, String>> iterator = propertiesList.iterator();
        if (iterator.hasNext()) {
            Map<String, String> properties = iterator.next();
            return this.isMatch(properties, ruleExtensions);
        }
        return false;
    }

    protected boolean isMatch(Map<String, String> properties, List<RuleExtension> ruleExtensions) {
        for (RuleExtension ruleExtension : ruleExtensions) {
            for (Map.Entry ruleExtensionValue : ruleExtension.getExtensionValuesMap().entrySet()) {
                if (ObjectUtils.equals(ruleExtensionValue.getValue(), (Object)properties.get(ruleExtensionValue.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    public List validateRoutingData(Map paramMap) {
        return Collections.EMPTY_LIST;
    }

    public List validateRuleData(Map paramMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<RuleExtensionValue> getRuleExtensionValues() {
        this.log.info((Object)"getRuleExtensionValues");
        ArrayList<RuleExtensionValue> exts = new ArrayList<RuleExtensionValue>();
        Map<String, String> props = this.getProperties();
        if (props != null) {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                if (entry.getValue() == null) continue;
                RuleExtensionValue ruleVal = new RuleExtensionValue();
                ruleVal.setKey(entry.getKey());
                ruleVal.setValue(entry.getValue());
                exts.add(ruleVal);
            }
        }
        return exts;
    }
}

