/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.dao.RuleAttributeDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class RuleAttributeDAOJpa
implements RuleAttributeDAO {
    private static final Logger LOG = Logger.getLogger(RuleAttributeDAOJpa.class);
    private EntityManager entityManager;
    private DataObjectService dataObjectService;

    @Override
    public void save(RuleAttribute ruleAttribute) {
        this.getDataObjectService().save((Object)ruleAttribute, new PersistenceOption[0]);
    }

    @Override
    public void delete(String ruleAttributeId) {
        RuleAttribute ruleAttribute = this.findByRuleAttributeId(ruleAttributeId);
        this.getDataObjectService().delete((Object)ruleAttribute);
    }

    @Override
    public RuleAttribute findByRuleAttributeId(String ruleAttributeId) {
        return (RuleAttribute)((Object)this.getDataObjectService().find(RuleAttribute.class, (Object)ruleAttributeId));
    }

    @Override
    public List<RuleAttribute> findByRuleAttribute(RuleAttribute ruleAttribute) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (ruleAttribute.getName() != null) {
            predicates.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)ruleAttribute.getName()));
        }
        if (ruleAttribute.getResourceDescriptor() != null) {
            predicates.add(PredicateFactory.likeIgnoreCase((String)"resourceDescriptor", (CharSequence)ruleAttribute.getResourceDescriptor()));
        }
        if (ruleAttribute.getType() != null) {
            predicates.add(PredicateFactory.likeIgnoreCase((String)"type", (CharSequence)ruleAttribute.getType()));
        }
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults results = this.getDataObjectService().findMatching(RuleAttribute.class, builder.build());
        return results.getResults();
    }

    @Override
    public List<RuleAttribute> getAllRuleAttributes() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        QueryResults results = this.getDataObjectService().findMatching(RuleAttribute.class, builder.build());
        return results.getResults();
    }

    @Override
    public RuleAttribute findByName(String name) {
        LOG.debug((Object)("findByName name=" + name));
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name)});
        QueryResults ruleAttributeQueryResults = this.getDataObjectService().findMatching(RuleAttribute.class, builder.build());
        if (ruleAttributeQueryResults != null && ruleAttributeQueryResults.getResults().size() > 0) {
            return (RuleAttribute)((Object)ruleAttributeQueryResults.getResults().get(0));
        }
        return null;
    }

    @Override
    public List<RuleAttribute> findByClassName(String classname) {
        LOG.debug((Object)("findByClassName classname=" + classname));
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"resourceDescriptor", (Object)classname)});
        QueryResults ruleAttributeQueryResults = this.getDataObjectService().findMatching(RuleAttribute.class, builder.build());
        return ruleAttributeQueryResults.getResults();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

