/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.dao.RuleDelegationDAO;
import org.kuali.rice.kew.rule.service.RuleDelegationService;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.RuleXmlParser;
import org.kuali.rice.kew.xml.export.RuleDelegationXmlExporter;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RuleDelegationServiceImpl
implements RuleDelegationService {
    private static final Logger LOG = Logger.getLogger(RuleDelegationServiceImpl.class);
    private static final String XML_PARSE_ERROR = "general.error.parsexml";
    private RuleDelegationDAO dao;

    @Override
    public List<RuleDelegationBo> findByDelegateRuleId(String ruleId) {
        if (ruleId == null) {
            return Collections.EMPTY_LIST;
        }
        return this.dao.findByDelegateRuleId(ruleId);
    }

    @Override
    public void save(RuleDelegationBo ruleDelegation) {
        this.dao.save(ruleDelegation);
    }

    public void setRuleDelegationDAO(RuleDelegationDAO dao) {
        this.dao = dao;
    }

    @Override
    public List<RuleDelegationBo> findAllCurrentRuleDelegations() {
        return this.dao.findAllCurrentRuleDelegations();
    }

    @Override
    public void delete(String ruleDelegationId) {
        this.dao.delete(ruleDelegationId);
    }

    @Override
    public RuleDelegationBo findByRuleDelegationId(String ruleDelegationId) {
        return this.dao.findByRuleDelegationId(ruleDelegationId);
    }

    @Override
    public List<RuleDelegationBo> findByResponsibilityId(String responsibilityId) {
        return this.findByResponsibilityId(responsibilityId, false);
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String groupId, String principalId, String delegationType, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        return this.dao.search(parentRuleBaseVaueId, parentResponsibilityId, docTypeName, ruleId, ruleTemplateId, ruleDescription, groupId, principalId, delegationType, activeInd, extensionValues, workflowIdDirective);
    }

    @Override
    public List<RuleDelegationBo> searchByTemplate(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleTemplateName, String ruleDescription, String groupId, String principalId, Boolean workgroupMember, String delegationType, Boolean activeInd, Map extensionValues, Collection<String> actionRequestCodes) {
        if (StringUtils.isEmpty((String)docTypeName) && StringUtils.isEmpty((String)ruleTemplateName) && StringUtils.isEmpty((String)ruleDescription) && StringUtils.isEmpty((String)groupId) && StringUtils.isEmpty((String)principalId) && extensionValues.isEmpty() && actionRequestCodes.isEmpty()) {
            throw new IllegalArgumentException("At least one criterion must be sent");
        }
        RuleTemplateBo ruleTemplate = this.getRuleTemplateService().findByRuleTemplateName(ruleTemplateName);
        String ruleTemplateId = null;
        if (ruleTemplate != null) {
            ruleTemplateId = ruleTemplate.getId();
        }
        if (extensionValues != null && !extensionValues.isEmpty() && ruleTemplateId == null) {
            throw new IllegalArgumentException("A Rule Template Name must be given if using Rule Extension values");
        }
        List<String> workgroupIds = new ArrayList();
        if (principalId != null) {
            if (workgroupMember == null || workgroupMember.booleanValue()) {
                workgroupIds = this.getGroupService().getGroupIdsByPrincipalId(principalId);
            }
        } else if (groupId != null) {
            Group group = KEWServiceLocator.getIdentityHelperService().getGroup(groupId);
            if (group == null) {
                throw new IllegalArgumentException("Group does not exist in for given group id: " + groupId);
            }
            workgroupIds.add(group.getId());
        }
        return this.dao.search(parentRuleBaseVaueId, parentResponsibilityId, docTypeName, ruleTemplateId, ruleDescription, workgroupIds, principalId, delegationType, activeInd, extensionValues, actionRequestCodes);
    }

    public void loadXml(InputStream inputStream, String principalId) {
        RuleXmlParser parser = new RuleXmlParser();
        try {
            parser.parseRuleDelegations(inputStream);
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading xml file", (Throwable)e);
            WorkflowServiceErrorException wsee = new WorkflowServiceErrorException("Error loading xml file", new WorkflowServiceErrorImpl("Error loading xml file", XML_PARSE_ERROR));
            wsee.initCause(e);
            throw wsee;
        }
    }

    public Element export(ExportDataSet dataSet) {
        RuleDelegationXmlExporter exporter = new RuleDelegationXmlExporter();
        return exporter.export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    private GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    private RuleTemplateService getRuleTemplateService() {
        return KEWServiceLocator.getRuleTemplateService();
    }

    public List findByResponsibilityId(String responsibilityId, boolean ignoreCache) {
        return this.dao.findByResponsibilityIdWithCurrentRule(responsibilityId);
    }
}

