/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;

public class DocumentTypeWindowTargets {
    private static final Logger LOG = Logger.getLogger(DocumentTypeWindowTargets.class);
    private static final String DEFAULT_KEY = "*";
    private final Map<String, String> documentTargetMappings;
    private final Map<String, String> routeLogTargetMappings;
    private final DocumentTypeService documentTypeService;
    private final String defaultDocumentTarget;
    private final String defaultRouteLogTarget;
    private final Map<String, String> documentTargetCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> routeLogTargetCache = new ConcurrentHashMap<String, String>();

    public DocumentTypeWindowTargets(String documentTargetSpec, String routeLogTargetSpec, String defaultDocumentTarget, String defaultRouteLogTarget, DocumentTypeService documentTypeService) {
        if (StringUtils.isBlank((String)defaultDocumentTarget)) {
            throw new IllegalArgumentException("defaultDocumentTarget must not be blank");
        }
        if (StringUtils.isBlank((String)defaultRouteLogTarget)) {
            throw new IllegalArgumentException("defaultRouteLogTarget must not be blank");
        }
        if (documentTypeService == null) {
            throw new IllegalArgumentException("documentTypeService must not be nulll");
        }
        this.documentTargetMappings = new HashMap<String, String>();
        this.routeLogTargetMappings = new HashMap<String, String>();
        this.documentTypeService = documentTypeService;
        this.defaultDocumentTarget = defaultDocumentTarget;
        this.defaultRouteLogTarget = defaultRouteLogTarget;
        this.parseTargetSpec(documentTargetSpec, this.documentTargetMappings);
        this.parseTargetSpec(routeLogTargetSpec, this.routeLogTargetMappings);
    }

    private void parseTargetSpec(String targetSpec, Map<String, String> targetMappings) {
        if (!StringUtils.isBlank((String)targetSpec)) {
            String[] entries;
            for (String entry : entries = targetSpec.split(",")) {
                String[] docTypeTarget = entry.split(":");
                if (docTypeTarget.length != 2) {
                    LOG.warn((Object)("Encountered an invalid entry in target spec, ignoring: " + entry));
                    continue;
                }
                targetMappings.put(docTypeTarget[0], docTypeTarget[1]);
            }
        }
    }

    public String getDocumentTarget(String documentTypeName) {
        return this.getTargetInternal(documentTypeName, false, 0);
    }

    public String getRouteLogTarget(String documentTypeName) {
        return this.getTargetInternal(documentTypeName, true, 0);
    }

    private String getTargetInternal(String documentTypeName, boolean isRouteLog, int depth) {
        Map<String, String> targetCache;
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("Document type name must not be blank");
        }
        Map<String, String> map = targetCache = isRouteLog ? this.routeLogTargetCache : this.documentTargetCache;
        if (!targetCache.containsKey(documentTypeName)) {
            String parentDocumentTypeName;
            DocumentTypePolicy docSearchTarget;
            DocumentType documentType;
            Map<String, String> targetMappings = isRouteLog ? this.routeLogTargetMappings : this.documentTargetMappings;
            String target = targetMappings.get(documentTypeName);
            if (target == null && depth == 0 && (documentType = this.documentTypeService.findByName(documentTypeName)) != null && (docSearchTarget = documentType.getDocSearchTarget()).getPolicyStringValue() != null) {
                target = docSearchTarget.getPolicyStringValue();
            }
            if (target == null && (parentDocumentTypeName = this.documentTypeService.findParentNameByName(documentTypeName)) != null) {
                target = this.getTargetInternal(parentDocumentTypeName, isRouteLog, depth + 1);
            }
            if (target == null && (target = targetMappings.get(DEFAULT_KEY)) == null) {
                target = isRouteLog ? this.defaultRouteLogTarget : this.defaultDocumentTarget;
            }
            targetCache.put(documentTypeName, target);
        }
        return targetCache.get(documentTypeName);
    }
}

