/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.config.property.RuntimeConfig;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.impl.stuck.StuckDocument;
import org.kuali.rice.kew.impl.stuck.StuckDocumentFixAttempt;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentNotificationJob;
import org.kuali.rice.kew.impl.stuck.StuckDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.StuckDocumentsForm;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class StuckDocumentsAction
extends KualiAction {
    private static final String NOTIFICATION_ENABLED = "stuckDocumentsNotificationEnabledParam";
    private static final String NOTIFICATION_CRON_EXPRESSION = "stuckDocumentsNotificationCronExpressionParam";
    private static final String NOTIFICATION_FROM = "stuckDocumentsNotificationFromParam";
    private static final String NOTIFICATION_TO = "stuckDocumentsNotificationToParam";
    private static final String NOTIFICATION_SUBJECT = "stuckDocumentsNotificationSubjectParam";
    private static final String AUTOFIX_ENABLED = "stuckDocumentsAutofixEnabledParam";
    private static final String AUTOFIX_CRON_EXPRESSION = "stuckDocumentsAutofixCronExpressionParam";
    private static final String AUTOFIX_QUIET_PERIOD = "stuckDocumentsAutofixQuietPeriodParam";
    private static final String AUTOFIX_MAX_ATTEMPTS = "stuckDocumentsAutofixMaxAttemptsParam";
    private static final String AUTOFIX_NOTIFICATION_ENABLED = "stuckDocumentsAutofixNotificationEnabledParam";
    private static final String AUTOFIX_NOTIFICATION_SUBJECT = "stuckDocumentsAutofixNotificationSubjectParam";
    private static final int MAX_INCIDENTS = 1000;

    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        boolean authorized = false;
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        RoleService roleService = KimApiServiceLocator.getRoleService();
        String roleId = roleService.getRoleIdByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        if (roleId != null) {
            authorized = roleService.principalHasRole(principalId, Collections.singletonList(roleId), new HashMap(), true);
        }
        if (!authorized) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), methodToCall, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected ActionForward defaultDispatch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StuckDocumentsForm form = (StuckDocumentsForm)actionForm;
        form.setNotificationEnabled(this.getNotificationEnabled().getValue());
        form.setNotificationCronExpression(this.getNotificationCronExpression().getValue());
        form.setNotificationFrom(this.getNotificationFrom().getValue());
        form.setNotificationTo(this.getNotificationTo().getValue());
        form.setNotificationSubject(this.getNotificationSubject().getValue());
        form.setAutofixEnabled(this.getAutofixEnabled().getValue());
        form.setAutofixCronExpression(this.getAutofixCronExpression().getValue());
        form.setAutofixQuietPeriod(this.getAutofixQuietPeriod().getValue());
        form.setAutofixMaxAttempts(this.getAutofixMaxAttempts().getValue());
        form.setAutofixNotificationEnabled(this.getAutofixNotificationEnabled().getValue());
        form.setAutofixNotificationSubject(this.getAutofixNotificationSubject().getValue());
        return super.defaultDispatch(mapping, (ActionForm)form, request, response);
    }

    public ActionForward updateConfig(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StuckDocumentsForm form = (StuckDocumentsForm)actionForm;
        this.getNotificationEnabled().setValue(form.getNotificationEnabled());
        this.getNotificationCronExpression().setValue(form.getNotificationCronExpression());
        this.getNotificationFrom().setValue(form.getNotificationFrom());
        this.getNotificationTo().setValue(form.getNotificationTo());
        this.getNotificationSubject().setValue(form.getNotificationSubject());
        this.getAutofixEnabled().setValue(form.getAutofixEnabled());
        this.getAutofixCronExpression().setValue(form.getAutofixCronExpression());
        this.getAutofixQuietPeriod().setValue(form.getAutofixQuietPeriod());
        this.getAutofixMaxAttempts().setValue(form.getAutofixMaxAttempts());
        this.getAutofixNotificationEnabled().setValue(form.getAutofixNotificationEnabled());
        this.getAutofixNotificationSubject().setValue(form.getAutofixNotificationSubject());
        return mapping.findForward("basic");
    }

    public ActionForward runStuckNotificationNow(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateConfig(mapping, actionForm, request, response);
        new StuckDocumentNotificationJob().execute(null);
        return mapping.findForward("basic");
    }

    public ActionForward report(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<StuckDocument> stuckDocuments = this.getStuckDocumentService().findAllStuckDocuments();
        request.setAttribute("stuckDocuments", stuckDocuments);
        return mapping.findForward("report");
    }

    public ActionForward autofixReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StuckDocumentService stuckDocumentService = this.getStuckDocumentService();
        StuckDocumentsForm form = (StuckDocumentsForm)actionForm;
        StuckDocumentsForm.Status selectedStatus = form.getSelectedStatus();
        List<StuckDocumentIncident> incidents = selectedStatus == null || selectedStatus.getValue().equals("All") ? stuckDocumentService.findAllIncidents(1000) : stuckDocumentService.findIncidentsByStatus(1000, StuckDocumentIncident.Status.valueOf(selectedStatus.getValue()));
        List history = incidents.stream().map(incident -> {
            List<StuckDocumentFixAttempt> attempts = stuckDocumentService.findAllFixAttempts(incident.getStuckDocumentIncidentId());
            String documentTypeLabel = this.getDocumentTypeService().findByDocumentId(incident.getDocumentId()).getLabel();
            return new IncidentHistory((StuckDocumentIncident)incident, attempts, documentTypeLabel);
        }).collect(Collectors.toList());
        request.setAttribute("history", history);
        return mapping.findForward("autofixReport");
    }

    private RuntimeConfig getNotificationEnabled() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)NOTIFICATION_ENABLED);
    }

    private RuntimeConfig getNotificationCronExpression() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)NOTIFICATION_CRON_EXPRESSION);
    }

    private RuntimeConfig getNotificationFrom() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)NOTIFICATION_FROM);
    }

    private RuntimeConfig getNotificationTo() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)NOTIFICATION_TO);
    }

    private RuntimeConfig getNotificationSubject() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)NOTIFICATION_SUBJECT);
    }

    private RuntimeConfig getAutofixEnabled() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)AUTOFIX_ENABLED);
    }

    private RuntimeConfig getAutofixCronExpression() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)AUTOFIX_CRON_EXPRESSION);
    }

    private RuntimeConfig getAutofixQuietPeriod() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)AUTOFIX_QUIET_PERIOD);
    }

    private RuntimeConfig getAutofixMaxAttempts() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)AUTOFIX_MAX_ATTEMPTS);
    }

    private RuntimeConfig getAutofixNotificationEnabled() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)AUTOFIX_NOTIFICATION_ENABLED);
    }

    private RuntimeConfig getAutofixNotificationSubject() {
        return (RuntimeConfig)GlobalResourceLoader.getService((String)AUTOFIX_NOTIFICATION_SUBJECT);
    }

    private StuckDocumentService getStuckDocumentService() {
        return KEWServiceLocator.getStuckDocumentService();
    }

    private DocumentTypeService getDocumentTypeService() {
        return KEWServiceLocator.getDocumentTypeService();
    }

    public static class IncidentHistory {
        private final StuckDocumentIncident incident;
        private final List<StuckDocumentFixAttempt> attempts;
        private final String documentTypeLabel;

        IncidentHistory(StuckDocumentIncident incident, List<StuckDocumentFixAttempt> attempts, String documentTypeLabel) {
            this.incident = incident;
            this.attempts = attempts;
            this.documentTypeLabel = documentTypeLabel;
        }

        public String getDocumentId() {
            return this.incident.getDocumentId();
        }

        public String getStartDate() {
            return this.incident.getStartDate().toString();
        }

        public String getEndDate() {
            if (this.incident.getEndDate() == null) {
                return "";
            }
            return this.incident.getEndDate().toString();
        }

        public String getStatus() {
            return this.incident.getStatus().name();
        }

        public String getFixAttempts() {
            return this.attempts.stream().map(attempt -> attempt.getTimestamp().toString()).collect(Collectors.joining(", "));
        }

        public String getDocumentTypeLabel() {
            return this.documentTypeLabel;
        }
    }
}

