/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class StuckDocumentsForm
extends KualiForm {
    private String notificationEnabled;
    private String notificationCronExpression;
    private String notificationFrom;
    private String notificationTo;
    private String notificationSubject;
    private String autofixEnabled;
    private String autofixCronExpression;
    private String autofixQuietPeriod;
    private String autofixMaxAttempts;
    private String autofixNotificationEnabled;
    private String autofixNotificationSubject;
    private List<Status> statuses = new ArrayList<Status>();

    public StuckDocumentsForm() {
        this.statuses.add(new Status("All", false));
        for (StuckDocumentIncident.Status status : StuckDocumentIncident.Status.values()) {
            this.statuses.add(new Status(status.name(), false));
        }
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        String statusFilter = request.getParameter("statusFilter");
        if (!StringUtils.isBlank((String)statusFilter)) {
            for (Status status : this.statuses) {
                if (!status.getValue().equals(statusFilter)) continue;
                status.setSelected(true);
                break;
            }
        }
    }

    public String getNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void setNotificationEnabled(String notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    public String getNotificationCronExpression() {
        return this.notificationCronExpression;
    }

    public void setNotificationCronExpression(String notificationCronExpression) {
        this.notificationCronExpression = notificationCronExpression;
    }

    public String getNotificationFrom() {
        return this.notificationFrom;
    }

    public void setNotificationFrom(String notificationFrom) {
        this.notificationFrom = notificationFrom;
    }

    public String getNotificationTo() {
        return this.notificationTo;
    }

    public void setNotificationTo(String notificationTo) {
        this.notificationTo = notificationTo;
    }

    public String getNotificationSubject() {
        return this.notificationSubject;
    }

    public void setNotificationSubject(String notificationSubject) {
        this.notificationSubject = notificationSubject;
    }

    public String getAutofixEnabled() {
        return this.autofixEnabled;
    }

    public void setAutofixEnabled(String autofixEnabled) {
        this.autofixEnabled = autofixEnabled;
    }

    public String getAutofixCronExpression() {
        return this.autofixCronExpression;
    }

    public void setAutofixCronExpression(String autofixCronExpression) {
        this.autofixCronExpression = autofixCronExpression;
    }

    public String getAutofixQuietPeriod() {
        return this.autofixQuietPeriod;
    }

    public void setAutofixQuietPeriod(String autofixQuietPeriod) {
        this.autofixQuietPeriod = autofixQuietPeriod;
    }

    public String getAutofixMaxAttempts() {
        return this.autofixMaxAttempts;
    }

    public void setAutofixMaxAttempts(String autofixMaxAttempts) {
        this.autofixMaxAttempts = autofixMaxAttempts;
    }

    public String getAutofixNotificationEnabled() {
        return this.autofixNotificationEnabled;
    }

    public void setAutofixNotificationEnabled(String autofixNotificationEnabled) {
        this.autofixNotificationEnabled = autofixNotificationEnabled;
    }

    public String getAutofixNotificationSubject() {
        return this.autofixNotificationSubject;
    }

    public void setAutofixNotificationSubject(String autofixNotificationSubject) {
        this.autofixNotificationSubject = autofixNotificationSubject;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<Status> statuses) {
        this.statuses = statuses;
    }

    public Status getSelectedStatus() {
        for (Status status : this.statuses) {
            if (!status.isSelected()) continue;
            return status;
        }
        return null;
    }

    public static class Status {
        private String value;
        private boolean selected;

        public Status(String value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

