/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.bo.RuleAttribute;

public class RuleAttributeXmlExporter
implements XmlExporter {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.RULE_ATTRIBUTE_NAMESPACE);

    public boolean supportPrettyPrint() {
        return true;
    }

    public Element export(ExportDataSet exportDataSet) {
        KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getRuleAttributes().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "ruleAttributes");
            rootElement.setAttribute("schemaLocation", "ns:workflow/RuleAttribute resource:RuleAttribute", XmlConstants.SCHEMA_NAMESPACE);
            for (RuleAttribute template : dataSet.getRuleAttributes()) {
                this.exportRuleAttribute(rootElement, template);
            }
            return rootElement;
        }
        return null;
    }

    private void exportRuleAttribute(Element parent, RuleAttribute ruleAttribute) {
        Element attributeElement = this.renderer.renderElement(parent, "ruleAttribute");
        this.renderer.renderTextElement(attributeElement, "name", ruleAttribute.getName());
        this.renderer.renderTextElement(attributeElement, "className", ruleAttribute.getResourceDescriptor());
        this.renderer.renderTextElement(attributeElement, "label", ruleAttribute.getLabel());
        this.renderer.renderTextElement(attributeElement, "description", ruleAttribute.getDescription());
        this.renderer.renderTextElement(attributeElement, "type", ruleAttribute.getType());
        this.renderer.renderTextElement(attributeElement, "applicationId", ruleAttribute.getApplicationId());
        if (!StringUtils.isEmpty((String)ruleAttribute.getXmlConfigData())) {
            try {
                Document configDoc = new SAXBuilder().build((Reader)new StringReader(ruleAttribute.getXmlConfigData()));
                XmlHelper.propagateNamespace((Element)configDoc.getRootElement(), (Namespace)XmlConstants.RULE_ATTRIBUTE_NAMESPACE);
                attributeElement.addContent(configDoc.getRootElement().detach());
            }
            catch (Exception e) {
                this.LOG.error((Object)"Error parsing attribute XML configuration.", (Throwable)e);
                throw new WorkflowRuntimeException("Error parsing attribute XML configuration.");
            }
        }
    }
}

