/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableToFromBase;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.type.KimTypeAttributesHelper;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_PND_DLGN_MBR_T")
public class RoleDocumentDelegationMember
extends KimDocumentBoActivatableToFromBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_DLGN_MBR_ID_S")
    @GeneratedValue(generator="KRIM_DLGN_MBR_ID_S")
    @Id
    @Column(name="DLGN_MBR_ID")
    protected String delegationMemberId;
    @Column(name="ROLE_MBR_ID")
    protected String roleMemberId;
    @Transient
    protected String roleMemberMemberId;
    @Transient
    protected String roleMemberMemberTypeCode;
    @Transient
    protected String roleMemberName;
    @Transient
    protected String roleMemberNamespaceCode;
    @Transient
    private KimTypeAttributesHelper attributesHelper;
    @Transient
    protected RoleBo roleBo = new RoleBo();
    @Column(name="DLGN_ID")
    protected String delegationId;
    @Column(name="MBR_ID")
    protected String memberId;
    @Column(name="MBR_TYP_CD")
    protected String memberTypeCode = KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode();
    @Transient
    protected String memberNamespaceCode;
    @Column(name="MBR_NM")
    protected String memberName;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=RoleDocumentDelegationMemberQualifier.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR"), @JoinColumn(name="DLGN_MBR_ID", referencedColumnName="DLGN_MBR_ID")})
    protected List<RoleDocumentDelegationMemberQualifier> qualifiers = new AutoPopulatingList(RoleDocumentDelegationMemberQualifier.class);
    @Transient
    protected String delegationTypeCode;

    public void loadTransientRoleFields() {
        if ((this.getRoleBo() == null || this.getRoleBo().getId() == null) && this.getRoleMemberId() != null) {
            UiDocumentService uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
            RoleMemberBo roleMember = uiDocumentService.getRoleMember(this.getRoleMemberId());
            this.setRoleMemberMemberId(roleMember.getMemberId());
            this.setRoleMemberMemberTypeCode(roleMember.getType().getCode());
            this.setRoleMemberName(uiDocumentService.getMemberName(MemberType.fromCode((String)this.getRoleMemberMemberTypeCode()), this.getRoleMemberMemberId()));
            this.setRoleMemberNamespaceCode(uiDocumentService.getMemberNamespaceCode(MemberType.fromCode((String)this.getRoleMemberMemberTypeCode()), this.getRoleMemberMemberId()));
            Role role = KimApiServiceLocator.getRoleService().getRole(roleMember.getRoleId());
            this.setRoleBo(RoleBo.from((Role)role));
        }
    }

    public String getDelegationTypeCode() {
        return this.delegationTypeCode;
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this.delegationTypeCode = delegationTypeCode;
    }

    public String getDelegationId() {
        return this._persistence_get_delegationId();
    }

    public void setDelegationId(String delegationId) {
        this._persistence_set_delegationId(delegationId);
    }

    public List<RoleDocumentDelegationMemberQualifier> getQualifiers() {
        return this._persistence_get_qualifiers();
    }

    public RoleDocumentDelegationMemberQualifier getQualifier(String kimAttributeDefnId) {
        for (RoleDocumentDelegationMemberQualifier qualifier : this._persistence_get_qualifiers()) {
            if (!qualifier.getKimAttrDefnId().equals(kimAttributeDefnId)) continue;
            return qualifier;
        }
        return null;
    }

    public void setQualifiers(List<RoleDocumentDelegationMemberQualifier> qualifiers) {
        this._persistence_set_qualifiers(qualifiers);
    }

    public int getNumberOfQualifiers() {
        return this._persistence_get_qualifiers() == null ? 0 : this._persistence_get_qualifiers().size();
    }

    public String getMemberId() {
        return this._persistence_get_memberId();
    }

    public void setMemberId(String memberId) {
        this._persistence_set_memberId(memberId);
    }

    public String getMemberName() {
        return this._persistence_get_memberName();
    }

    public void setMemberName(String memberName) {
        this._persistence_set_memberName(memberName);
    }

    public String getDelegationMemberId() {
        return this._persistence_get_delegationMemberId();
    }

    public void setDelegationMemberId(String delegationMemberId) {
        this._persistence_set_delegationMemberId(delegationMemberId);
    }

    public String getMemberTypeCode() {
        return this._persistence_get_memberTypeCode();
    }

    public void setMemberTypeCode(String memberTypeCode) {
        this._persistence_set_memberTypeCode(memberTypeCode);
    }

    public boolean isDelegationPrimary() {
        return DelegationType.PRIMARY.getCode().equals(this.getDelegationTypeCode());
    }

    public boolean isDelegationSecondary() {
        return DelegationType.SECONDARY.getCode().equals(this.getDelegationTypeCode());
    }

    public String getMemberNamespaceCode() {
        if (this.memberNamespaceCode == null) {
            this.populateDerivedValues();
        }
        return this.memberNamespaceCode;
    }

    public void setMemberNamespaceCode(String memberNamespaceCode) {
        this.memberNamespaceCode = memberNamespaceCode;
    }

    protected void populateDerivedValues() {
        if (!StringUtils.isEmpty((String)this.getMemberId())) {
            Role roleInfo;
            if (MemberType.GROUP.getCode().equals(this.getMemberTypeCode())) {
                Group groupInfo = KimApiServiceLocator.getGroupService().getGroup(this.getMemberId());
                if (groupInfo != null) {
                    this.setMemberNamespaceCode(groupInfo.getNamespaceCode());
                }
            } else if (MemberType.ROLE.getCode().equals(this.getMemberTypeCode()) && (roleInfo = KimApiServiceLocator.getRoleService().getRole(this.getMemberId())) != null) {
                this.setMemberNamespaceCode(roleInfo.getNamespaceCode());
            }
        }
    }

    public String getRoleMemberId() {
        return this._persistence_get_roleMemberId();
    }

    public void setRoleMemberId(String roleMemberId) {
        this._persistence_set_roleMemberId(roleMemberId);
    }

    public boolean isRole() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.ROLE.getCode());
    }

    public boolean isGroup() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.GROUP.getCode());
    }

    public boolean isPrincipal() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.PRINCIPAL.getCode());
    }

    public String getRoleMemberName() {
        return this.roleMemberName;
    }

    public void setRoleMemberName(String roleMemberName) {
        this.roleMemberName = roleMemberName;
    }

    public String getRoleMemberNamespaceCode() {
        return this.roleMemberNamespaceCode;
    }

    public void setRoleMemberNamespaceCode(String roleMemberNamespaceCode) {
        this.roleMemberNamespaceCode = roleMemberNamespaceCode;
    }

    public RoleBo getRoleBo() {
        return this.roleBo;
    }

    public void setRoleBo(RoleBo roleBo) {
        this.roleBo = roleBo;
        this.setAttributesHelper(new KimTypeAttributesHelper(KimTypeBo.to((KimTypeBo)roleBo.getKimRoleType())));
    }

    public KimTypeAttributesHelper getAttributesHelper() {
        return this.attributesHelper;
    }

    public void setAttributesHelper(KimTypeAttributesHelper attributesHelper) {
        this.attributesHelper = attributesHelper;
    }

    public String getRoleMemberMemberId() {
        return this.roleMemberMemberId;
    }

    public void setRoleMemberMemberId(String roleMemberMemberId) {
        this.roleMemberMemberId = roleMemberMemberId;
    }

    public String getRoleMemberMemberTypeCode() {
        return this.roleMemberMemberTypeCode;
    }

    public void setRoleMemberMemberTypeCode(String roleMemberMemberTypeCode) {
        this.roleMemberMemberTypeCode = roleMemberMemberTypeCode;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RoleDocumentDelegationMember();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "memberTypeCode") {
            return this.memberTypeCode;
        }
        if (string == "memberName") {
            return this.memberName;
        }
        if (string == "qualifiers") {
            return this.qualifiers;
        }
        if (string == "roleMemberId") {
            return this.roleMemberId;
        }
        if (string == "delegationMemberId") {
            return this.delegationMemberId;
        }
        if (string == "delegationId") {
            return this.delegationId;
        }
        if (string == "memberId") {
            return this.memberId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "memberTypeCode") {
            this.memberTypeCode = (String)object;
            return;
        }
        if (string == "memberName") {
            this.memberName = (String)object;
            return;
        }
        if (string == "qualifiers") {
            this.qualifiers = (List)object;
            return;
        }
        if (string == "roleMemberId") {
            this.roleMemberId = (String)object;
            return;
        }
        if (string == "delegationMemberId") {
            this.delegationMemberId = (String)object;
            return;
        }
        if (string == "delegationId") {
            this.delegationId = (String)object;
            return;
        }
        if (string == "memberId") {
            this.memberId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_memberTypeCode() {
        this._persistence_checkFetched("memberTypeCode");
        return this.memberTypeCode;
    }

    public void _persistence_set_memberTypeCode(String string) {
        this._persistence_checkFetchedForSet("memberTypeCode");
        this._persistence_propertyChange("memberTypeCode", this.memberTypeCode, string);
        this.memberTypeCode = string;
    }

    public String _persistence_get_memberName() {
        this._persistence_checkFetched("memberName");
        return this.memberName;
    }

    public void _persistence_set_memberName(String string) {
        this._persistence_checkFetchedForSet("memberName");
        this._persistence_propertyChange("memberName", this.memberName, string);
        this.memberName = string;
    }

    public List _persistence_get_qualifiers() {
        this._persistence_checkFetched("qualifiers");
        return this.qualifiers;
    }

    public void _persistence_set_qualifiers(List list) {
        this._persistence_checkFetchedForSet("qualifiers");
        this._persistence_propertyChange("qualifiers", this.qualifiers, list);
        this.qualifiers = list;
    }

    public String _persistence_get_roleMemberId() {
        this._persistence_checkFetched("roleMemberId");
        return this.roleMemberId;
    }

    public void _persistence_set_roleMemberId(String string) {
        this._persistence_checkFetchedForSet("roleMemberId");
        this._persistence_propertyChange("roleMemberId", this.roleMemberId, string);
        this.roleMemberId = string;
    }

    public String _persistence_get_delegationMemberId() {
        this._persistence_checkFetched("delegationMemberId");
        return this.delegationMemberId;
    }

    public void _persistence_set_delegationMemberId(String string) {
        this._persistence_checkFetchedForSet("delegationMemberId");
        this._persistence_propertyChange("delegationMemberId", this.delegationMemberId, string);
        this.delegationMemberId = string;
    }

    public String _persistence_get_delegationId() {
        this._persistence_checkFetched("delegationId");
        return this.delegationId;
    }

    public void _persistence_set_delegationId(String string) {
        this._persistence_checkFetchedForSet("delegationId");
        this._persistence_propertyChange("delegationId", this.delegationId, string);
        this.delegationId = string;
    }

    public String _persistence_get_memberId() {
        this._persistence_checkFetched("memberId");
        return this.memberId;
    }

    public void _persistence_set_memberId(String string) {
        this._persistence_checkFetchedForSet("memberId");
        this._persistence_propertyChange("memberId", this.memberId, string);
        this.memberId = string;
    }
}

