/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.responsibility.ResponsibilityContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.ReviewResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.UberResponsibilityBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.lookup.RoleMemberLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.util.UrlFactory;

public class ResponsibilityLookupableHelperServiceImpl
extends RoleMemberLookupableHelperServiceImpl {
    private static final Logger LOG = Logger.getLogger(ResponsibilityLookupableHelperServiceImpl.class);
    private static final long serialVersionUID = -2882500971924192124L;
    private static LookupService lookupService;
    private static boolean reviewResponsibilityDocumentTypeNameLoaded;
    private static String reviewResponsibilityDocumentTypeName;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (((UberResponsibilityBo)businessObject).getTemplate() != null && ((UberResponsibilityBo)businessObject).getTemplate().getName().equals("Review")) {
            ReviewResponsibilityBo reviewResp = new ReviewResponsibilityBo((ResponsibilityContract)businessObject);
            if (this.allowsMaintenanceEditAction(businessObject = reviewResp)) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
            }
            if (this.allowsMaintenanceNewOrCopyAction()) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
            }
        }
        return htmlDataList;
    }

    protected String getActionUrlHref(BusinessObject businessObject, String methodToCall, List pkNames) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("businessObjectClassName", businessObject.getClass().getName());
        parameters.put("overrideKeys", "id");
        parameters.put("cpKys", "id");
        if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
            parameters.put("returnLocation", this.getReturnLocation());
        }
        parameters.putAll((Map<?, ?>)this.getParametersFromPrimaryKey(businessObject, pkNames));
        return UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
    }

    protected String getMaintenanceDocumentTypeName() {
        if (!reviewResponsibilityDocumentTypeNameLoaded) {
            reviewResponsibilityDocumentTypeName = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(ReviewResponsibilityBo.class);
            reviewResponsibilityDocumentTypeNameLoaded = true;
        }
        return reviewResponsibilityDocumentTypeName;
    }

    @Override
    protected List<? extends BusinessObject> getMemberSearchResults(Map<String, String> searchCriteria, boolean unbounded) {
        Map<String, String> responsibilitySearchCriteria = this.buildSearchCriteria(searchCriteria);
        Map<String, String> roleSearchCriteria = this.buildRoleSearchCriteria(searchCriteria);
        boolean responsibilityCriteriaEmpty = responsibilitySearchCriteria == null || responsibilitySearchCriteria.isEmpty();
        boolean roleCriteriaEmpty = roleSearchCriteria == null || roleSearchCriteria.isEmpty();
        Object responsibilitySearchResultsCopy = new CollectionIncomplete(new ArrayList(), new Long(0L));
        if (!responsibilityCriteriaEmpty && !roleCriteriaEmpty) {
            responsibilitySearchResultsCopy = this.getCombinedSearchResults(responsibilitySearchCriteria, roleSearchCriteria, unbounded);
        } else if (responsibilityCriteriaEmpty && !roleCriteriaEmpty) {
            responsibilitySearchResultsCopy = this.getResponsibilitiesWithRoleSearchCriteria(roleSearchCriteria, unbounded);
        } else if (!responsibilityCriteriaEmpty && roleCriteriaEmpty) {
            responsibilitySearchResultsCopy = this.getResponsibilitiesWithResponsibilitySearchCriteria(responsibilitySearchCriteria, unbounded);
        } else if (responsibilityCriteriaEmpty && roleCriteriaEmpty) {
            return this.getAllResponsibilities(unbounded);
        }
        return responsibilitySearchResultsCopy;
    }

    private List<UberResponsibilityBo> getAllResponsibilities(boolean unbounded) {
        List<UberResponsibilityBo> responsibilities = this.searchResponsibilities(new HashMap<String, String>(), unbounded);
        for (UberResponsibilityBo responsibility : responsibilities) {
            this.populateAssignedToRoles(responsibility);
        }
        return responsibilities;
    }

    private List<UberResponsibilityBo> getCombinedSearchResults(Map<String, String> responsibilitySearchCriteria, Map<String, String> roleSearchCriteria, boolean unbounded) {
        List<UberResponsibilityBo> responsibilitySearchResults = this.searchResponsibilities(responsibilitySearchCriteria, unbounded);
        List<RoleBo> roleSearchResults = this.searchRoles(roleSearchCriteria, unbounded);
        List<UberResponsibilityBo> responsibilitiesForRoleSearchResults = this.getResponsibilitiesForRoleSearchResults(roleSearchResults, unbounded);
        CollectionIncomplete matchedResponsibilities = new CollectionIncomplete(new ArrayList(), this.getActualSizeIfTruncated(responsibilitiesForRoleSearchResults));
        if (responsibilitySearchResults != null && !responsibilitySearchResults.isEmpty() && responsibilitiesForRoleSearchResults != null && !responsibilitiesForRoleSearchResults.isEmpty()) {
            for (UberResponsibilityBo responsibility : responsibilitySearchResults) {
                for (UberResponsibilityBo responsibilityFromRoleSearch : responsibilitiesForRoleSearchResults) {
                    if (!responsibilityFromRoleSearch.getId().equals(responsibility.getId())) continue;
                    matchedResponsibilities.add(responsibilityFromRoleSearch);
                }
            }
        }
        return matchedResponsibilities;
    }

    private List<UberResponsibilityBo> searchResponsibilities(Map<String, String> responsibilitySearchCriteria, boolean unbounded) {
        return this.getResponsibilitiesSearchResultsCopy((List)this.getLookupService().findCollectionBySearchHelper(ResponsibilityBo.class, responsibilitySearchCriteria, unbounded));
    }

    private List<UberResponsibilityBo> getResponsibilitiesWithRoleSearchCriteria(Map<String, String> roleSearchCriteria, boolean unbounded) {
        List<RoleBo> roleSearchResults = this.searchRoles(roleSearchCriteria, unbounded);
        return this.getResponsibilitiesForRoleSearchResults(roleSearchResults, unbounded);
    }

    private List<UberResponsibilityBo> getResponsibilitiesForRoleSearchResults(List<RoleBo> roleSearchResults, boolean unbounded) {
        Long actualSizeIfTruncated = this.getActualSizeIfTruncated(roleSearchResults);
        List<UberResponsibilityBo> responsibilities = new ArrayList<UberResponsibilityBo>();
        ArrayList<String> collectedResponsibilityIds = new ArrayList<String>();
        for (RoleBo roleImpl : roleSearchResults) {
            HashMap<String, String> responsibilityCriteria = new HashMap<String, String>();
            responsibilityCriteria.put("roleResponsibilities.roleId", roleImpl.getId());
            List<UberResponsibilityBo> tempResponsibilities = this.searchResponsibilities(responsibilityCriteria, unbounded);
            actualSizeIfTruncated = actualSizeIfTruncated + this.getActualSizeIfTruncated(tempResponsibilities);
            for (UberResponsibilityBo responsibility : tempResponsibilities) {
                if (!collectedResponsibilityIds.contains(responsibility.getId())) {
                    this.populateAssignedToRoles(responsibility);
                    collectedResponsibilityIds.add(responsibility.getId());
                    responsibilities.add(responsibility);
                }
                List parentRoleIds = KimApiServiceLocator.getRoleService().getMemberParentRoleIds(MemberType.ROLE.getCode(), roleImpl.getId());
                for (String parentRoleId : parentRoleIds) {
                    HashMap<String, String> roleSearchCriteria = new HashMap<String, String>();
                    roleSearchCriteria.put("id", parentRoleId);
                    responsibilities = this.mergeResponsibilityLists(responsibilities, this.getResponsibilitiesWithRoleSearchCriteria(roleSearchCriteria, unbounded));
                }
            }
        }
        return new CollectionIncomplete(responsibilities, actualSizeIfTruncated);
    }

    private void populateAssignedToRoles(UberResponsibilityBo responsibility) {
        if (responsibility.getAssignedToRoles().isEmpty()) {
            for (RoleResponsibilityBo roleResponsibility : responsibility.getRoleResponsibilities()) {
                responsibility.getAssignedToRoles().add(KradDataServiceLocator.getDataObjectService().find(RoleBo.class, (Object)roleResponsibility.getRoleId()));
            }
        }
    }

    private List<UberResponsibilityBo> getResponsibilitiesWithResponsibilitySearchCriteria(Map<String, String> responsibilitySearchCriteria, boolean unbounded) {
        String detailCriteriaStr = responsibilitySearchCriteria.remove("detailCriteria");
        Map<String, String> detailCriteria = this.parseDetailCriteria(detailCriteriaStr);
        List<UberResponsibilityBo> responsibilities = this.searchResponsibilities(responsibilitySearchCriteria, unbounded);
        CollectionIncomplete filteredResponsibilities = new CollectionIncomplete(new ArrayList(), this.getActualSizeIfTruncated(responsibilities));
        for (UberResponsibilityBo responsibility : responsibilities) {
            if (detailCriteria.isEmpty()) {
                filteredResponsibilities.add(responsibility);
                this.populateAssignedToRoles(responsibility);
                continue;
            }
            if (!this.isMapSubset(new HashMap<String, String>(responsibility.getAttributes()), detailCriteria)) continue;
            filteredResponsibilities.add(responsibility);
            this.populateAssignedToRoles(responsibility);
        }
        return filteredResponsibilities;
    }

    private List<UberResponsibilityBo> getResponsibilitiesSearchResultsCopy(List<ResponsibilityBo> responsibilitySearchResults) {
        CollectionIncomplete responsibilitySearchResultsCopy = new CollectionIncomplete(new ArrayList(), this.getActualSizeIfTruncated(responsibilitySearchResults));
        for (ResponsibilityBo responsibilityImpl : responsibilitySearchResults) {
            UberResponsibilityBo responsibilityCopy = new UberResponsibilityBo();
            try {
                PropertyUtils.copyProperties((Object)responsibilityCopy, (Object)responsibilityImpl);
                responsibilityCopy.setTemplate(responsibilityImpl.getTemplate());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("unable to copy properties");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("unable to copy properties");
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("unable to copy properties");
            }
            responsibilitySearchResultsCopy.add(responsibilityCopy);
        }
        return responsibilitySearchResultsCopy;
    }

    public LookupService getLookupService() {
        if (lookupService == null) {
            lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return lookupService;
    }

    private List<UberResponsibilityBo> mergeResponsibilityLists(List<UberResponsibilityBo> perm1, List<UberResponsibilityBo> perm2) {
        ArrayList<UberResponsibilityBo> returnList = new ArrayList<UberResponsibilityBo>(perm1);
        ArrayList<String> responsibilityIds = new ArrayList<String>(perm1.size());
        for (UberResponsibilityBo perm : returnList) {
            responsibilityIds.add(perm.getId());
        }
        for (int i = 0; i < perm2.size(); ++i) {
            if (responsibilityIds.contains(perm2.get(i).getId())) continue;
            returnList.add(perm2.get(i));
        }
        return returnList;
    }

    static {
        reviewResponsibilityDocumentTypeNameLoaded = false;
        reviewResponsibilityDocumentTypeName = null;
    }
}

