/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityQueryResults;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.impl.type.KimTypeLookupableHelperServiceImpl;
import org.kuali.rice.kim.lookup.KimLookupableHelperServiceImpl;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class RoleLookupableHelperServiceImpl
extends KimLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    protected static final String GROUP_CRITERIA = "group";
    protected static final String RESPONSIBILITY_CRITERIA = "resp";
    protected static final String PERMISSION_CRITERIA = "perm";
    protected static final String ROLE_MEMBER_ATTRIBUTE_CRITERIA = "attr";
    protected static final String OTHER_CRITERIA = "lookupNames";
    protected static final String LOOKUP_PARM_PERMISSION_TEMPLATE_NAMESPACE = "permTmplNamespaceCode";
    protected static final String LOOKUP_PARM_PERMISSION_TEMPLATE_NAME = "permTmplName";
    protected static final String LOOKUP_PARM_PERMISSION_NAMESPACE = "permNamespaceCode";
    protected static final String LOOKUP_PARM_PERMISSION_NAME = "permName";
    protected static final String LOOKUP_PARM_RESP_TEMPLATE_NAMESPACE = "respTmplNamespaceCode";
    protected static final String LOOKUP_PARM_RESP_TEMPLATE_NAME = "respTmplName";
    protected static final String LOOKUP_PARM_RESP_NAMESPACE = "respNamespaceCode";
    protected static final String LOOKUP_PARM_RESP_NAME = "respName";
    private List<Row> roleRows = new ArrayList<Row>();
    private List<Row> attrRows = new ArrayList<Row>();
    private String typeId;
    private List<KimAttributeField> attrDefinitions;
    private static final String ROLE_ID_URL_KEY = "&id=";
    protected static List<String> PERM_FIELD_NAMES = new ArrayList<String>(4);
    protected static List<String> RESP_FIELD_NAMES;

    public boolean allowsMaintenanceNewOrCopyAction() {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "IdentityManagementRoleDocument");
        permissionDetails.put("maintenanceAction", "New");
        return !KimApiServiceLocator.getPermissionService().isPermissionDefinedByTemplate("KR-NS", "Create / Maintain Record(s)", permissionDetails) || KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPrincipalId(), "KR-NS", "Create / Maintain Record(s)", permissionDetails, new HashMap());
    }

    protected boolean allowsMaintenanceEditAction(BusinessObject businessObject) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>(2);
        permissionDetails.put("documentTypeName", "IdentityManagementRoleDocument");
        permissionDetails.put("maintenanceAction", "Edit");
        return !KimApiServiceLocator.getPermissionService().isPermissionDefinedByTemplate("KR-NS", "Create / Maintain Record(s)", permissionDetails) || KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPrincipalId(), "KR-NS", "Create / Maintain Record(s)", permissionDetails, new HashMap());
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        RoleBo roleBo = (RoleBo)bo;
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        if (this.allowsNewOrCopyAction("IdentityManagementRoleDocument")) {
            anchorHtmlDataList.add(this.getEditRoleUrl(roleBo));
        }
        return anchorHtmlDataList;
    }

    protected HtmlData getEditRoleUrl(RoleBo roleBo) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "IdentityManagementRoleDocument");
        parameters.put("roleId", roleBo.getId());
        if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
            parameters.put("returnLocation", this.getReturnLocation());
        }
        String href = UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + "identityManagementRoleDocument.do"), (Properties)parameters);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "docHandler", "edit");
        return anchorHtmlData;
    }

    protected HtmlData getReturnAnchorHtmlData(BusinessObject businessObject, Properties parameters, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        RoleBo roleBo = (RoleBo)businessObject;
        HtmlData anchorHtmlData = super.getReturnAnchorHtmlData(businessObject, parameters, lookupForm, returnKeys, businessObjectRestrictions);
        KualiForm myForm = (KualiForm)GlobalVariables.getUserSession().retrieveObject(this.getDocFormKey());
        if ((myForm == null || !(myForm instanceof IdentityManagementRoleDocumentForm)) && KimTypeLookupableHelperServiceImpl.hasDerivedRoleTypeService(KimTypeBo.to((KimTypeBo)roleBo.getKimRoleType()))) {
            ((HtmlData.AnchorHtmlData)anchorHtmlData).setHref("");
        }
        return anchorHtmlData;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.remove("backLocation");
        fieldValues.remove("docFormKey");
        fieldValues.remove("docNum");
        QueryByCriteria criteria = this.getRoleCriteria(fieldValues);
        if (criteria == null) {
            return Collections.emptyList();
        }
        List results = KimApiServiceLocator.getRoleService().findRoles(criteria).getResults();
        ArrayList<RoleBo> roles = new ArrayList<RoleBo>(results.size());
        for (Role role : results) {
            roles.add(RoleBo.from((Role)role));
        }
        return roles;
    }

    private List<KeyValue> getRoleTypeOptions() {
        ArrayList<KeyValue> options = new ArrayList<KeyValue>();
        options.add((KeyValue)new ConcreteKeyValue("", ""));
        Collection kimGroupTypes = KimApiServiceLocator.getKimTypeInfoService().findAllKimTypes();
        for (KimType kimType : kimGroupTypes) {
            if (!KimTypeLookupableHelperServiceImpl.hasRoleTypeService(kimType)) continue;
            String value = kimType.getNamespaceCode().trim() + ":" + kimType.getName().trim();
            options.add((KeyValue)new ConcreteKeyValue(kimType.getId(), value));
        }
        Collections.sort(options, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue k1, KeyValue k2) {
                return k1.getValue().compareTo(k2.getValue());
            }
        });
        return options;
    }

    public List<Row> getRoleRows() {
        return this.roleRows;
    }

    public void setRoleRows(List<Row> roleRows) {
        this.roleRows = roleRows;
    }

    public List<KimAttributeField> getAttrDefinitions() {
        return this.attrDefinitions;
    }

    public void setAttrDefinitions(List<KimAttributeField> attrDefinitions) {
        this.attrDefinitions = attrDefinitions;
    }

    public List<Row> getAttrRows() {
        return this.attrRows;
    }

    public void setAttrRows(List<Row> attrRows) {
        this.attrRows = attrRows;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public List<Row> getRows() {
        new ArrayList();
        if (this.getRoleRows().isEmpty()) {
            List rows = super.getRows();
            ArrayList<Row> returnRows = new ArrayList<Row>();
            for (Row row : rows) {
                for (int i = row.getFields().size() - 1; i >= 0; --i) {
                    Field field = (Field)row.getFields().get(i);
                    if (!field.getPropertyName().equals("kimTypeId")) continue;
                    Field typeField = new Field();
                    typeField.setFieldLabel("Type");
                    typeField.setPropertyName("kimTypeId");
                    typeField.setFieldValidValues(this.getRoleTypeOptions());
                    typeField.setFieldType("dropdown");
                    typeField.setMaxLength(100);
                    typeField.setSize(40);
                    row.getFields().set(i, typeField);
                }
                returnRows.add(row);
            }
            this.setRoleRows(returnRows);
        }
        if (this.getAttrRows().isEmpty()) {
            return this.getRoleRows();
        }
        ArrayList<Row> fullRows = new ArrayList<Row>();
        fullRows.addAll(this.getRoleRows());
        return fullRows;
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        List searchResults;
        HashMap<String, String> nonBlankFieldValues = new HashMap<String, String>();
        boolean includeAttr = false;
        for (String fieldName : fieldValues.keySet()) {
            if (!StringUtils.isNotBlank((String)fieldValues.get(fieldName))) continue;
            nonBlankFieldValues.put(fieldName, fieldValues.get(fieldName));
            if (!fieldName.contains(".")) continue;
            includeAttr = true;
        }
        if (includeAttr) {
            ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getBusinessObjectClass());
            BusinessObjectEntry ddEntry = eboModuleService.getExternalizableBusinessObjectDictionaryEntry(this.getBusinessObjectClass());
            HashMap filteredFieldValues = new HashMap();
            for (String fieldName : nonBlankFieldValues.keySet()) {
                if (!ddEntry.getAttributeNames().contains(fieldName) && !fieldName.contains(".")) continue;
                filteredFieldValues.put(fieldName, nonBlankFieldValues.get(fieldName));
            }
            searchResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(this.getBusinessObjectClass(), filteredFieldValues, unbounded);
        } else {
            searchResults = super.getSearchResultsHelper(fieldValues, unbounded);
        }
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    public static String getCustomRoleInquiryHref(String href) {
        return RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref("", href);
    }

    static String getCustomRoleInquiryHref(String backLocation, String href) {
        Properties parameters = new Properties();
        String hrefPart = "";
        String docTypeAction = "";
        docTypeAction = StringUtils.isBlank((String)backLocation) || backLocation.contains("identityManagementRoleDocument.do") || !backLocation.contains("identityManagementGroupDocument.do") ? "identityManagementRoleInquiry.do" : "identityManagementGroupDocument.do";
        if (StringUtils.isNotBlank((String)href) && href.contains(ROLE_ID_URL_KEY)) {
            int idx1 = href.indexOf(ROLE_ID_URL_KEY);
            int idx2 = href.indexOf("&", idx1 + 1);
            if (idx2 < 0) {
                idx2 = href.length();
            }
            parameters.put("methodToCall", "inquiry");
            hrefPart = href.substring(idx1, idx2);
        }
        return UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + docTypeAction), (Properties)parameters) + hrefPart;
    }

    public QueryByCriteria getRoleCriteria(Map<String, String> fieldValues) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        Map<String, Map<String, String>> criteriaMap = this.setupCritMaps(fieldValues);
        Map<String, String> lookupNames = criteriaMap.get(OTHER_CRITERIA);
        for (Map.Entry<String, String> entry : lookupNames.entrySet()) {
            String propertyName = entry.getKey();
            String lookupValue = entry.getValue();
            if (!StringUtils.isNotBlank((String)lookupValue)) continue;
            if (!propertyName.equals("principalName")) {
                if (propertyName.equals("active")) {
                    criteria.add(PredicateFactory.equal((String)propertyName, (Object)Truth.strToBooleanIgnoreCase((String)lookupValue)));
                    continue;
                }
                criteria.add(PredicateFactory.likeIgnoreCase((String)propertyName, (CharSequence)lookupValue));
                continue;
            }
            Collection<String> roleIds = this.getRoleIdsForPrincipalName(lookupValue);
            if (CollectionUtils.isEmpty(roleIds)) {
                return null;
            }
            criteria.add(PredicateFactory.in((String)"id", roleIds));
        }
        if (!criteriaMap.get(PERMISSION_CRITERIA).isEmpty()) {
            Collection<String> permissionRoleIds = this.getPermissionRoleIds(criteriaMap.get(PERMISSION_CRITERIA));
            if (CollectionUtils.isEmpty(permissionRoleIds)) {
                return null;
            }
            criteria.add(PredicateFactory.in((String)"id", permissionRoleIds));
        }
        if (!criteriaMap.get(RESPONSIBILITY_CRITERIA).isEmpty()) {
            Collection<String> responsibilityRoleIds = this.getResponsibilityRoleIds(criteriaMap.get(RESPONSIBILITY_CRITERIA));
            if (CollectionUtils.isEmpty(responsibilityRoleIds)) {
                return null;
            }
            criteria.add(PredicateFactory.in((String)"id", responsibilityRoleIds));
        }
        if (!criteriaMap.get(GROUP_CRITERIA).isEmpty()) {
            Collection<String> groupCriteriaRoleIds = this.getGroupCriteriaRoleIds(criteriaMap.get(GROUP_CRITERIA));
            if (CollectionUtils.isEmpty(groupCriteriaRoleIds)) {
                return null;
            }
            criteria.add(PredicateFactory.in((String)"id", groupCriteriaRoleIds));
        }
        return QueryByCriteria.Builder.fromPredicates(criteria);
    }

    protected Collection<String> getRoleIdsForPrincipalName(String principalName) {
        principalName = principalName.replace('*', '%');
        QueryByCriteria principalCriteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.likeIgnoreCase((String)"principalName", (CharSequence)principalName), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)});
        List principals = KimApiServiceLocator.getIdentityService().findPrincipals(principalCriteria).getResults();
        if (principals.isEmpty()) {
            return Collections.singletonList("NOTFOUND");
        }
        HashSet<String> roleIds = new HashSet<String>();
        ArrayList<String> principalIds = new ArrayList<String>(principals.size());
        for (Object principal : principals) {
            principalIds.add(principal.getPrincipalId());
        }
        HashSet<String> groupIds = new HashSet<String>();
        for (String principalId : principalIds) {
            List principalGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
            if (principalGroupIds.isEmpty()) {
                groupIds.add("NOTFOUND");
                continue;
            }
            groupIds.addAll(principalGroupIds);
        }
        QueryByCriteria roleMemberCriteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeCode", (Object)MemberType.PRINCIPAL.getCode()), PredicateFactory.in((String)"memberId", principalIds)}), PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeCode", (Object)MemberType.GROUP.getCode()), PredicateFactory.in((String)"memberId", groupIds)})})});
        List roleMembers = KimApiServiceLocator.getRoleService().findRoleMembers(roleMemberCriteria).getResults();
        DateTime now = new DateTime(CoreApiServiceLocator.getDateTimeService().getCurrentDate().getTime());
        for (RoleMember roleMbr : roleMembers) {
            if (!roleMbr.isActive(now)) continue;
            roleIds.add(roleMbr.getRoleId());
        }
        return roleIds;
    }

    private Map<String, Map<String, String>> setupCritMaps(Map<String, String> fieldValues) {
        HashMap<String, Map<String, String>> critMapMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> permFieldMap = new HashMap<String, String>();
        HashMap<String, String> respFieldMap = new HashMap<String, String>();
        HashMap<String, String> groupFieldMap = new HashMap<String, String>();
        HashMap<String, String> lookupNamesMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            String nameValue = entry.getValue();
            String propertyName = entry.getKey();
            if (!StringUtils.isNotBlank((String)nameValue)) continue;
            if (PERM_FIELD_NAMES.contains(propertyName)) {
                permFieldMap.put(propertyName, nameValue);
                continue;
            }
            if (RESP_FIELD_NAMES.contains(propertyName)) {
                respFieldMap.put(propertyName, nameValue);
                continue;
            }
            if (propertyName.startsWith("groupName")) {
                groupFieldMap.put(propertyName, nameValue);
                continue;
            }
            lookupNamesMap.put(propertyName, nameValue);
        }
        critMapMap.put(PERMISSION_CRITERIA, permFieldMap);
        critMapMap.put(RESPONSIBILITY_CRITERIA, respFieldMap);
        critMapMap.put(GROUP_CRITERIA, groupFieldMap);
        critMapMap.put(OTHER_CRITERIA, lookupNamesMap);
        return critMapMap;
    }

    protected Collection<String> getPermissionRoleIds(Map<String, String> permCrit) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        for (Map.Entry<String, String> entry : permCrit.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            String propertyName = entry.getKey();
            String lookupValue = entry.getValue().replace('*', '%');
            if (propertyName.equals(LOOKUP_PARM_PERMISSION_NAME)) {
                criteria.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)lookupValue));
                continue;
            }
            if (propertyName.equals(LOOKUP_PARM_PERMISSION_NAMESPACE)) {
                criteria.add(PredicateFactory.like((String)"namespaceCode", (CharSequence)lookupValue));
                continue;
            }
            if (propertyName.equals(LOOKUP_PARM_PERMISSION_TEMPLATE_NAME)) {
                criteria.add(PredicateFactory.likeIgnoreCase((String)"template.name", (CharSequence)lookupValue));
                continue;
            }
            if (!propertyName.equals(LOOKUP_PARM_PERMISSION_TEMPLATE_NAMESPACE)) continue;
            criteria.add(PredicateFactory.like((String)"template.namespaceCode", (CharSequence)lookupValue));
        }
        if (criteria.isEmpty()) {
            return Collections.singletonList("NOTFOUND");
        }
        List permissions = KimApiServiceLocator.getPermissionService().findPermissions(QueryByCriteria.Builder.fromPredicates(criteria)).getResults();
        HashSet<String> roleIds = new HashSet<String>();
        for (Permission permission : permissions) {
            roleIds.addAll(KimApiServiceLocator.getPermissionService().getRoleIdsForPermission(permission.getNamespaceCode(), permission.getName()));
        }
        return roleIds;
    }

    protected Collection<String> getResponsibilityRoleIds(Map<String, String> respCrit) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        for (Map.Entry<String, String> entry : respCrit.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            String propertyName = entry.getKey();
            String lookupValue = entry.getValue().replace('*', '%');
            if (propertyName.equals(LOOKUP_PARM_RESP_NAME)) {
                criteria.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)lookupValue));
                continue;
            }
            if (propertyName.equals(LOOKUP_PARM_RESP_NAMESPACE)) {
                criteria.add(PredicateFactory.like((String)"namespaceCode", (CharSequence)lookupValue));
                continue;
            }
            if (propertyName.equals(LOOKUP_PARM_RESP_TEMPLATE_NAME)) {
                criteria.add(PredicateFactory.likeIgnoreCase((String)"template.name", (CharSequence)lookupValue));
                continue;
            }
            if (!propertyName.equals(LOOKUP_PARM_RESP_TEMPLATE_NAMESPACE)) continue;
            criteria.add(PredicateFactory.like((String)"template.namespaceCode", (CharSequence)lookupValue));
        }
        if (criteria.isEmpty()) {
            return Collections.singletonList("NOTFOUND");
        }
        ResponsibilityQueryResults results = KimApiServiceLocator.getResponsibilityService().findResponsibilities(QueryByCriteria.Builder.fromPredicates(criteria));
        List responsibilities = results.getResults();
        HashSet<String> roleIds = new HashSet<String>();
        for (Responsibility responsibility : responsibilities) {
            roleIds.addAll(KimApiServiceLocator.getResponsibilityService().getRoleIdsForResponsibility(responsibility.getId()));
        }
        return roleIds;
    }

    protected Collection<String> getGroupCriteriaRoleIds(Map<String, String> groupCrit) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        for (Map.Entry<String, String> entry : groupCrit.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            String propertyName = entry.getKey();
            String lookupValue = entry.getValue().replace('*', '%');
            if (propertyName.equals("groupName")) {
                criteria.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)lookupValue));
                continue;
            }
            criteria.add(PredicateFactory.like((String)"namespaceCode", (CharSequence)lookupValue));
        }
        if (criteria.isEmpty()) {
            return Collections.singletonList("NOTFOUND");
        }
        List groupIds = KimApiServiceLocator.getGroupService().findGroupIds(QueryByCriteria.Builder.fromPredicates(criteria));
        if (groupIds.isEmpty()) {
            return Collections.singletonList("NOTFOUND");
        }
        QueryByCriteria roleMemberCriteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeCode", (Object)MemberType.GROUP.getCode()), PredicateFactory.in((String)"memberId", (Collection)groupIds)});
        List roleMembers = KimApiServiceLocator.getRoleService().findRoleMembers(roleMemberCriteria).getResults();
        HashSet<String> roleIds = new HashSet<String>();
        DateTime now = new DateTime(CoreApiServiceLocator.getDateTimeService().getCurrentDate().getTime());
        for (RoleMember roleMbr : roleMembers) {
            if (!roleMbr.isActive(now)) continue;
            roleIds.add(roleMbr.getRoleId());
        }
        return roleIds;
    }

    protected String getMaintenanceDocumentTypeName() {
        return "IdentityManagementRoleDocument";
    }

    static {
        PERM_FIELD_NAMES.add(LOOKUP_PARM_PERMISSION_NAME);
        PERM_FIELD_NAMES.add(LOOKUP_PARM_PERMISSION_NAMESPACE);
        PERM_FIELD_NAMES.add(LOOKUP_PARM_PERMISSION_TEMPLATE_NAME);
        PERM_FIELD_NAMES.add(LOOKUP_PARM_PERMISSION_TEMPLATE_NAMESPACE);
        RESP_FIELD_NAMES = new ArrayList<String>(4);
        RESP_FIELD_NAMES.add(LOOKUP_PARM_RESP_NAME);
        RESP_FIELD_NAMES.add(LOOKUP_PARM_RESP_NAMESPACE);
        RESP_FIELD_NAMES.add(LOOKUP_PARM_RESP_TEMPLATE_NAME);
        RESP_FIELD_NAMES.add(LOOKUP_PARM_RESP_TEMPLATE_NAMESPACE);
    }
}

