/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.impl.identity.EntityDefaultInfoCacheBo;
import org.kuali.rice.kim.impl.identity.IdentityArchiveService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class IdentityArchiveServiceImpl
implements IdentityArchiveService,
InitializingBean,
DisposableBean {
    private static final Logger LOG = Logger.getLogger(IdentityArchiveServiceImpl.class);
    protected DataObjectService dataObjectService;
    protected ConfigurationService kualiConfigurationService;
    protected PlatformTransactionManager transactionManager;
    protected static final String EXEC_INTERVAL_SECS = "kim.identityArchiveServiceImpl.executionIntervalSeconds";
    protected static final String MAX_WRITE_QUEUE_SIZE = "kim.identityArchiveServiceImpl.maxWriteQueueSize";
    protected static final int EXECUTION_INTERVAL_SECONDS_DEFAULT = 600;
    protected static final int MAX_WRITE_QUEUE_SIZE_DEFAULT = 300;
    protected final WriteQueue writeQueue = new WriteQueue();
    protected final EntityArchiveWriter writer = new EntityArchiveWriter();
    protected final Runnable maxQueueSizeExceededWriter = new CallableAdapter(new PreLogCallableWrapper(this.writer, Level.DEBUG, "max size exceeded, flushing write queue"));
    protected final Runnable scheduledWriter = new CallableAdapter(new PreLogCallableWrapper(this.writer, Level.DEBUG, "scheduled write out, flushing write queue"));
    protected final Runnable shutdownWriter = new CallableAdapter(new PreLogCallableWrapper(this.writer, Level.DEBUG, "rice is shutting down, flushing write queue"));

    protected int getExecutionIntervalSeconds() {
        String prop = this.kualiConfigurationService.getPropertyValueAsString(EXEC_INTERVAL_SECS);
        try {
            return Integer.valueOf(prop);
        }
        catch (NumberFormatException e) {
            return 600;
        }
    }

    protected int getMaxWriteQueueSize() {
        String prop = this.kualiConfigurationService.getPropertyValueAsString(MAX_WRITE_QUEUE_SIZE);
        try {
            return Integer.valueOf(prop);
        }
        catch (NumberFormatException e) {
            return 300;
        }
    }

    public EntityDefault getEntityDefaultFromArchive(String entityId) {
        if (StringUtils.isBlank((String)entityId)) {
            throw new IllegalArgumentException("entityId is blank");
        }
        List results = this.dataObjectService.findMatching(EntityDefaultInfoCacheBo.class, QueryByCriteria.Builder.forAttribute((String)"entityId", (Object)entityId).build()).getResults();
        EntityDefaultInfoCacheBo cachedValue = null;
        if (!results.isEmpty()) {
            cachedValue = (EntityDefaultInfoCacheBo)results.get(0);
        }
        return cachedValue == null ? null : cachedValue.convertCacheToEntityDefaultInfo();
    }

    public EntityDefault getEntityDefaultFromArchiveByPrincipalId(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("principalId is blank");
        }
        EntityDefaultInfoCacheBo cachedValue = (EntityDefaultInfoCacheBo)this.dataObjectService.find(EntityDefaultInfoCacheBo.class, (Object)principalId);
        return cachedValue == null ? null : cachedValue.convertCacheToEntityDefaultInfo();
    }

    public EntityDefault getEntityDefaultFromArchiveByPrincipalName(String principalName) {
        if (StringUtils.isBlank((String)principalName)) {
            throw new IllegalArgumentException("principalName is blank");
        }
        List entities = this.dataObjectService.findMatching(EntityDefaultInfoCacheBo.class, QueryByCriteria.Builder.forAttribute((String)"principalName", (Object)principalName).build()).getResults();
        return entities.isEmpty() ? null : ((EntityDefaultInfoCacheBo)entities.get(0)).convertCacheToEntityDefaultInfo();
    }

    public EntityDefault getEntityDefaultFromArchiveByEmployeeId(String employeeId) {
        if (StringUtils.isBlank((String)employeeId)) {
            throw new IllegalArgumentException("employeeId is blank");
        }
        List entities = this.dataObjectService.findMatching(EntityDefaultInfoCacheBo.class, QueryByCriteria.Builder.forAttribute((String)"employeeId", (Object)employeeId).build()).getResults();
        return entities.isEmpty() ? null : ((EntityDefaultInfoCacheBo)entities.get(0)).convertCacheToEntityDefaultInfo();
    }

    public void saveEntityDefaultToArchive(EntityDefault entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is blank");
        }
        if (this.getMaxWriteQueueSize() <= this.writeQueue.offerAndGetSize(entity) && this.writer.requestSubmit()) {
            KSBServiceLocator.getThreadPool().execute(this.maxQueueSizeExceededWriter);
        }
    }

    public void flushToArchive() {
        this.writer.call();
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setTransactionManager(PlatformTransactionManager txMgr) {
        this.transactionManager = txMgr;
    }

    public void afterPropertiesSet() throws Exception {
        LOG.info((Object)"scheduling writer...");
        KSBServiceLocator.getScheduledPool().scheduleAtFixedRate(this.scheduledWriter, (long)this.getExecutionIntervalSeconds(), (long)this.getExecutionIntervalSeconds(), TimeUnit.SECONDS);
    }

    public void destroy() throws Exception {
        this.shutdownWriter.run();
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected static class CallableAdapter
    implements Runnable {
        private final Callable callable;

        public CallableAdapter(Callable callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                this.callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class PreLogCallableWrapper<A>
    implements Callable<A> {
        protected final Callable inner;
        protected final Level level;
        protected final String message;

        public PreLogCallableWrapper(Callable inner, Level level, String message) {
            this.inner = inner;
            this.level = level;
            this.message = message;
        }

        @Override
        public A call() throws Exception {
            LOG.log((Priority)this.level, (Object)this.message);
            return (A)this.inner.call();
        }
    }

    protected static class WriteQueue {
        AtomicInteger writeQueueSize = new AtomicInteger(0);
        ConcurrentLinkedQueue<EntityDefault> queue = new ConcurrentLinkedQueue();

        protected WriteQueue() {
        }

        public int offerAndGetSize(EntityDefault entity) {
            this.queue.add(entity);
            return this.writeQueueSize.incrementAndGet();
        }

        protected EntityDefault poll() {
            EntityDefault result = this.queue.poll();
            if (result != null) {
                this.writeQueueSize.decrementAndGet();
            }
            return result;
        }
    }

    protected class EntityArchiveWriter
    implements Callable {
        AtomicBoolean currentlySubmitted = new AtomicBoolean(false);
        private final Comparator<Comparable> nullSafeComparator = new Comparator<Comparable>(){

            @Override
            public int compare(Comparable i1, Comparable i2) {
                if (i1 != null && i2 != null) {
                    return i1.compareTo(i2);
                }
                if (i1 == null) {
                    if (i2 == null) {
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }
        };
        protected final Comparator<EntityDefault> kediComparator = new Comparator<EntityDefault>(){

            @Override
            public int compare(EntityDefault o1, EntityDefault o2) {
                String entityId1 = o1 == null ? null : o1.getEntityId();
                String entityId2 = o2 == null ? null : o2.getEntityId();
                int result = EntityArchiveWriter.this.nullSafeComparator.compare(entityId1, entityId2);
                if (result == 0) {
                    result = this.getPrincipalIdsString(o1).compareTo(this.getPrincipalIdsString(o2));
                }
                return result;
            }

            private String getPrincipalIdsString(EntityDefault entity) {
                List principals;
                String result = "";
                if (entity != null && (principals = entity.getPrincipals()) != null) {
                    if (principals.size() == 1) {
                        result = ((Principal)principals.get(0)).getPrincipalId();
                    } else {
                        Object[] ids = new String[principals.size()];
                        int insertIndex = 0;
                        for (Principal principal : principals) {
                            ids[insertIndex++] = principal.getPrincipalId();
                        }
                        Arrays.sort(ids);
                        result = StringUtils.join((Object[])ids, (String)"\n");
                    }
                }
                return result;
            }
        };

        protected EntityArchiveWriter() {
        }

        public boolean requestSubmit() {
            return this.currentlySubmitted.compareAndSet(false, true);
        }

        public Object call() {
            try {
                TransactionTemplate template = new TransactionTemplate(IdentityArchiveServiceImpl.this.transactionManager);
                template.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        EntityDefault entity = null;
                        ArrayList<EntityDefault> entitiesToInsert = new ArrayList<EntityDefault>(IdentityArchiveServiceImpl.this.getMaxWriteQueueSize());
                        HashSet<String> deduper = new HashSet<String>(IdentityArchiveServiceImpl.this.getMaxWriteQueueSize());
                        while (entitiesToInsert.size() < IdentityArchiveServiceImpl.this.getMaxWriteQueueSize() && null != (entity = IdentityArchiveServiceImpl.this.writeQueue.poll())) {
                            if (entity.getPrincipals().size() <= 0 || !deduper.add(entity.getEntityId())) continue;
                            entitiesToInsert.add(entity);
                        }
                        Collections.sort(entitiesToInsert, EntityArchiveWriter.this.kediComparator);
                        for (EntityDefault entityToInsert : entitiesToInsert) {
                            IdentityArchiveServiceImpl.this.dataObjectService.save((Object)new EntityDefaultInfoCacheBo(entityToInsert), new PersistenceOption[0]);
                        }
                        return null;
                    }
                });
            }
            finally {
                this.currentlySubmitted.compareAndSet(true, false);
            }
            return Boolean.TRUE;
        }
    }
}

