/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.IOException;
import java.io.StringReader;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.util.ContentTypeResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ContentTypeEntityResolver
extends ContentTypeResourceResolver
implements EntityResolver {
    public ContentTypeEntityResolver(NotificationContentTypeService notificationContentTypeService) {
        super(notificationContentTypeService);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.LOG.debug((Object)("Resolving '" + publicId + "' / '" + systemId + "'"));
        if (!systemId.startsWith("resource:notification/ContentType")) {
            this.LOG.warn((Object)"Cannot resolve non-ContentType resources");
            return null;
        }
        NotificationContentTypeBo notificationContentType = this.resolveContentType(systemId);
        if (notificationContentType == null) {
            this.LOG.error((Object)("Unable to resolve system id '" + systemId + "' locally...delegating to default resolution strategy."));
            return null;
        }
        this.LOG.debug((Object)("Resolved '" + systemId + "' to " + notificationContentType.getXsd()));
        return new InputSource(new StringReader(notificationContentType.getXsd()));
    }

    public String toString() {
        return "[ContentTypeEntityResolver]";
    }
}

