/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionTakenContract;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.RoleRecipient;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.Boolean01Converter;

@Entity
@Table(name="KREW_ACTN_RQST_T")
@NamedQueries(value={@NamedQuery(name="ActionRequestValue.FindPendingRootRequestsByDocumentType", query="select arv from ActionRequestValue arv where arv.documentId in (select drhv.documentId from DocumentRouteHeaderValue drhv where drhv.documentTypeId = :documentTypeId) and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null and (arv.status = :actionRequestStatus1 or arv.status = :actionRequestStatus2)"), @NamedQuery(name="ActionRequestValue.GetRequestGroupIds", query="select arv.groupId from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.recipientTypeCd = :recipientTypeCd"), @NamedQuery(name="ActionRequestValue.FindPendingByResponsibilityIds", query="SELECT DISTINCT(arv.documentId) FROM ActionRequestValue arv WHERE (arv.status = 'I' OR arv.status = 'A') AND arv.responsibilityId IN :respIds"), @NamedQuery(name="ActionRequestValue.findActionsTakenAtRouteNodeInstance", query="Select r.actionTaken from ActionRequestValue r where r.nodeInstance = :nodeInstance")})
public class ActionRequestValue
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = 8781414791855848385L;
    private static final Logger LOG = Logger.getLogger(ActionRequestValue.class);
    private static final String ACTION_CODE_RANK = "FKACB";
    private static final String RECIPIENT_TYPE_RANK = "RWU";
    private static final List DELEGATION_TYPE_RANK = Arrays.asList(DelegationType.SECONDARY, DelegationType.PRIMARY, null);
    @Id
    @GeneratedValue(generator="KREW_ACTN_RQST_S")
    @PortableSequenceGenerator(name="KREW_ACTN_RQST_S")
    @Column(name="ACTN_RQST_ID", nullable=false)
    private String actionRequestId;
    @Column(name="ACTN_RQST_CD", nullable=false)
    private String actionRequested;
    @Column(name="DOC_HDR_ID", nullable=false)
    private String documentId;
    @Column(name="RULE_ID")
    private String ruleBaseValuesId;
    @Column(name="STAT_CD", nullable=false)
    private String status;
    @Column(name="RSP_ID", nullable=false)
    private String responsibilityId;
    @Column(name="GRP_ID")
    private String groupId;
    @Column(name="ROLE_NM")
    private String roleName;
    @Column(name="QUAL_ROLE_NM")
    private String qualifiedRoleName;
    @Column(name="QUAL_ROLE_NM_LBL_TXT")
    private String qualifiedRoleNameLabel;
    @Column(name="RECIP_TYP_CD")
    private String recipientTypeCd;
    @Column(name="PRIO_NBR", nullable=false)
    private Integer priority;
    @Column(name="RTE_LVL_NBR", nullable=false)
    private Integer routeLevel;
    @Column(name="DOC_VER_NBR", nullable=false)
    private Integer docVersion = 1;
    @Column(name="CRTE_DT", nullable=false)
    private Timestamp createDate;
    @Column(name="RSP_DESC_TXT")
    private String responsibilityDesc;
    @Column(name="ACTN_RQST_ANNOTN_TXT")
    private String annotation;
    @Column(name="VER_NBR")
    private Integer jrfVerNbr;
    @Column(name="PRNCPL_ID")
    private String principalId;
    @Column(name="FRC_ACTN")
    @Convert(converter=Boolean01Converter.class)
    private Boolean forceAction;
    @Column(name="CUR_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean currentIndicator = true;
    @Column(name="APPR_PLCY")
    private String approvePolicy;
    @Column(name="DLGN_TYP")
    private String delegationTypeCode;
    @Column(name="RQST_LBL")
    private String requestLabel;
    @ManyToOne
    @JoinColumn(name="PARNT_ID")
    private ActionRequestValue parentActionRequest;
    @ManyToOne
    @JoinColumn(name="ACTN_TKN_ID")
    private ActionTakenValue actionTaken;
    @ManyToOne
    @JoinColumn(name="RTE_NODE_INSTN_ID")
    private RouteNodeInstance nodeInstance;
    @OneToMany(mappedBy="parentActionRequest", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<ActionRequestValue> childrenRequests = new ArrayList<ActionRequestValue>();
    @Transient
    private String createDateString;
    @Transient
    private String displayStatus;
    @Transient
    private boolean resolveResponsibility = true;
    @Transient
    private DocumentRouteHeaderValue routeHeader;
    @Transient
    private List<ActionItem> simulatedActionItems;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public ActionRequestValue() {
        this.createDate = new Timestamp(System.currentTimeMillis());
    }

    public Group getGroup() {
        if (this.getGroupId() == null) {
            LOG.error((Object)"Attempting to get a group with a blank group id");
            return null;
        }
        return KimApiServiceLocator.getGroupService().getGroup(this.getGroupId());
    }

    public String getRouteLevelName() {
        if (CompatUtils.isRouteLevelRequest(this)) {
            int routeLevelInt = this.getRouteLevel();
            if (routeLevelInt == -1) {
                return "Exception";
            }
            List<RouteNode> routeLevelNodes = CompatUtils.getRouteLevelCompatibleNodeList(KEWServiceLocator.getRouteHeaderService().getRouteHeader(this._persistence_get_documentId()).getDocumentType());
            if (routeLevelInt >= routeLevelNodes.size()) {
                return "Not Found";
            }
            return routeLevelNodes.get(routeLevelInt).getRouteNodeName();
        }
        return this._persistence_get_nodeInstance() == null ? "Exception" : this._persistence_get_nodeInstance().getName();
    }

    public boolean isUserRequest() {
        return this._persistence_get_principalId() != null;
    }

    public Principal getPrincipal() {
        if (this.getPrincipalId() == null) {
            return null;
        }
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getPrincipalId());
    }

    public Person getPerson() {
        if (this.getPrincipalId() == null) {
            return null;
        }
        return KimApiServiceLocator.getPersonService().getPerson(this.getPrincipalId());
    }

    public String getDisplayName() {
        if (this.isUserRequest()) {
            Person person = this.getPerson();
            if (person != null) {
                return person.getName();
            }
        } else {
            if (this.isGroupRequest()) {
                Group group = this.getGroup();
                if (group != null) {
                    return group.getName();
                }
                return this.getGroupId();
            }
            if (this.isRoleRequest()) {
                return this.getRoleName();
            }
        }
        return "";
    }

    public Recipient getRecipient() {
        if (this.getPrincipalId() != null) {
            return new KimPrincipalRecipient((PrincipalContract)this.getPrincipal());
        }
        if (this.getGroupId() != null) {
            return new KimGroupRecipient(this.getGroup());
        }
        return new RoleRecipient(this.getRoleName());
    }

    public boolean isPending() {
        return ActionRequestStatus.INITIALIZED.getCode().equals(this.getStatus()) || ActionRequestStatus.ACTIVATED.getCode().equals(this.getStatus());
    }

    public String getStatusLabel() {
        return CodeTranslator.getActionRequestStatusLabel((String)this.getStatus());
    }

    public String getActionRequestedLabel() {
        if (StringUtils.isNotBlank((String)this.getRequestLabel())) {
            return this.getRequestLabel();
        }
        return CodeTranslator.getActionRequestLabel((String)this.getActionRequested());
    }

    public ActionTakenValue getActionTaken() {
        return this._persistence_get_actionTaken();
    }

    public void setActionTaken(ActionTakenValue actionTaken) {
        this._persistence_set_actionTaken(actionTaken);
    }

    public String getActionRequested() {
        return this._persistence_get_actionRequested();
    }

    public void setActionRequested(String actionRequested) {
        this._persistence_set_actionRequested(actionRequested);
    }

    public String getActionRequestId() {
        return this._persistence_get_actionRequestId();
    }

    public void setActionRequestId(String actionRequestId) {
        this._persistence_set_actionRequestId(actionRequestId);
    }

    public String getActionTakenId() {
        if (this.getActionTaken() == null) {
            return null;
        }
        return this.getActionTaken().getActionTakenId();
    }

    public String getAnnotation() {
        return this._persistence_get_annotation();
    }

    public void setAnnotation(String annotation) {
        this._persistence_set_annotation(annotation);
    }

    public Timestamp getCreateDate() {
        return this._persistence_get_createDate();
    }

    public void setCreateDate(Timestamp createDate) {
        this._persistence_set_createDate(createDate);
    }

    public Integer getDocVersion() {
        return this._persistence_get_docVersion();
    }

    public void setDocVersion(Integer docVersion) {
        this._persistence_set_docVersion(docVersion);
    }

    public String getPrincipalId() {
        return this._persistence_get_principalId();
    }

    public void setPrincipalId(String principalId) {
        this._persistence_set_principalId(principalId);
    }

    public Boolean getForceAction() {
        return this._persistence_get_forceAction();
    }

    public void setForceAction(Boolean forceAction) {
        this._persistence_set_forceAction(forceAction);
    }

    public Integer getJrfVerNbr() {
        return this._persistence_get_jrfVerNbr();
    }

    public void setJrfVerNbr(Integer jrfVerNbr) {
        this._persistence_set_jrfVerNbr(jrfVerNbr);
    }

    public Integer getPriority() {
        return this._persistence_get_priority();
    }

    public void setPriority(Integer priority) {
        this._persistence_set_priority(priority);
    }

    public String getRecipientTypeCd() {
        return this._persistence_get_recipientTypeCd();
    }

    public void setRecipientTypeCd(String recipientTypeCd) {
        this._persistence_set_recipientTypeCd(recipientTypeCd);
    }

    public String getResponsibilityDesc() {
        return this._persistence_get_responsibilityDesc();
    }

    public void setResponsibilityDesc(String responsibilityDesc) {
        this._persistence_set_responsibilityDesc(responsibilityDesc);
    }

    public String getResponsibilityId() {
        return this._persistence_get_responsibilityId();
    }

    public void setResponsibilityId(String responsibilityId) {
        this._persistence_set_responsibilityId(responsibilityId);
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public Integer getRouteLevel() {
        return this._persistence_get_routeLevel();
    }

    public void setRouteLevel(Integer routeLevel) {
        this._persistence_set_routeLevel(routeLevel);
    }

    public String getStatus() {
        return this._persistence_get_status();
    }

    public void setStatus(String status) {
        this._persistence_set_status(status);
    }

    public String getGroupId() {
        return this._persistence_get_groupId();
    }

    public void setGroupId(String groupId) {
        this._persistence_set_groupId(groupId);
    }

    public boolean isInitialized() {
        return ActionRequestStatus.INITIALIZED.getCode().equals(this.getStatus());
    }

    public boolean isActive() {
        return ActionRequestStatus.ACTIVATED.getCode().equals(this.getStatus());
    }

    public boolean isApproveOrCompleteRequest() {
        return "A".equals(this.getActionRequested()) || "C".equals(this.getActionRequested());
    }

    public boolean isDone() {
        return ActionRequestStatus.DONE.getCode().equals(this.getStatus());
    }

    public boolean isReviewerUser() {
        return RecipientType.PRINCIPAL.getCode().equals(this.getRecipientTypeCd());
    }

    public boolean isRecipientRoutedRequest(String principalId) {
        if (principalId == null || "".equals(principalId)) {
            return false;
        }
        boolean isRecipientInGraph = false;
        if (this.isReviewerUser()) {
            isRecipientInGraph = this.getPrincipalId().equals(principalId);
        } else if (this.isGroupRequest()) {
            Group group = this.getGroup();
            if (group == null) {
                LOG.error((Object)("Was unable to retrieve workgroup " + this.getGroupId()));
            }
            isRecipientInGraph = KimApiServiceLocator.getGroupService().isMemberOfGroup(principalId, group.getId());
        }
        for (ActionRequestValue childRequest : this.getChildrenRequests()) {
            isRecipientInGraph = isRecipientInGraph || childRequest.isRecipientRoutedRequest(principalId);
        }
        return isRecipientInGraph;
    }

    public boolean isRecipientRoutedRequest(Recipient recipient) {
        if (recipient == null) {
            return false;
        }
        boolean isRecipientInGraph = false;
        if (this.isReviewerUser()) {
            if (recipient instanceof KimPrincipalRecipient) {
                isRecipientInGraph = this.getPrincipalId().equals(((KimPrincipalRecipient)recipient).getPrincipalId());
            } else if (recipient instanceof KimGroupRecipient) {
                isRecipientInGraph = KimApiServiceLocator.getGroupService().isMemberOfGroup(this.getPrincipalId(), ((KimGroupRecipient)recipient).getGroup().getId());
            }
        } else if (this.isGroupRequest()) {
            Group group = this.getGroup();
            if (group == null) {
                LOG.error((Object)("Was unable to retrieve workgroup " + this.getGroupId()));
            }
            if (recipient instanceof KimPrincipalRecipient) {
                KimPrincipalRecipient principalRecipient = (KimPrincipalRecipient)recipient;
                isRecipientInGraph = KimApiServiceLocator.getGroupService().isMemberOfGroup(principalRecipient.getPrincipalId(), group.getId());
            } else if (recipient instanceof KimGroupRecipient) {
                isRecipientInGraph = ((KimGroupRecipient)recipient).getGroup().getId().equals(group.getId());
            }
        }
        for (ActionRequestValue childRequest : this.getChildrenRequests()) {
            isRecipientInGraph = isRecipientInGraph || childRequest.isRecipientRoutedRequest(recipient);
        }
        return isRecipientInGraph;
    }

    public boolean isGroupRequest() {
        return RecipientType.GROUP.getCode().equals(this.getRecipientTypeCd());
    }

    public boolean isRoleRequest() {
        return RecipientType.ROLE.getCode().equals(this.getRecipientTypeCd());
    }

    public boolean isAcknowledgeRequest() {
        return "K".equals(this.getActionRequested());
    }

    public boolean isApproveRequest() {
        return "A".equals(this.getActionRequested());
    }

    public boolean isCompleteRequst() {
        return "C".equals(this.getActionRequested());
    }

    public boolean isFYIRequest() {
        return "F".equals(this.getActionRequested());
    }

    public static int compareActionCode(String code1, String code2, boolean completeAndApproveTheSame) {
        int cutoff = Integer.MAX_VALUE;
        if (completeAndApproveTheSame) {
            cutoff = ACTION_CODE_RANK.length() - 3;
        }
        Integer code1Index = Math.min(ACTION_CODE_RANK.indexOf(code1), cutoff);
        Integer code2Index = Math.min(ACTION_CODE_RANK.indexOf(code2), cutoff);
        return code1Index.compareTo(code2Index);
    }

    public static int compareRecipientType(String type1, String type2) {
        Integer type1Index = RECIPIENT_TYPE_RANK.indexOf(type1);
        Integer type2Index = RECIPIENT_TYPE_RANK.indexOf(type2);
        return type1Index.compareTo(type2Index);
    }

    public static int compareDelegationType(DelegationType type1, DelegationType type2) {
        Integer type1Index = DELEGATION_TYPE_RANK.indexOf(type1);
        Integer type2Index = DELEGATION_TYPE_RANK.indexOf(type2);
        return type1Index.compareTo(type2Index);
    }

    public List<ActionItem> getActionItems() {
        if (this.simulatedActionItems == null || this.simulatedActionItems.isEmpty()) {
            return (List)KEWServiceLocator.getActionListService().findByActionRequestId(this._persistence_get_actionRequestId());
        }
        return this.simulatedActionItems;
    }

    public List<ActionItem> getSimulatedActionItems() {
        if (this.simulatedActionItems == null) {
            this.simulatedActionItems = new ArrayList<ActionItem>();
        }
        return this.simulatedActionItems;
    }

    public void setSimulatedActionItems(List<ActionItem> simulatedActionItems) {
        this.simulatedActionItems = simulatedActionItems;
    }

    public Boolean getCurrentIndicator() {
        return this._persistence_get_currentIndicator();
    }

    public void setCurrentIndicator(Boolean currentIndicator) {
        this._persistence_set_currentIndicator(currentIndicator);
    }

    public String getParentActionRequestId() {
        if (this.getParentActionRequest() == null) {
            return null;
        }
        return this.getParentActionRequest().getActionRequestId();
    }

    public ActionRequestValue getParentActionRequest() {
        return this._persistence_get_parentActionRequest();
    }

    public void setParentActionRequest(ActionRequestValue parentActionRequest) {
        this._persistence_set_parentActionRequest(parentActionRequest);
    }

    public List<ActionRequestValue> getChildrenRequests() {
        return this._persistence_get_childrenRequests();
    }

    public void setChildrenRequests(List<ActionRequestValue> childrenRequests) {
        this._persistence_set_childrenRequests(childrenRequests);
    }

    public String getQualifiedRoleName() {
        return this._persistence_get_qualifiedRoleName();
    }

    public void setQualifiedRoleName(String roleName) {
        this._persistence_set_qualifiedRoleName(roleName);
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this._persistence_get_delegationTypeCode());
    }

    public void setDelegationType(DelegationType delegationPolicy) {
        this._persistence_set_delegationTypeCode(delegationPolicy == null ? null : delegationPolicy.getCode());
    }

    public String getDelegationTypeCode() {
        return this._persistence_get_delegationTypeCode();
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this._persistence_set_delegationTypeCode(delegationTypeCode);
    }

    public String getRoleName() {
        return this._persistence_get_roleName();
    }

    public void setRoleName(String roleName) {
        this._persistence_set_roleName(roleName);
    }

    public String getApprovePolicy() {
        return this._persistence_get_approvePolicy();
    }

    public void setApprovePolicy(String requestType) {
        this._persistence_set_approvePolicy(requestType);
    }

    public boolean getHasApprovePolicy() {
        return this.getApprovePolicy() != null;
    }

    public boolean isDeactivated() {
        return ActionRequestStatus.DONE.getCode().equals(this.getStatus());
    }

    public boolean hasParent() {
        return this.getParentActionRequest() != null;
    }

    public boolean hasChild(ActionRequestValue actionRequest) {
        if (actionRequest == null) {
            return false;
        }
        String actionRequestId = actionRequest.getActionRequestId();
        for (ActionRequestValue childRequest : this.getChildrenRequests()) {
            if (!childRequest.equals(actionRequest) && (actionRequestId == null || !actionRequestId.equals(childRequest.getActionRequestId()))) continue;
            return true;
        }
        return false;
    }

    public String getDisplayStatus() {
        return this.displayStatus;
    }

    public void setDisplayStatus(String displayStatus) {
        this.displayStatus = displayStatus;
    }

    public String getQualifiedRoleNameLabel() {
        return this._persistence_get_qualifiedRoleNameLabel();
    }

    public void setQualifiedRoleNameLabel(String qualifiedRoleNameLabel) {
        this._persistence_set_qualifiedRoleNameLabel(qualifiedRoleNameLabel);
    }

    public String getCreateDateString() {
        if (this.createDateString == null || this.createDateString.trim().equals("")) {
            return RiceConstants.getDefaultDateFormat().format(this.getCreateDate());
        }
        return this.createDateString;
    }

    public void setCreateDateString(String createDateString) {
        this.createDateString = createDateString;
    }

    public RouteNodeInstance getNodeInstance() {
        return this._persistence_get_nodeInstance();
    }

    public String getPotentialNodeName() {
        return this.getNodeInstance() == null ? "" : this.getNodeInstance().getName();
    }

    public void setNodeInstance(RouteNodeInstance nodeInstance) {
        this._persistence_set_nodeInstance(nodeInstance);
    }

    public String getRecipientTypeLabel() {
        return RecipientType.fromCode((String)this.getRecipientTypeCd()).getLabel();
    }

    public RuleBaseValues getRuleBaseValues() {
        if (this._persistence_get_ruleBaseValuesId() != null) {
            return this.getRuleService().findRuleBaseValuesById(this._persistence_get_ruleBaseValuesId());
        }
        return null;
    }

    public String getRuleBaseValuesId() {
        return this._persistence_get_ruleBaseValuesId();
    }

    public void setRuleBaseValuesId(String ruleBaseValuesId) {
        this._persistence_set_ruleBaseValuesId(ruleBaseValuesId);
    }

    private RuleServiceInternal getRuleService() {
        return (RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal");
    }

    public boolean isPrimaryDelegator() {
        boolean primaryDelegator = false;
        for (ActionRequestValue childRequest : this._persistence_get_childrenRequests()) {
            primaryDelegator = DelegationType.PRIMARY.equals((Object)childRequest.getDelegationType()) || primaryDelegator;
        }
        return primaryDelegator;
    }

    public List<ActionRequestValue> getPrimaryDelegateRequests() {
        ArrayList<ActionRequestValue> primaryDelegateRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue childRequest : this._persistence_get_childrenRequests()) {
            if (!DelegationType.PRIMARY.equals((Object)childRequest.getDelegationType())) continue;
            if (childRequest.isRoleRequest()) {
                for (ActionRequestValue actionRequestValue : childRequest.getChildrenRequests()) {
                    primaryDelegateRequests.add(actionRequestValue);
                }
                continue;
            }
            primaryDelegateRequests.add(childRequest);
        }
        return primaryDelegateRequests;
    }

    public boolean isAdHocRequest() {
        return "-1".equals(this.getResponsibilityId());
    }

    public boolean isGeneratedRequest() {
        return "0".equals(this.getResponsibilityId());
    }

    public boolean isExceptionRequest() {
        return "-2".equals(this.getResponsibilityId());
    }

    public boolean isRouteModuleRequest() {
        return this.getResponsibilityId() != null && !KewApiConstants.SPECIAL_RESPONSIBILITY_ID_SET.contains(this.getResponsibilityId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("actionRequestId", (Object)this._persistence_get_actionRequestId()).append("actionRequested", (Object)this._persistence_get_actionRequested()).append("documentId", (Object)this._persistence_get_documentId()).append("status", (Object)this._persistence_get_status()).append("responsibilityId", (Object)this._persistence_get_responsibilityId()).append("groupId", (Object)this._persistence_get_groupId()).append("recipientTypeCd", (Object)this._persistence_get_recipientTypeCd()).append("priority", (Object)this._persistence_get_priority()).append("routeLevel", (Object)this._persistence_get_routeLevel()).append("docVersion", (Object)this._persistence_get_docVersion()).append("createDate", (Object)this._persistence_get_createDate()).append("responsibilityDesc", (Object)this._persistence_get_responsibilityDesc()).append("annotation", (Object)this._persistence_get_annotation()).append("jrfVerNbr", (Object)this._persistence_get_jrfVerNbr()).append("principalId", (Object)this._persistence_get_principalId()).append("forceAction", (Object)this._persistence_get_forceAction()).append("qualifiedRoleName", (Object)this._persistence_get_qualifiedRoleName()).append("roleName", (Object)this._persistence_get_roleName()).append("qualifiedRoleNameLabel", (Object)this._persistence_get_qualifiedRoleNameLabel()).append("displayStatus", (Object)this.displayStatus).append("ruleBaseValuesId", (Object)this._persistence_get_ruleBaseValuesId()).append("delegationType", (Object)this._persistence_get_delegationTypeCode()).append("approvePolicy", (Object)this._persistence_get_approvePolicy()).append("actionTaken", (Object)this._persistence_get_actionTaken()).append("currentIndicator", (Object)this._persistence_get_currentIndicator()).append("createDateString", (Object)this.createDateString).append("nodeInstance", (Object)this._persistence_get_nodeInstance()).toString();
    }

    public String getRequestLabel() {
        return this._persistence_get_requestLabel();
    }

    public void setRequestLabel(String requestLabel) {
        this._persistence_set_requestLabel(requestLabel);
    }

    public String getGroupName() {
        return KimApiServiceLocator.getGroupService().getGroup(this._persistence_get_groupId()).getName();
    }

    public boolean getResolveResponsibility() {
        return this.resolveResponsibility;
    }

    public void setResolveResponsibility(boolean resolveResponsibility) {
        this.resolveResponsibility = resolveResponsibility;
    }

    public DocumentRouteHeaderValue getRouteHeader() {
        if (this.routeHeader == null && this._persistence_get_documentId() != null) {
            this.routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this._persistence_get_documentId());
        }
        return this.routeHeader;
    }

    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    public ActionRequestValue deepCopy(Map<Object, Object> visited) {
        ArrayList<ActionItem> copies;
        if (visited.containsKey(this)) {
            return (ActionRequestValue)visited.get(this);
        }
        ActionRequestValue copy = new ActionRequestValue();
        visited.put(this, copy);
        copy._persistence_set_actionRequestId(this._persistence_get_actionRequestId());
        copy._persistence_set_actionRequested(this._persistence_get_actionRequested());
        copy._persistence_set_documentId(this._persistence_get_documentId());
        copy._persistence_set_ruleBaseValuesId(this._persistence_get_ruleBaseValuesId());
        copy._persistence_set_status(this._persistence_get_status());
        copy._persistence_set_responsibilityId(this._persistence_get_responsibilityId());
        copy._persistence_set_groupId(this._persistence_get_groupId());
        copy._persistence_set_roleName(this._persistence_get_roleName());
        copy._persistence_set_qualifiedRoleName(this._persistence_get_qualifiedRoleName());
        copy._persistence_set_qualifiedRoleNameLabel(this._persistence_get_qualifiedRoleNameLabel());
        copy._persistence_set_recipientTypeCd(this._persistence_get_recipientTypeCd());
        copy._persistence_set_priority(this._persistence_get_priority());
        copy._persistence_set_routeLevel(this._persistence_get_routeLevel());
        copy._persistence_set_docVersion(this._persistence_get_docVersion());
        if (this._persistence_get_createDate() != null) {
            copy._persistence_set_createDate(new Timestamp(this._persistence_get_createDate().getTime()));
        }
        copy._persistence_set_responsibilityDesc(this._persistence_get_responsibilityDesc());
        copy._persistence_set_annotation(this._persistence_get_annotation());
        copy._persistence_set_jrfVerNbr(this._persistence_get_jrfVerNbr());
        copy._persistence_set_principalId(this._persistence_get_principalId());
        copy._persistence_set_forceAction(this._persistence_get_forceAction());
        copy._persistence_set_currentIndicator(this._persistence_get_currentIndicator());
        copy._persistence_set_approvePolicy(this._persistence_get_approvePolicy());
        copy._persistence_set_delegationTypeCode(this._persistence_get_delegationTypeCode());
        copy._persistence_set_requestLabel(this._persistence_get_requestLabel());
        if (this._persistence_get_parentActionRequest() != null) {
            copy._persistence_set_parentActionRequest(this._persistence_get_parentActionRequest().deepCopy(visited));
        }
        if (this._persistence_get_actionTaken() != null) {
            copy._persistence_set_actionTaken(this._persistence_get_actionTaken().deepCopy(visited));
        }
        if (this._persistence_get_nodeInstance() != null) {
            copy._persistence_set_nodeInstance(this._persistence_get_nodeInstance().deepCopy(visited));
        }
        if (this._persistence_get_childrenRequests() != null) {
            copies = new ArrayList<ActionItem>();
            for (ActionRequestValue childRequest : this._persistence_get_childrenRequests()) {
                copies.add((ActionItem)((Object)childRequest.deepCopy(visited)));
            }
            copy._persistence_set_childrenRequests(copies);
        }
        copy.createDateString = this.createDateString;
        copy.displayStatus = this.displayStatus;
        copy.resolveResponsibility = this.resolveResponsibility;
        if (this.routeHeader != null) {
            copy.routeHeader = this.routeHeader.deepCopy(visited);
        }
        if (this.simulatedActionItems != null) {
            copies = new ArrayList();
            for (ActionItem simulatedActionItem : this.simulatedActionItems) {
                copies.add(simulatedActionItem.deepCopy(visited));
            }
            copy.simulatedActionItems = copies;
        }
        return copy;
    }

    public static ActionRequest to(ActionRequestValue actionRequestBo) {
        if (actionRequestBo == null) {
            return null;
        }
        return ActionRequestValue.createActionRequestBuilder(actionRequestBo).build();
    }

    private static ActionRequest.Builder createActionRequestBuilder(ActionRequestValue actionRequestBo) {
        ActionRequest.Builder builder = ActionRequest.Builder.create((String)actionRequestBo.getActionRequestId(), (ActionRequestType)ActionRequestType.fromCode((String)actionRequestBo.getActionRequested()), (ActionRequestStatus)ActionRequestStatus.fromCode((String)actionRequestBo.getStatus()), (String)actionRequestBo.getResponsibilityId(), (String)actionRequestBo.getDocumentId(), (RecipientType)RecipientType.fromCode((String)actionRequestBo.getRecipientTypeCd()));
        if (actionRequestBo.getActionTaken() != null) {
            builder.setActionTaken(ActionTaken.Builder.create((ActionTakenContract)ActionTakenValue.to(actionRequestBo.getActionTaken())));
        }
        builder.setAnnotation(actionRequestBo.getAnnotation());
        builder.setCurrent(actionRequestBo.getCurrentIndicator().booleanValue());
        builder.setDateCreated(new DateTime(actionRequestBo.getCreateDate().getTime()));
        if (actionRequestBo.getDelegationType() != null) {
            builder.setDelegationType(actionRequestBo.getDelegationType());
        }
        builder.setForceAction(actionRequestBo.getForceAction().booleanValue());
        builder.setGroupId(actionRequestBo.getGroupId());
        builder.setNodeName(actionRequestBo.getPotentialNodeName());
        if (actionRequestBo.getParentActionRequestId() != null) {
            builder.setParentActionRequestId(actionRequestBo.getParentActionRequestId());
        }
        builder.setPrincipalId(actionRequestBo.getPrincipalId());
        if (actionRequestBo.getPriority() == null) {
            builder.setPriority(1);
        } else {
            builder.setPriority(actionRequestBo.getPriority().intValue());
        }
        if (actionRequestBo.getRouteLevel() == null) {
            builder.setRouteLevel(0);
        } else {
            builder.setRouteLevel(actionRequestBo.getRouteLevel().intValue());
        }
        builder.setQualifiedRoleName(actionRequestBo.getQualifiedRoleName());
        builder.setQualifiedRoleNameLabel(actionRequestBo.getQualifiedRoleNameLabel());
        builder.setRequestLabel(actionRequestBo.getRequestLabel());
        if (!StringUtils.isBlank((String)actionRequestBo.getApprovePolicy())) {
            builder.setRequestPolicy(ActionRequestPolicy.fromCode((String)actionRequestBo.getApprovePolicy()));
        }
        builder.setResponsibilityDescription(actionRequestBo.getResponsibilityDesc());
        builder.setRoleName(actionRequestBo.getRoleName());
        if (actionRequestBo.getNodeInstance() != null) {
            builder.setRouteNodeInstanceId(actionRequestBo.getNodeInstance().getRouteNodeInstanceId());
        }
        ArrayList<ActionRequest.Builder> childRequests = new ArrayList<ActionRequest.Builder>();
        if (actionRequestBo.getChildrenRequests() != null) {
            for (ActionRequestValue childActionRequestBo : actionRequestBo.getChildrenRequests()) {
                childRequests.add(ActionRequestValue.createActionRequestBuilder(childActionRequestBo));
            }
        }
        builder.setChildRequests(childRequests);
        return builder;
    }

    public static ActionRequestValue from(ActionRequest actionRequest) {
        return ActionRequestValue.from(actionRequest, null);
    }

    public static ActionRequestValue from(ActionRequest actionRequest, DTOConverter.RouteNodeInstanceLoader routeNodeInstanceLoader) {
        return ActionRequestValue.convertActionRequest(actionRequest, null, routeNodeInstanceLoader);
    }

    private static ActionRequestValue convertActionRequest(ActionRequest actionRequest, ActionRequestValue parentActionRequestBo, DTOConverter.RouteNodeInstanceLoader routeNodeInstanceLoader) {
        if (actionRequest == null) {
            return null;
        }
        ActionRequestValue actionRequestBo = new ActionRequestFactory().createBlankActionRequest();
        ActionRequestValue.populateActionRequest(actionRequestBo, actionRequest, routeNodeInstanceLoader);
        if (parentActionRequestBo != null) {
            actionRequestBo.setParentActionRequest(parentActionRequestBo);
        }
        if (actionRequest.getChildRequests() != null) {
            for (ActionRequest childRequest : actionRequest.getChildRequests()) {
                actionRequestBo.getChildrenRequests().add(ActionRequestValue.convertActionRequest(childRequest, actionRequestBo, routeNodeInstanceLoader));
            }
        }
        return actionRequestBo;
    }

    private static void populateActionRequest(ActionRequestValue actionRequestBo, ActionRequest actionRequest, DTOConverter.RouteNodeInstanceLoader routeNodeInstanceLoader) {
        actionRequestBo.setActionRequested(actionRequest.getActionRequested().getCode());
        if (!StringUtils.isBlank((String)actionRequest.getId())) {
            actionRequestBo.setActionRequestId(actionRequest.getId());
        }
        if (actionRequest.getActionTaken() != null && !StringUtils.isBlank((String)actionRequest.getActionTaken().getId())) {
            actionRequestBo.setActionTaken(KEWServiceLocator.getActionTakenService().findByActionTakenId(actionRequest.getActionTaken().getId()));
        }
        actionRequestBo.setAnnotation(actionRequest.getAnnotation());
        if (actionRequest.getRequestPolicy() != null) {
            actionRequestBo.setApprovePolicy(actionRequest.getRequestPolicy().getCode());
        }
        actionRequestBo.setCreateDate(new Timestamp(actionRequest.getDateCreated().getMillis()));
        actionRequestBo.setCurrentIndicator(actionRequest.isCurrent());
        if (actionRequest.getDelegationType() != null) {
            actionRequestBo.setDelegationType(actionRequest.getDelegationType());
        }
        actionRequestBo.setForceAction(actionRequest.isForceAction());
        actionRequestBo.setPriority(actionRequest.getPriority());
        actionRequestBo.setRouteLevel(actionRequest.getRouteLevel());
        actionRequestBo.setQualifiedRoleName(actionRequest.getQualifiedRoleName());
        actionRequestBo.setQualifiedRoleNameLabel(actionRequest.getQualifiedRoleNameLabel());
        actionRequestBo.setRecipientTypeCd(actionRequest.getRecipientType().getCode());
        actionRequestBo.setResponsibilityDesc(actionRequest.getResponsibilityDescription());
        if (!StringUtils.isBlank((String)actionRequest.getResponsibilityId())) {
            actionRequestBo.setResponsibilityId(actionRequest.getResponsibilityId());
        }
        actionRequestBo.setRoleName(actionRequest.getRoleName());
        String documentId = actionRequest.getDocumentId();
        if (documentId != null) {
            actionRequestBo.setDocumentId(documentId);
            actionRequestBo.setRouteHeader(KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId));
        }
        actionRequestBo.setStatus(actionRequest.getStatus().getCode());
        actionRequestBo.setPrincipalId(actionRequest.getPrincipalId());
        actionRequestBo.setGroupId(actionRequest.getGroupId());
        if (routeNodeInstanceLoader != null && !StringUtils.isBlank((String)actionRequest.getRouteNodeInstanceId())) {
            actionRequestBo.setNodeInstance(routeNodeInstanceLoader.load(actionRequest.getRouteNodeInstanceId()));
        }
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ActionRequestValue();
    }

    public Object _persistence_get(String string) {
        if (string == "recipientTypeCd") {
            return this.recipientTypeCd;
        }
        if (string == "delegationTypeCode") {
            return this.delegationTypeCode;
        }
        if (string == "jrfVerNbr") {
            return this.jrfVerNbr;
        }
        if (string == "groupId") {
            return this.groupId;
        }
        if (string == "qualifiedRoleName") {
            return this.qualifiedRoleName;
        }
        if (string == "responsibilityId") {
            return this.responsibilityId;
        }
        if (string == "principalId") {
            return this.principalId;
        }
        if (string == "ruleBaseValuesId") {
            return this.ruleBaseValuesId;
        }
        if (string == "responsibilityDesc") {
            return this.responsibilityDesc;
        }
        if (string == "parentActionRequest") {
            return this.parentActionRequest;
        }
        if (string == "qualifiedRoleNameLabel") {
            return this.qualifiedRoleNameLabel;
        }
        if (string == "actionRequestId") {
            return this.actionRequestId;
        }
        if (string == "docVersion") {
            return this.docVersion;
        }
        if (string == "createDate") {
            return this.createDate;
        }
        if (string == "annotation") {
            return this.annotation;
        }
        if (string == "approvePolicy") {
            return this.approvePolicy;
        }
        if (string == "currentIndicator") {
            return this.currentIndicator;
        }
        if (string == "nodeInstance") {
            return this.nodeInstance;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "routeLevel") {
            return this.routeLevel;
        }
        if (string == "forceAction") {
            return this.forceAction;
        }
        if (string == "actionRequested") {
            return this.actionRequested;
        }
        if (string == "childrenRequests") {
            return this.childrenRequests;
        }
        if (string == "actionTaken") {
            return this.actionTaken;
        }
        if (string == "roleName") {
            return this.roleName;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "requestLabel") {
            return this.requestLabel;
        }
        if (string == "status") {
            return this.status;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "recipientTypeCd") {
            this.recipientTypeCd = (String)object;
            return;
        }
        if (string == "delegationTypeCode") {
            this.delegationTypeCode = (String)object;
            return;
        }
        if (string == "jrfVerNbr") {
            this.jrfVerNbr = (Integer)object;
            return;
        }
        if (string == "groupId") {
            this.groupId = (String)object;
            return;
        }
        if (string == "qualifiedRoleName") {
            this.qualifiedRoleName = (String)object;
            return;
        }
        if (string == "responsibilityId") {
            this.responsibilityId = (String)object;
            return;
        }
        if (string == "principalId") {
            this.principalId = (String)object;
            return;
        }
        if (string == "ruleBaseValuesId") {
            this.ruleBaseValuesId = (String)object;
            return;
        }
        if (string == "responsibilityDesc") {
            this.responsibilityDesc = (String)object;
            return;
        }
        if (string == "parentActionRequest") {
            this.parentActionRequest = (ActionRequestValue)object;
            return;
        }
        if (string == "qualifiedRoleNameLabel") {
            this.qualifiedRoleNameLabel = (String)object;
            return;
        }
        if (string == "actionRequestId") {
            this.actionRequestId = (String)object;
            return;
        }
        if (string == "docVersion") {
            this.docVersion = (Integer)object;
            return;
        }
        if (string == "createDate") {
            this.createDate = (Timestamp)object;
            return;
        }
        if (string == "annotation") {
            this.annotation = (String)object;
            return;
        }
        if (string == "approvePolicy") {
            this.approvePolicy = (String)object;
            return;
        }
        if (string == "currentIndicator") {
            this.currentIndicator = (Boolean)object;
            return;
        }
        if (string == "nodeInstance") {
            this.nodeInstance = (RouteNodeInstance)object;
            return;
        }
        if (string == "priority") {
            this.priority = (Integer)object;
            return;
        }
        if (string == "routeLevel") {
            this.routeLevel = (Integer)object;
            return;
        }
        if (string == "forceAction") {
            this.forceAction = (Boolean)object;
            return;
        }
        if (string == "actionRequested") {
            this.actionRequested = (String)object;
            return;
        }
        if (string == "childrenRequests") {
            this.childrenRequests = (List)object;
            return;
        }
        if (string == "actionTaken") {
            this.actionTaken = (ActionTakenValue)object;
            return;
        }
        if (string == "roleName") {
            this.roleName = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "requestLabel") {
            this.requestLabel = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (String)object;
            return;
        }
    }

    public String _persistence_get_recipientTypeCd() {
        this._persistence_checkFetched("recipientTypeCd");
        return this.recipientTypeCd;
    }

    public void _persistence_set_recipientTypeCd(String string) {
        this._persistence_checkFetchedForSet("recipientTypeCd");
        this.recipientTypeCd = string;
    }

    public String _persistence_get_delegationTypeCode() {
        this._persistence_checkFetched("delegationTypeCode");
        return this.delegationTypeCode;
    }

    public void _persistence_set_delegationTypeCode(String string) {
        this._persistence_checkFetchedForSet("delegationTypeCode");
        this.delegationTypeCode = string;
    }

    public Integer _persistence_get_jrfVerNbr() {
        this._persistence_checkFetched("jrfVerNbr");
        return this.jrfVerNbr;
    }

    public void _persistence_set_jrfVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("jrfVerNbr");
        this.jrfVerNbr = n;
    }

    public String _persistence_get_groupId() {
        this._persistence_checkFetched("groupId");
        return this.groupId;
    }

    public void _persistence_set_groupId(String string) {
        this._persistence_checkFetchedForSet("groupId");
        this.groupId = string;
    }

    public String _persistence_get_qualifiedRoleName() {
        this._persistence_checkFetched("qualifiedRoleName");
        return this.qualifiedRoleName;
    }

    public void _persistence_set_qualifiedRoleName(String string) {
        this._persistence_checkFetchedForSet("qualifiedRoleName");
        this.qualifiedRoleName = string;
    }

    public String _persistence_get_responsibilityId() {
        this._persistence_checkFetched("responsibilityId");
        return this.responsibilityId;
    }

    public void _persistence_set_responsibilityId(String string) {
        this._persistence_checkFetchedForSet("responsibilityId");
        this.responsibilityId = string;
    }

    public String _persistence_get_principalId() {
        this._persistence_checkFetched("principalId");
        return this.principalId;
    }

    public void _persistence_set_principalId(String string) {
        this._persistence_checkFetchedForSet("principalId");
        this.principalId = string;
    }

    public String _persistence_get_ruleBaseValuesId() {
        this._persistence_checkFetched("ruleBaseValuesId");
        return this.ruleBaseValuesId;
    }

    public void _persistence_set_ruleBaseValuesId(String string) {
        this._persistence_checkFetchedForSet("ruleBaseValuesId");
        this.ruleBaseValuesId = string;
    }

    public String _persistence_get_responsibilityDesc() {
        this._persistence_checkFetched("responsibilityDesc");
        return this.responsibilityDesc;
    }

    public void _persistence_set_responsibilityDesc(String string) {
        this._persistence_checkFetchedForSet("responsibilityDesc");
        this.responsibilityDesc = string;
    }

    public ActionRequestValue _persistence_get_parentActionRequest() {
        this._persistence_checkFetched("parentActionRequest");
        return this.parentActionRequest;
    }

    public void _persistence_set_parentActionRequest(ActionRequestValue actionRequestValue) {
        this._persistence_checkFetchedForSet("parentActionRequest");
        this.parentActionRequest = actionRequestValue;
    }

    public String _persistence_get_qualifiedRoleNameLabel() {
        this._persistence_checkFetched("qualifiedRoleNameLabel");
        return this.qualifiedRoleNameLabel;
    }

    public void _persistence_set_qualifiedRoleNameLabel(String string) {
        this._persistence_checkFetchedForSet("qualifiedRoleNameLabel");
        this.qualifiedRoleNameLabel = string;
    }

    public String _persistence_get_actionRequestId() {
        this._persistence_checkFetched("actionRequestId");
        return this.actionRequestId;
    }

    public void _persistence_set_actionRequestId(String string) {
        this._persistence_checkFetchedForSet("actionRequestId");
        this.actionRequestId = string;
    }

    public Integer _persistence_get_docVersion() {
        this._persistence_checkFetched("docVersion");
        return this.docVersion;
    }

    public void _persistence_set_docVersion(Integer n) {
        this._persistence_checkFetchedForSet("docVersion");
        this.docVersion = n;
    }

    public Timestamp _persistence_get_createDate() {
        this._persistence_checkFetched("createDate");
        return this.createDate;
    }

    public void _persistence_set_createDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("createDate");
        this.createDate = timestamp;
    }

    public String _persistence_get_annotation() {
        this._persistence_checkFetched("annotation");
        return this.annotation;
    }

    public void _persistence_set_annotation(String string) {
        this._persistence_checkFetchedForSet("annotation");
        this.annotation = string;
    }

    public String _persistence_get_approvePolicy() {
        this._persistence_checkFetched("approvePolicy");
        return this.approvePolicy;
    }

    public void _persistence_set_approvePolicy(String string) {
        this._persistence_checkFetchedForSet("approvePolicy");
        this.approvePolicy = string;
    }

    public Boolean _persistence_get_currentIndicator() {
        this._persistence_checkFetched("currentIndicator");
        return this.currentIndicator;
    }

    public void _persistence_set_currentIndicator(Boolean bl) {
        this._persistence_checkFetchedForSet("currentIndicator");
        this.currentIndicator = bl;
    }

    public RouteNodeInstance _persistence_get_nodeInstance() {
        this._persistence_checkFetched("nodeInstance");
        return this.nodeInstance;
    }

    public void _persistence_set_nodeInstance(RouteNodeInstance routeNodeInstance) {
        this._persistence_checkFetchedForSet("nodeInstance");
        this.nodeInstance = routeNodeInstance;
    }

    public Integer _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(Integer n) {
        this._persistence_checkFetchedForSet("priority");
        this.priority = n;
    }

    public Integer _persistence_get_routeLevel() {
        this._persistence_checkFetched("routeLevel");
        return this.routeLevel;
    }

    public void _persistence_set_routeLevel(Integer n) {
        this._persistence_checkFetchedForSet("routeLevel");
        this.routeLevel = n;
    }

    public Boolean _persistence_get_forceAction() {
        this._persistence_checkFetched("forceAction");
        return this.forceAction;
    }

    public void _persistence_set_forceAction(Boolean bl) {
        this._persistence_checkFetchedForSet("forceAction");
        this.forceAction = bl;
    }

    public String _persistence_get_actionRequested() {
        this._persistence_checkFetched("actionRequested");
        return this.actionRequested;
    }

    public void _persistence_set_actionRequested(String string) {
        this._persistence_checkFetchedForSet("actionRequested");
        this.actionRequested = string;
    }

    public List _persistence_get_childrenRequests() {
        this._persistence_checkFetched("childrenRequests");
        return this.childrenRequests;
    }

    public void _persistence_set_childrenRequests(List list) {
        this._persistence_checkFetchedForSet("childrenRequests");
        this.childrenRequests = list;
    }

    public ActionTakenValue _persistence_get_actionTaken() {
        this._persistence_checkFetched("actionTaken");
        return this.actionTaken;
    }

    public void _persistence_set_actionTaken(ActionTakenValue actionTakenValue) {
        this._persistence_checkFetchedForSet("actionTaken");
        this.actionTaken = actionTakenValue;
    }

    public String _persistence_get_roleName() {
        this._persistence_checkFetched("roleName");
        return this.roleName;
    }

    public void _persistence_set_roleName(String string) {
        this._persistence_checkFetchedForSet("roleName");
        this.roleName = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this.documentId = string;
    }

    public String _persistence_get_requestLabel() {
        this._persistence_checkFetched("requestLabel");
        return this.requestLabel;
    }

    public void _persistence_set_requestLabel(String string) {
        this._persistence_checkFetchedForSet("requestLabel");
        this.requestLabel = string;
    }

    public String _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(String string) {
        this._persistence_checkFetchedForSet("status");
        this.status = string;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

