/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.batch;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.batch.ExternalActnListNotificationService;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class ExternalActnListNotificationServiceImpl
implements ExternalActnListNotificationService {
    private static final Logger LOG = Logger.getLogger(ExternalActnListNotificationServiceImpl.class);
    private String password;
    private String url;
    private String username;
    private int externalActnListNotificationPollIntervalSeconds = 15;
    private int externalActnListNotificationInitialDelaySeconds = 30;

    @Override
    public void run() {
        LOG.info((Object)"checking for action items that have changed.");
        Statement statement = null;
        ResultSet rs = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement(1003, 1008);
            rs = statement.executeQuery("SELECT ACTN_TYP, ACTN_ITM_ID FROM KREW_ACTN_ITM_CHANGED_T");
            while (rs.next()) {
                String actionItemId;
                String actionType = rs.getString("ACTN_TYP");
                boolean success = this.notifyExternalActionList(actionType, actionItemId = rs.getString("ACTN_ITM_ID"));
                if (!success) continue;
                rs.deleteRow();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving items from KREW_ACTN_ITM_CHANGED_T", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Could not close statement.");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Could not close result set.");
                }
            }
        }
    }

    private boolean notifyExternalActionList(String actionType, String actionItemId) {
        LOG.info((Object)("actionType: " + actionType + "   actionItemId: " + actionItemId));
        ActionItem actionItem = null;
        if (actionType.toString().equalsIgnoreCase("I") || actionType.toString().equalsIgnoreCase("U")) {
            actionItem = KEWServiceLocator.getActionListService().findByActionItemId(actionItemId);
        }
        if (actionType.toString().equalsIgnoreCase("I")) {
            LOG.info((Object)"Code to INSERT into external action list goes here");
        } else if (actionType.toString().equalsIgnoreCase("U")) {
            LOG.info((Object)"Code to UPDATE external action list goes here");
        } else if (actionType.toString().equalsIgnoreCase("D")) {
            LOG.info((Object)"Code to DELETE from external action list goes here");
        }
        return true;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public void setExternalActnListNotificationPollIntervalSeconds(int seconds) {
        this.externalActnListNotificationPollIntervalSeconds = seconds;
    }

    @Override
    public int getExternalActnListNotificationPollIntervalSeconds() {
        return this.externalActnListNotificationPollIntervalSeconds;
    }

    public void setExternalActnListNotificationInitialDelaySeconds(int seconds) {
        this.externalActnListNotificationInitialDelaySeconds = seconds;
    }

    @Override
    public int getExternalActnListNotificationInitialDelaySeconds() {
        return this.externalActnListNotificationInitialDelaySeconds;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

