/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actions.NotificationContext;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.EngineState;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.ProcessContext;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.StandardWorkflowEngine;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class BlanketApproveEngine
extends StandardWorkflowEngine {
    private static final Logger LOG = Logger.getLogger(BlanketApproveEngine.class);

    BlanketApproveEngine(RouteNodeService routeNodeService, RouteHeaderService routeHeaderService, ParameterService parameterService, OrchestrationConfig config) {
        super(routeNodeService, routeHeaderService, parameterService, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String documentId, String nodeInstanceId) throws Exception {
        if (documentId == null) {
            throw new IllegalArgumentException("Cannot process a null document id.");
        }
        MDC.put((String)"docId", (Object)documentId);
        try {
            DocumentRouteHeaderValue document;
            RouteContext context = RouteContext.createNewRouteContext();
            if (this.config.isSupressRequestsNodePolicyErrors()) {
                RequestsNode.setSuppressPolicyErrors(RouteContext.getCurrentRouteContext());
            }
            KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Processing document for Blanket Approval: " + documentId + " : " + nodeInstanceId));
            }
            if (!(document = this.getRouteHeaderService().getRouteHeader(documentId, true)).isRoutable()) {
                LOG.warn((Object)"Document not routable so returning with doing no action");
                return;
            }
            ArrayList<RouteNodeInstance> activeNodeInstances = new ArrayList<RouteNodeInstance>();
            if (nodeInstanceId == null) {
                activeNodeInstances.addAll(this.getRouteNodeService().getActiveNodeInstances(documentId));
            } else {
                RouteNodeInstance instanceNode = this.getRouteNodeService().findRouteNodeInstanceById(nodeInstanceId);
                if (instanceNode == null) {
                    throw new IllegalArgumentException("Invalid node instance id: " + nodeInstanceId);
                }
                activeNodeInstances.add(instanceNode);
            }
            List<RouteNodeInstance> nodeInstancesToProcess = this.determineNodeInstancesToProcess(activeNodeInstances, this.config.getDestinationNodeNames());
            context.setDoNotSendApproveNotificationEmails(true);
            context.setDocument(document);
            context.setEngineState(new EngineState());
            NotificationContext notifyContext = null;
            if (this.config.isSendNotifications()) {
                notifyContext = new NotificationContext("K", (PrincipalContract)this.config.getCause().getPrincipal(), this.config.getCause().getActionTaken());
            }
            this.lockAdditionalDocuments(document);
            try {
                LinkedList<ProcessEntry> processingQueue = new LinkedList<ProcessEntry>();
                for (RouteNodeInstance nodeInstancesToProcesses : nodeInstancesToProcess) {
                    processingQueue.add(new ProcessEntry(nodeInstancesToProcesses));
                }
                HashSet<String> nodesCompleted = new HashSet<String>();
                while (!processingQueue.isEmpty() && !this.isReachedDestinationNodes(this.config.getDestinationNodeNames(), nodesCompleted)) {
                    ProcessEntry entry = (ProcessEntry)processingQueue.remove(0);
                    if (entry.getTimesProcessed() > 20) {
                        throw new WorkflowException("Could not process document through to blanket approval.  Document failed to progress past node " + entry.getNodeInstance().getRouteNode().getRouteNodeName());
                    }
                    RouteNodeInstance nodeInstance = entry.getNodeInstance();
                    context.setNodeInstance(nodeInstance);
                    if (this.config.getDestinationNodeNames().contains(nodeInstance.getName())) {
                        nodesCompleted.add(nodeInstance.getName());
                        continue;
                    }
                    ProcessContext resultProcessContext = this.processNodeInstance(context, this.helper);
                    this.invokeBlanketApproval(this.config.getCause(), nodeInstance, notifyContext);
                    if (!resultProcessContext.getNextNodeInstances().isEmpty() || resultProcessContext.isComplete()) {
                        Iterator<RouteNodeInstance> nodeIt = resultProcessContext.getNextNodeInstances().iterator();
                        while (nodeIt.hasNext()) {
                            this.addToProcessingQueue(processingQueue, nodeIt.next());
                        }
                        continue;
                    }
                    entry.increment();
                    processingQueue.add(processingQueue.size(), entry);
                }
                RouteContext.clearCurrentRouteContext();
                super.process(documentId, null);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new WorkflowRuntimeException(e.toString(), (Throwable)e);
            }
        }
        finally {
            RouteContext.releaseCurrentRouteContext();
            MDC.remove((String)"docId");
        }
    }

    private boolean isReachedDestinationNodes(Set destinationNodesNames, Set<String> nodeNamesCompleted) {
        return !destinationNodesNames.isEmpty() && nodeNamesCompleted.equals(destinationNodesNames);
    }

    private void addToProcessingQueue(List<ProcessEntry> processingQueue, RouteNodeInstance nodeInstance) {
        for (ProcessEntry entry : processingQueue) {
            if (!entry.getNodeInstance().getRouteNodeInstanceId().equals(nodeInstance.getRouteNodeInstanceId())) continue;
            entry.setNodeInstance(nodeInstance);
            return;
        }
        processingQueue.add(processingQueue.size(), new ProcessEntry(nodeInstance));
    }

    private List<RouteNodeInstance> determineNodeInstancesToProcess(List<RouteNodeInstance> activeNodeInstances, Set nodeNames) throws Exception {
        if (nodeNames.isEmpty()) {
            return activeNodeInstances;
        }
        ArrayList<RouteNodeInstance> nodeInstancesToProcess = new ArrayList<RouteNodeInstance>();
        for (RouteNodeInstance nodeInstance : activeNodeInstances) {
            if (!this.isNodeNameInPath(nodeNames, nodeInstance)) continue;
            nodeInstancesToProcess.add(nodeInstance);
        }
        if (nodeInstancesToProcess.size() == 0) {
            throw new InvalidActionTakenException("Could not locate nodes with the given names in the blanket approval path '" + this.printNodeNames(nodeNames) + "'.  " + "The document is probably already passed the specified nodes or does not contain the nodes.");
        }
        return nodeInstancesToProcess;
    }

    private boolean isNodeNameInPath(Set nodeNames, RouteNodeInstance nodeInstance) throws Exception {
        boolean isInPath = false;
        for (Object nodeName1 : nodeNames) {
            String nodeName = (String)nodeName1;
            for (RouteNode nextNode : nodeInstance.getRouteNode().getNextNodes()) {
                isInPath = isInPath || this.isNodeNameInPath(nodeName, nextNode, new HashSet<String>());
            }
        }
        return isInPath;
    }

    private boolean isNodeNameInPath(String nodeName, RouteNode node, Set<String> inspected) throws Exception {
        ProcessDefinitionBo subProcess;
        RouteNode subNode;
        boolean isInPath = !inspected.contains(node.getRouteNodeId()) && node.getRouteNodeName().equals(nodeName);
        inspected.add(node.getRouteNodeId());
        if (this.helper.isSubProcessNode(node) && (subNode = (subProcess = node.getDocumentType().getNamedProcess(node.getRouteNodeName())).getInitialRouteNode()) != null) {
            isInPath = isInPath || this.isNodeNameInPath(nodeName, subNode, inspected);
        }
        for (RouteNode nextNode : node.getNextNodes()) {
            isInPath = isInPath || this.isNodeNameInPath(nodeName, nextNode, inspected);
        }
        return isInPath;
    }

    private String printNodeNames(Set nodesNames) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = nodesNames.iterator();
        while (iterator.hasNext()) {
            String nodeName = (String)iterator.next();
            buffer.append(nodeName);
            buffer.append(iterator.hasNext() ? ", " : "");
        }
        return buffer.toString();
    }

    private void invokeBlanketApproval(ActionTakenValue actionTaken, RouteNodeInstance nodeInstance, NotificationContext notifyContext) {
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(nodeInstance.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
        actionRequests = this.getActionRequestService().getRootRequests(actionRequests);
        ArrayList<ActionRequestValue> requestsToNotify = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue request : actionRequests) {
            if (request.isApproveOrCompleteRequest()) {
                requestsToNotify.add(this.getActionRequestService().deactivateRequest(actionTaken, request));
            }
            if (request.isAcknowledgeRequest() && this.config.isDeactivateAcknowledgements()) {
                this.getActionRequestService().deactivateRequest(actionTaken, request);
            }
            if (!request.isFYIRequest() || !this.config.isDeactivateFYIs()) continue;
            this.getActionRequestService().deactivateRequest(actionTaken, request);
        }
        if (notifyContext != null && !requestsToNotify.isEmpty()) {
            ActionRequestFactory arFactory = new ActionRequestFactory(RouteContext.getCurrentRouteContext().getDocument(), nodeInstance);
            KimPrincipalRecipient delegatorRecipient = null;
            if (actionTaken.getDelegatorPrincipal() != null) {
                delegatorRecipient = new KimPrincipalRecipient((PrincipalContract)actionTaken.getDelegatorPrincipal());
            }
            List<ActionRequestValue> notificationRequests = arFactory.generateNotifications(requestsToNotify, notifyContext.getPrincipalTakingAction(), delegatorRecipient, notifyContext.getNotificationRequestCode(), notifyContext.getActionTakenCode());
            this.getActionRequestService().activateRequests(notificationRequests);
        }
    }

    private ActionRequestService getActionRequestService() {
        return KEWServiceLocator.getActionRequestService();
    }

    private class ProcessEntry {
        private RouteNodeInstance nodeInstance;
        private int timesProcessed = 0;

        public ProcessEntry(RouteNodeInstance nodeInstance) {
            this.nodeInstance = nodeInstance;
        }

        public RouteNodeInstance getNodeInstance() {
            return this.nodeInstance;
        }

        public void setNodeInstance(RouteNodeInstance nodeInstance) {
            this.nodeInstance = nodeInstance;
        }

        public void increment() {
            ++this.timesProcessed;
        }

        public int getTimesProcessed() {
            return this.timesProcessed;
        }
    }
}

