/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.stuck;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.RuntimeConfig;
import org.kuali.rice.core.api.config.property.RuntimeConfigSet;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.kew.impl.stuck.StuckDocument;
import org.kuali.rice.kew.impl.stuck.StuckDocumentFixAttempt;
import org.kuali.rice.kew.impl.stuck.StuckDocumentIncident;
import org.kuali.rice.kew.impl.stuck.StuckDocumentNotifier;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class StuckDocumentNotifierImpl
implements StuckDocumentNotifier,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(StuckDocumentNotifierImpl.class);
    private static final String NOTIFICATION_SUBJECT_TEMPLATE_NAME = "notificationSubject";
    private static final String NOTIFICATION_EMAIL_TEMPLATE_NAME = "notificationEmail";
    private static final String AUTOFIX_SUBJECT_TEMPLATE_NAME = "autofixSubject";
    private static final String AUTOFIX_EMAIL_TEMPLATE_NAME = "autofixEmail";
    private static final String NOTIFICATION_EMAIL_TEMPLATE = "${numStuckDocuments} stuck documents have been identified within the workflow system:\n\nDocument ID, Document Type, Create Date\n---------------------------------------\n<#list stuckDocuments as stuckDocument>${stuckDocument.documentId}, ${stuckDocument.documentTypeLabel}, ${stuckDocument.createDate}\n</#list>";
    private static final String AUTOFIX_EMAIL_TEMPLATE = "Failed to autofix document ${documentId}, ${documentTypeLabel}.\n\nIncident details:\n\tStarted: ${startDate}\n\tEnded: ${endDate}\n\nAttempts occurred at the following times: <#list autofixAttempts as autofixAttempt>\n\t${autofixAttempt.timestamp}</#list>";
    private static final String FAILURE_EMAIL_SUBJECT_TEMPLATE = "Failed to autofix stuck document with ID {0}";
    private RuntimeConfig from;
    private RuntimeConfig to;
    private RuntimeConfig subject;
    private RuntimeConfig autofixSubject;
    private Configuration freemarkerConfig;
    private StringTemplateLoader templateLoader;
    private Mailer mailer;

    public void afterPropertiesSet() {
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_25);
        this.templateLoader = new StringTemplateLoader();
        this.freemarkerConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
        this.updateTemplates();
        new RuntimeConfigSet(new RuntimeConfig[]{this.subject, this.autofixSubject}).listen(runtimeConfigSet -> this.updateTemplates());
    }

    private void updateTemplates() {
        this.templateLoader.putTemplate(NOTIFICATION_SUBJECT_TEMPLATE_NAME, this.subject.getValue());
        this.templateLoader.putTemplate(NOTIFICATION_EMAIL_TEMPLATE_NAME, NOTIFICATION_EMAIL_TEMPLATE);
        this.templateLoader.putTemplate(AUTOFIX_SUBJECT_TEMPLATE_NAME, this.autofixSubject.getValue());
        this.templateLoader.putTemplate(AUTOFIX_EMAIL_TEMPLATE_NAME, AUTOFIX_EMAIL_TEMPLATE);
        this.freemarkerConfig.clearTemplateCache();
    }

    @Override
    public void notify(List<StuckDocument> stuckDocuments) {
        if (!stuckDocuments.isEmpty()) {
            Map<String, Object> dataModel = this.buildNotificationTemplateDataModel(stuckDocuments);
            String subject = this.processTemplate(NOTIFICATION_SUBJECT_TEMPLATE_NAME, dataModel);
            String body = this.processTemplate(NOTIFICATION_EMAIL_TEMPLATE_NAME, dataModel);
            this.send(subject, body);
        }
    }

    private Map<String, Object> buildNotificationTemplateDataModel(List<StuckDocument> stuckDocuments) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("numStuckDocuments", stuckDocuments.size());
        dataModel.put("stuckDocuments", stuckDocuments);
        this.addGlobalDataModel(dataModel);
        return dataModel;
    }

    @Override
    public void notifyIncidentFailure(StuckDocumentIncident incident, List<StuckDocumentFixAttempt> attempts) {
        Map<String, Object> dataModel = this.buildIncidentFailureTemplateDataModel(incident, attempts);
        String subject = this.processTemplate(AUTOFIX_SUBJECT_TEMPLATE_NAME, dataModel);
        String body = this.processTemplate(AUTOFIX_EMAIL_TEMPLATE_NAME, dataModel);
        this.send(subject, body);
    }

    private Map<String, Object> buildIncidentFailureTemplateDataModel(StuckDocumentIncident incident, List<StuckDocumentFixAttempt> attempts) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("documentId", incident.getDocumentId());
        dataModel.put("documentTypeLabel", this.resolveDocumentTypeLabel(incident.getDocumentId()));
        dataModel.put("startDate", incident.getStartDate());
        dataModel.put("endDate", incident.getEndDate());
        dataModel.put("numberOfAutofixAttempts", attempts.size());
        dataModel.put("autofixAttempts", attempts);
        this.addGlobalDataModel(dataModel);
        return dataModel;
    }

    private void addGlobalDataModel(Map<String, Object> dataModel) {
        dataModel.put("environment", ConfigContext.getCurrentContextConfig().getEnvironment());
        dataModel.put("applicationUrl", ConfigContext.getCurrentContextConfig().getProperty("application.url"));
    }

    private String processTemplate(String templateName, Object dataModel) {
        try {
            StringWriter writer = new StringWriter();
            Template template = this.freemarkerConfig.getTemplate(templateName);
            template.process(dataModel, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalStateException("Failed to execute template " + templateName, e);
        }
    }

    private String resolveDocumentTypeLabel(String documentId) {
        return KEWServiceLocator.getDocumentTypeService().findByDocumentId(documentId).getLabel();
    }

    private void send(String messageBody) {
        this.send(this.subject.getValue(), messageBody);
    }

    private void send(String subject, String messageBody) {
        if (this.checkCanSend()) {
            MailMessage message = new MailMessage();
            message.setFromAddress(this.from.getValue());
            message.setToAddresses(Collections.singleton(this.to.getValue()));
            message.setSubject(subject);
            message.setMessage(messageBody);
            try {
                this.mailer.sendEmail(message);
            }
            catch (Exception e) {
                LOG.error("Failed to send stuck document notification email with the body:\n" + messageBody, (Throwable)e);
            }
        }
    }

    private boolean checkCanSend() {
        boolean canSend = true;
        if (StringUtils.isBlank((String)this.from.getValue())) {
            LOG.error("Cannot send stuck documentation notification because no 'from' address is configured.");
            canSend = false;
        }
        if (StringUtils.isBlank((String)this.to.getValue())) {
            LOG.error("Cannot send stuck documentation notification because no 'to' address is configured.");
            canSend = false;
        }
        return canSend;
    }

    @Required
    public void setFrom(RuntimeConfig from) {
        this.from = from;
    }

    @Required
    public void setTo(RuntimeConfig to) {
        this.to = to;
    }

    @Required
    public void setSubject(RuntimeConfig subject) {
        this.subject = subject;
    }

    @Required
    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    @Required
    public void setAutofixSubject(RuntimeConfig autofixSubject) {
        this.autofixSubject = autofixSubject;
    }
}

