/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.lifecycle;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.kew.batch.XmlPollerService;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class XmlPipelineLifeCycle
extends BaseLifecycle {
    protected final Logger LOG = Logger.getLogger(XmlPipelineLifeCycle.class);
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture future;

    public void start() throws Exception {
        this.LOG.info((Object)"Configuring XML ingestion pipeline...");
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        XmlPollerService xmlPoller = KEWServiceLocator.getXmlPollerService();
        this.LOG.info((Object)("Starting XML data loader.  Polling at " + xmlPoller.getPollIntervalSecs() + "-second intervals"));
        if (!ConfigContext.getCurrentContextConfig().getDevMode().booleanValue()) {
            this.future = this.scheduledExecutor.scheduleWithFixedDelay(xmlPoller, xmlPoller.getInitialDelaySecs(), xmlPoller.getPollIntervalSecs(), TimeUnit.SECONDS);
            super.start();
        }
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            this.LOG.warn((Object)"Shutting down XML file polling timer");
            try {
                if (this.future != null) {
                    if (!this.future.cancel(false)) {
                        this.LOG.warn((Object)"Failed to cancel the XML Poller service.");
                    }
                    this.future = null;
                }
                if (this.scheduledExecutor != null) {
                    this.scheduledExecutor.shutdownNow();
                    this.scheduledExecutor = null;
                }
            }
            finally {
                super.stop();
            }
        }
    }
}

