/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.impl.config.property.ConfigParserImplConfig;

public class PluginConfig
extends ConfigParserImplConfig {
    private String resourceLoaderClassname;
    private List listeners = new ArrayList();
    private Properties parentProperties;
    private Map parentObjects;
    private Config parentConfig;

    public PluginConfig(URL url, Config parentConfig) {
        super(url.toString());
        this.parentProperties = parentConfig.getProperties();
        this.parentObjects = parentConfig.getObjects();
        this.parentConfig = parentConfig;
    }

    public PluginConfig(File configFile, Config parentConfig) throws MalformedURLException {
        this(configFile.toURI().toURL(), parentConfig);
    }

    public Properties getBaseProperties() {
        return this.parentProperties;
    }

    public Map getBaseObjects() {
        return this.parentObjects;
    }

    public void addListener(String listenerClass) {
        this.listeners.add(listenerClass);
    }

    public List getListeners() {
        return this.listeners;
    }

    public void setResourceLoaderClassname(String resourceLoaderClassname) {
        this.resourceLoaderClassname = resourceLoaderClassname;
    }

    public String getResourceLoaderClassname() {
        return this.resourceLoaderClassname;
    }

    public String toString() {
        return "[PluginConfig: resourceLoaderClassname: " + this.getResourceLoaderClassname() + "]";
    }

    public Object getObject(String key) {
        Object object = super.getObject(key);
        if (object == null && this.parentConfig != null) {
            object = this.parentConfig.getObject(key);
        }
        return object;
    }

    public Map<String, Object> getObjects() {
        HashMap<String, Object> finalObjects = new HashMap<String, Object>(super.getObjects());
        if (this.parentConfig != null) {
            Map parentObjects = this.parentConfig.getObjects();
            for (String key : parentObjects.keySet()) {
                if (finalObjects.containsKey(key)) continue;
                finalObjects.put(key, parentObjects.get(key));
            }
        }
        return finalObjects;
    }
}

