/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public final class CompositeBeanFactory
implements BeanFactory {
    private static final Log LOG = LogFactory.getLog(CompositeBeanFactory.class);
    private final Collection<BeanFactory> factories;

    public static BeanFactory createBeanFactory(Collection<? extends SpringResourceLoader> rls) {
        if (rls == null || rls.isEmpty()) {
            throw new IllegalArgumentException("rls is null or empty");
        }
        ArrayList<ConfigurableApplicationContext> bfs = new ArrayList<ConfigurableApplicationContext>();
        for (SpringResourceLoader springResourceLoader : rls) {
            bfs.add(springResourceLoader.getContext());
        }
        return new CompositeBeanFactory(bfs);
    }

    public CompositeBeanFactory(Collection<? extends BeanFactory> factories) {
        if (factories == null || factories.isEmpty()) {
            throw new IllegalArgumentException("factories is null or empty");
        }
        this.factories = new ArrayList<BeanFactory>(factories);
    }

    public Object getBean(String name) throws BeansException {
        for (BeanFactory f : this.factories) {
            try {
                Object o = f.getBean(name);
                if (o == null) continue;
                return o;
            }
            catch (BeansException e) {
                LOG.debug((Object)"bean exception", (Throwable)e);
            }
        }
        return null;
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        for (BeanFactory f : this.factories) {
            try {
                Object t = f.getBean(name, requiredType);
                if (t == null) continue;
                return (T)t;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return null;
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        for (BeanFactory f : this.factories) {
            try {
                Object t = f.getBean(requiredType);
                if (t == null) continue;
                return (T)t;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return null;
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        for (BeanFactory f : this.factories) {
            try {
                Object o = f.getBean(name, args);
                if (o == null) continue;
                return o;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return null;
    }

    public boolean containsBean(String name) {
        for (BeanFactory f : this.factories) {
            try {
                boolean b = f.containsBean(name);
                if (!b) continue;
                return b;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        for (BeanFactory f : this.factories) {
            try {
                boolean b = f.isSingleton(name);
                if (!b) continue;
                return b;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        for (BeanFactory f : this.factories) {
            try {
                boolean b = f.isPrototype(name);
                if (!b) continue;
                return b;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        for (BeanFactory f : this.factories) {
            try {
                boolean b = f.isTypeMatch(name, targetType);
                if (!b) continue;
                return b;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return false;
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        for (BeanFactory f : this.factories) {
            try {
                Class c = f.getType(name);
                if (c == null) continue;
                return c;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return null;
    }

    public String[] getAliases(String name) {
        for (BeanFactory f : this.factories) {
            try {
                String[] s = f.getAliases(name);
                if (s == null) continue;
                return s;
            }
            catch (BeansException e) {
                LOG.info((Object)"bean exception", (Throwable)e);
            }
        }
        return null;
    }
}

