/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SQLDataLoader {
    private static final Logger LOG = Logger.getLogger(SQLDataLoader.class);
    public static final String SQL_LINE_COMMENT_PREFIX = "--";
    private String fileLoc;
    private String seperatorChar;
    private String statement;

    public SQLDataLoader(String statement) {
        this.fileLoc = null;
        this.seperatorChar = null;
        this.statement = statement;
    }

    public SQLDataLoader(String fileLoc, String seperatorChar) {
        this.fileLoc = fileLoc;
        this.seperatorChar = seperatorChar;
        this.statement = null;
    }

    public void runSql() throws Exception {
        String[] sqlStatements = null;
        if (this.statement == null) {
            String sqlStatementsContent = this.getContentsAsString(this.fileLoc);
            sqlStatements = sqlStatementsContent.split("(?m)" + this.getSeperatorChar() + "\\s*$");
        } else {
            sqlStatements = new String[]{this.statement};
        }
        final String[] finalSqlStatements = sqlStatements;
        new TransactionTemplate((PlatformTransactionManager)TestHarnessServiceLocator.getJtaTransactionManager()).execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return new JdbcTemplate(TestHarnessServiceLocator.getDataSource()).execute(new ConnectionCallback(){

                    public Object doInConnection(Connection connection) throws SQLException {
                        Statement statement = connection.createStatement();
                        LOG.info((Object)"################################");
                        LOG.info((Object)(SQLDataLoader.this.fileLoc != null ? "#" + SQLDataLoader.this.fileLoc : "#"));
                        LOG.info((Object)"#");
                        for (String sqlStatement : finalSqlStatements) {
                            if (!StringUtils.isNotBlank((String)sqlStatement)) continue;
                            LOG.info((Object)("# Executing sql statement ->" + sqlStatement + "<-"));
                            statement.execute(sqlStatement);
                        }
                        LOG.info((Object)"#");
                        LOG.info((Object)"#");
                        LOG.info((Object)"################################");
                        statement.close();
                        return null;
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentsAsString(String fileLoc) throws Exception {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        String data = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(resourceLoader.getResource(fileLoc).getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith(SQL_LINE_COMMENT_PREFIX)) continue;
                data = data + line + "\r\n ";
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
        }
        return data;
    }

    public String getSeperatorChar() {
        if (this.seperatorChar == null) {
            return ";";
        }
        return this.seperatorChar;
    }
}

