/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.test.BaseRiceTestCase;
import org.kuali.rice.test.ClearDatabaseLifecycle;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.kuali.rice.test.TestUtilities;
import org.kuali.rice.test.ThreadMonitor;
import org.kuali.rice.test.data.PerSuiteUnitTestData;
import org.kuali.rice.test.lifecycles.PerSuiteDataLoaderLifecycle;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;

public abstract class RiceTestCase
extends BaseRiceTestCase {
    protected static final Logger LOG = Logger.getLogger(RiceTestCase.class);
    private static final String ALT_LOG4J_CONFIG_LOCATION_PROP = "alt.log4j.config.location";
    private static final String DEFAULT_LOG4J_CONFIG = "classpath:rice-testharness-default-log4j.properties";
    protected static final String DEFAULT_TEST_HARNESS_SPRING_BEANS = "classpath:TestHarnessSpringBeans.xml";
    protected static boolean SUITE_LIFE_CYCLES_RAN = false;
    protected static boolean SUITE_LIFE_CYCLES_FAILED = false;
    protected static String failedSuiteTestName;
    protected List<Lifecycle> perTestLifeCycles = new LinkedList<Lifecycle>();
    protected List<Lifecycle> suiteLifeCycles = new LinkedList<Lifecycle>();
    private static Set<String> perSuiteDataLoaderLifecycleNamesRun;
    private List<String> reports = new ArrayList<String>();
    private SpringResourceLoader testHarnessSpringResourceLoader;
    private boolean clearTables = true;
    private long testStart;
    private long testEnd;

    @Override
    @Before
    public void setUp() throws Exception {
        this.testStart = System.currentTimeMillis();
        try {
            this.configureLogging();
            this.logBeforeRun();
            long initTime = System.currentTimeMillis();
            this.setUpInternal();
            this.report("Time to start all Lifecycles: " + (System.currentTimeMillis() - initTime));
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.tearDown();
            throw new RuntimeException(e);
        }
    }

    protected void setUpInternal() throws Exception {
        Assert.assertNotNull((Object)this.getModuleName());
        this.setModuleName(this.getModuleName());
        this.setBaseDirSystemProperty(this.getModuleName());
        this.perTestLifeCycles = this.getPerTestLifecycles();
        this.suiteLifeCycles = this.getSuiteLifecycles();
        if (SUITE_LIFE_CYCLES_FAILED) {
            Assert.fail((String)("Suite Lifecycles startup failed on test " + failedSuiteTestName + "!!!  Please see logs for details."));
        }
        if (!SUITE_LIFE_CYCLES_RAN) {
            try {
                this.startLifecycles(this.suiteLifeCycles);
                SUITE_LIFE_CYCLES_RAN = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                SUITE_LIFE_CYCLES_RAN = false;
                SUITE_LIFE_CYCLES_FAILED = true;
                failedSuiteTestName = this.getFullTestName();
                this.tearDown();
                this.stopLifecycles(this.suiteLifeCycles);
                throw new RuntimeException(e);
            }
        }
        this.startSuiteDataLoaderLifecycles();
        this.startLifecycles(this.perTestLifeCycles);
    }

    protected void startSuiteDataLoaderLifecycles() throws Exception {
        List<Class> classes = TestUtilities.getHierarchyClassesToHandle(this.getClass(), new Class[]{PerSuiteUnitTestData.class}, perSuiteDataLoaderLifecycleNamesRun);
        for (Class c : classes) {
            new PerSuiteDataLoaderLifecycle(c).start();
            perSuiteDataLoaderLifecycleNamesRun.add(c.getName());
        }
    }

    protected void setBaseDirSystemProperty(String moduleBaseDir) {
        if (System.getProperty("basedir") == null) {
            String userDir = System.getProperty("user.dir");
            System.setProperty("basedir", userDir + (userDir.endsWith(File.separator + "it" + File.separator + moduleBaseDir) ? "" : File.separator + "it" + File.separator + moduleBaseDir));
        }
    }

    protected String getUserDir() {
        return System.getProperty("user.dir");
    }

    protected void setModuleName(String moduleName) {
        if (System.getProperty("module.name") == null) {
            System.setProperty("module.name", moduleName);
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ThreadMonitor.tearDown(60000L);
        try {
            this.stopLifecycles(this.perTestLifeCycles);
        }
        catch (BeanCreationNotAllowedException bcnae) {
            LOG.warn((Object)("BeanCreationNotAllowedException during stopLifecycles during tearDown " + bcnae.getMessage()));
        }
        this.testEnd = System.currentTimeMillis();
        this.report("Total time to run test: " + (this.testEnd - this.testStart));
        this.logAfterRun();
    }

    protected void logBeforeRun() {
        LOG.info((Object)"##############################################################");
        LOG.info((Object)("# Starting test " + this.getFullTestName() + "..."));
        LOG.info((Object)("# " + this.dumpMemory()));
        LOG.info((Object)"##############################################################");
    }

    protected void logAfterRun() {
        LOG.info((Object)"##############################################################");
        LOG.info((Object)("# ...finished test " + this.getFullTestName()));
        LOG.info((Object)("# " + this.dumpMemory()));
        for (String report : this.reports) {
            LOG.info((Object)("# " + report));
        }
        LOG.info((Object)"##############################################################\n\n\n");
    }

    protected String getFullTestName() {
        return this.getClass().getSimpleName() + "." + this.getName();
    }

    protected void configureLogging() throws IOException {
        FileSystemResourceLoader resourceLoader = new FileSystemResourceLoader();
        String altLog4jConfigLocation = System.getProperty(ALT_LOG4J_CONFIG_LOCATION_PROP);
        Resource log4jConfigResource = null;
        if (!StringUtils.isEmpty((String)altLog4jConfigLocation)) {
            log4jConfigResource = resourceLoader.getResource(altLog4jConfigLocation);
        }
        if (log4jConfigResource == null || !log4jConfigResource.exists()) {
            System.out.println("Alternate Log4j config resource does not exist! " + altLog4jConfigLocation);
            System.out.println("Using default log4j configuration: classpath:rice-testharness-default-log4j.properties");
            log4jConfigResource = resourceLoader.getResource(DEFAULT_LOG4J_CONFIG);
        } else {
            System.out.println("Using alternate log4j configuration at: " + altLog4jConfigLocation);
        }
        Properties p = new Properties();
        p.load(log4jConfigResource.getInputStream());
        PropertyConfigurator.configure((Properties)p);
    }

    protected void startLifecycles(List<Lifecycle> lifecycles) throws Exception {
        for (Lifecycle lifecycle : lifecycles) {
            lifecycle.start();
        }
    }

    protected void stopLifecycles(List<Lifecycle> lifecycles) throws Exception {
        int lifecyclesSize;
        for (int i = lifecyclesSize = lifecycles.size() - 1; i >= 0; --i) {
            try {
                if (lifecycles.get(i) == null) {
                    LOG.warn((Object)"Attempted to stop a null lifecycle");
                    continue;
                }
                if (!lifecycles.get(i).isStarted()) continue;
                LOG.warn((Object)("Attempting to stop a lifecycle " + lifecycles.get(i).getClass()));
                lifecycles.get(i).stop();
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to shutdown one of the lifecycles!", (Throwable)e);
            }
        }
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        LinkedList<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                Config config = RiceTestCase.this.getTestHarnessConfig();
                ConfigContext.init((Config)config);
                super.start();
            }
        });
        lifecycles.add((Lifecycle)this.getTestHarnessSpringResourceLoader());
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                TestHarnessServiceLocator.setContext(RiceTestCase.this.getTestHarnessSpringResourceLoader().getContext());
                super.start();
            }
        });
        if (this.clearTables) {
            lifecycles.add((Lifecycle)new ClearDatabaseLifecycle());
        }
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                RiceTestCase.this.loadSuiteTestData();
                super.start();
            }
        });
        Lifecycle loadApplicationLifecycle = this.getLoadApplicationLifecycle();
        if (loadApplicationLifecycle != null) {
            lifecycles.add(loadApplicationLifecycle);
        }
        return lifecycles;
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        return null;
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        LinkedList<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
        lifecycles.add(this.getPerTestDataLoaderLifecycle());
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                RiceTestCase.this.loadPerTestData();
                super.start();
            }
        });
        return lifecycles;
    }

    protected void loadSuiteTestData() throws Exception {
    }

    protected void loadPerTestData() throws Exception {
    }

    protected void report(String report) {
        this.reports.add(report);
    }

    protected String dumpMemory() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long max = Runtime.getRuntime().maxMemory();
        return "[Memory] max: " + max + ", total: " + total + ", free: " + free;
    }

    public SpringResourceLoader getTestHarnessSpringResourceLoader() {
        if (this.testHarnessSpringResourceLoader == null) {
            this.testHarnessSpringResourceLoader = new SpringResourceLoader(new QName("TestHarnessSpringContext"), this.getTestHarnessSpringBeansLocation(), null);
        }
        return this.testHarnessSpringResourceLoader;
    }

    protected List<String> getTestHarnessSpringBeansLocation() {
        return Collections.singletonList(DEFAULT_TEST_HARNESS_SPRING_BEANS);
    }

    protected Config getTestHarnessConfig() throws Exception {
        JAXBConfigImpl config = new JAXBConfigImpl(this.getConfigLocations(), System.getProperties());
        config.parseConfig();
        return config;
    }

    protected List<String> getConfigLocations() {
        ArrayList<String> configLocations = new ArrayList<String>();
        configLocations.add(this.getRiceMasterDefaultConfigFile());
        configLocations.add(this.getModuleTestConfigLocation());
        return configLocations;
    }

    protected String getModuleTestConfigLocation() {
        return "classpath:META-INF/" + this.getModuleName().toLowerCase() + "-test-config.xml";
    }

    protected String getRiceMasterDefaultConfigFile() {
        return "classpath:META-INF/test-config-defaults.xml";
    }

    protected abstract String getModuleName();

    protected void setClearTables(boolean clearTables) {
        this.clearTables = clearTables;
    }

    static {
        perSuiteDataLoaderLifecycleNamesRun = new HashSet<String>();
    }
}

