/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.dao;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kcb.bo.RecipientPreference;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class RecipientPreferenceDaoTest
extends KCBTestCase {
    private String[] recipientIds = new String[]{"unit_test_recip1", "unit_test_recip2"};
    private String[] propertys = new String[]{"Property A", "Property B"};
    private String[] values = new String[]{"Value A", "Value B"};
    private String[] updatedValues = new String[]{"Value C", "Value D"};

    @Test
    public void testCreate() {
        RecipientPreference pref1 = this.createRecipientPreference(0);
        Assert.assertNotNull((Object)pref1.getId());
        RecipientPreference pref2 = this.createRecipientPreference(1);
        Assert.assertNotNull((Object)pref2.getId());
    }

    @Test
    public void testFind() {
        RecipientPreference pref1 = this.createRecipientPreference(0);
        RecipientPreference pref2 = this.createRecipientPreference(1);
        QueryByCriteria.Builder criteria1 = QueryByCriteria.Builder.create();
        criteria1.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)this.recipientIds[0]), PredicateFactory.equal((String)"property", (Object)this.propertys[0])});
        List prefs1 = this.getDataObjectService().findMatching(RecipientPreference.class, criteria1.build()).getResults();
        Assert.assertNotNull((Object)pref1);
        Assert.assertEquals((long)prefs1.size(), (long)1L);
        pref1 = (RecipientPreference)prefs1.get(0);
        Assert.assertNotNull((Object)pref1);
        Assert.assertEquals((Object)this.recipientIds[0], (Object)pref1.getRecipientId());
        QueryByCriteria.Builder criteria2 = QueryByCriteria.Builder.create();
        criteria2.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)this.recipientIds[1]), PredicateFactory.equal((String)"property", (Object)this.propertys[1])});
        List prefs2 = this.getDataObjectService().findMatching(RecipientPreference.class, criteria2.build()).getResults();
        Assert.assertNotNull((Object)pref2);
        Assert.assertEquals((long)prefs2.size(), (long)1L);
        pref2 = (RecipientPreference)prefs2.get(0);
        Assert.assertNotNull((Object)pref2);
        Assert.assertEquals((Object)this.recipientIds[1], (Object)pref2.getRecipientId());
    }

    @Test
    public void testUpdate() {
        RecipientPreference pref1 = this.createRecipientPreference(0);
        RecipientPreference pref2 = this.createRecipientPreference(1);
        pref1.setValue(this.updatedValues[0]);
        pref2.setValue(this.updatedValues[1]);
        pref1 = (RecipientPreference)KRADServiceLocator.getDataObjectService().save((Object)pref1, new PersistenceOption[]{PersistenceOption.FLUSH});
        pref2 = (RecipientPreference)KRADServiceLocator.getDataObjectService().save((Object)pref2, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertEquals((Object)this.updatedValues[0], (Object)pref1.getValue());
        Assert.assertEquals((Object)this.updatedValues[1], (Object)pref2.getValue());
    }

    @Test
    public void testDelete() {
        RecipientPreference pref1 = this.createRecipientPreference(0);
        RecipientPreference pref2 = this.createRecipientPreference(1);
        KRADServiceLocator.getDataObjectService().delete((Object)pref1);
        KRADServiceLocator.getDataObjectService().delete((Object)pref2);
        Assert.assertEquals((long)0L, (long)this.getDataObjectService().findAll(RecipientPreference.class).getResults().size());
    }

    private RecipientPreference createRecipientPreference(int index) {
        RecipientPreference recipientPreference = new RecipientPreference();
        recipientPreference.setRecipientId(this.recipientIds[index]);
        recipientPreference.setProperty(this.propertys[index]);
        recipientPreference.setValue(this.values[index]);
        return (RecipientPreference)this.getDataObjectService().save((Object)recipientPreference, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }
}

