/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.dao.BusinessObjectDaoTestCaseBase;
import org.kuali.rice.ken.test.TestConstants;
import org.springframework.dao.DataAccessException;

public class BusinessObjectDaoTest
extends BusinessObjectDaoTestCaseBase {
    private static final Map<Long, NotificationProducerBo> producers = new HashMap<Long, NotificationProducerBo>();
    private static final NotificationProducerBo[] producerOrder;

    @Test
    public void testFindByPrimaryKey() {
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", TestConstants.PRODUCER_2.getId());
        NotificationProducerBo notificationProducer = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertEquals((long)TestConstants.PRODUCER_2.getId(), (long)notificationProducer.getId());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getName(), (Object)notificationProducer.getName());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getDescription(), (Object)notificationProducer.getDescription());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getContactInfo(), (Object)notificationProducer.getContactInfo());
    }

    @Test
    public void testFindByUniqueKey() {
        HashMap<String, String> uniqueKeys = new HashMap<String, String>();
        uniqueKeys.put("name", TestConstants.PRODUCER_2.getName());
        NotificationProducerBo notificationProducer = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, uniqueKeys);
        Assert.assertEquals((long)TestConstants.PRODUCER_2.getId(), (long)notificationProducer.getId());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getName(), (Object)notificationProducer.getName());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getDescription(), (Object)notificationProducer.getDescription());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getContactInfo(), (Object)notificationProducer.getContactInfo());
    }

    @Test
    public void testFindAll() {
        Collection notificationProducers = this.businessObjectDao.findAll(NotificationProducerBo.class);
        Assert.assertEquals((long)5L, (long)notificationProducers.size());
    }

    @Test
    public void testFindAllOrderBy() {
        Collection notificationProducers = this.businessObjectDao.findAllOrderBy(NotificationProducerBo.class, "id", true);
        Assert.assertEquals((long)5L, (long)notificationProducers.size());
        notificationProducers = this.businessObjectDao.findAllOrderBy(NotificationProducerBo.class, "id", false);
        Assert.assertEquals((long)5L, (long)notificationProducers.size());
    }

    @Test
    public void testFindMatching() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("contactInfo", TestConstants.PRODUCER_1.getContactInfo());
        Collection notificationProducers = this.businessObjectDao.findMatching(NotificationProducerBo.class, fieldValues);
        Assert.assertEquals((long)2L, (long)notificationProducers.size());
        for (NotificationProducerBo producer : notificationProducers) {
            NotificationProducerBo expected = producers.get(producer.getId());
            Assert.assertEquals((Object)expected.getName(), (Object)producer.getName());
            Assert.assertEquals((Object)expected.getDescription(), (Object)producer.getDescription());
            Assert.assertEquals((Object)expected.getContactInfo(), (Object)producer.getContactInfo());
        }
    }

    @Test
    public void testCountMatchingClassMap() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("contactInfo", "producer_1_and_2@127.0.0.1");
        Assert.assertEquals((long)2L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
        fieldValues = new HashMap();
        fieldValues.put("contactInfo", "producer_3@127.0.0.1");
        Assert.assertEquals((long)1L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
        fieldValues = new HashMap();
        fieldValues.put("id", TestConstants.PRODUCER_2.getId());
        Assert.assertEquals((long)1L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
        fieldValues = new HashMap();
        fieldValues.put("description", "xxxx");
        Assert.assertEquals((long)0L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
    }

    @Test
    public void testCountMatchingClassMapMap() {
        HashMap<String, String> positiveFieldValues = new HashMap<String, String>();
        positiveFieldValues.put("contactInfo", TestConstants.PRODUCER_1.getContactInfo());
        HashMap<String, Long> negativeFieldValues = new HashMap<String, Long>();
        negativeFieldValues.put("id", TestConstants.PRODUCER_2.getId());
        Assert.assertEquals((long)1L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, positiveFieldValues, negativeFieldValues));
        positiveFieldValues = new HashMap();
        positiveFieldValues.put("contactInfo", TestConstants.PRODUCER_3.getContactInfo());
        negativeFieldValues = new HashMap();
        negativeFieldValues.put("id", TestConstants.PRODUCER_3.getId());
        Assert.assertEquals((long)0L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, positiveFieldValues, negativeFieldValues));
        positiveFieldValues = new HashMap();
        positiveFieldValues.put("contactInfo", TestConstants.PRODUCER_3.getContactInfo());
        negativeFieldValues = new HashMap();
        negativeFieldValues.put("id", TestConstants.PRODUCER_2.getId());
        Assert.assertEquals((long)1L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, positiveFieldValues, negativeFieldValues));
    }

    @Test
    public void testFindMatchingOrderBy() {
        long id;
        NotificationProducerBo expected;
        NotificationProducerBo producer;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("contactInfo", "producer_1_and_2@127.0.0.1");
        Collection notificationProducers = this.businessObjectDao.findMatchingOrderBy(NotificationProducerBo.class, fieldValues, "id", true);
        Assert.assertEquals((long)2L, (long)notificationProducers.size());
        Iterator it = notificationProducers.iterator();
        int i = 1;
        while (it.hasNext()) {
            producer = (NotificationProducerBo)it.next();
            expected = producerOrder[i - 1];
            id = producer.getId();
            Assert.assertEquals((long)expected.getId(), (long)id);
            Assert.assertEquals((Object)expected.getName(), (Object)producer.getName());
            Assert.assertEquals((Object)expected.getDescription(), (Object)producer.getDescription());
            Assert.assertEquals((Object)expected.getContactInfo(), (Object)producer.getContactInfo());
            ++i;
        }
        notificationProducers = this.businessObjectDao.findMatchingOrderBy(NotificationProducerBo.class, fieldValues, "id", false);
        Assert.assertEquals((long)2L, (long)notificationProducers.size());
        it = notificationProducers.iterator();
        i = 2;
        while (it.hasNext()) {
            producer = (NotificationProducerBo)it.next();
            expected = producerOrder[i - 1];
            id = producer.getId();
            Assert.assertEquals((long)expected.getId(), (long)id);
            Assert.assertEquals((Object)expected.getName(), (Object)producer.getName());
            Assert.assertEquals((Object)expected.getDescription(), (Object)producer.getDescription());
            Assert.assertEquals((Object)expected.getContactInfo(), (Object)producer.getContactInfo());
            --i;
        }
    }

    @Test
    public void testSaveObject() {
        NotificationProducerBo notificationProducer = new NotificationProducerBo();
        notificationProducer.setName("TestNotificationProducer");
        notificationProducer.setDescription("Notification Producer for Unit Tests");
        notificationProducer.setContactInfo("bh79@cornell.edu");
        Assert.assertNull((Object)notificationProducer.getId());
        this.businessObjectDao.save((Object)notificationProducer);
        Assert.assertNotNull((Object)notificationProducer.getId());
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", notificationProducer.getId());
        NotificationProducerBo saved = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertEquals((long)notificationProducer.getId(), (long)saved.getId());
        Assert.assertEquals((Object)notificationProducer.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)notificationProducer.getDescription(), (Object)saved.getDescription());
        Assert.assertEquals((Object)notificationProducer.getContactInfo(), (Object)saved.getContactInfo());
    }

    @Test
    public void testSaveList() {
        ArrayList<NotificationProducerBo> notificationProducers = new ArrayList<NotificationProducerBo>(2);
        NotificationProducerBo notificationProducer = new NotificationProducerBo();
        notificationProducer.setName("TestNotificationProducer");
        notificationProducer.setDescription("Notification Producer for Unit Tests");
        notificationProducer.setContactInfo("bh79@cornell.edu");
        NotificationProducerBo notificationProducer2 = new NotificationProducerBo();
        notificationProducer2.setName("TestNotificationProducer2");
        notificationProducer2.setDescription("Notification Producer for Unit Tests 2");
        notificationProducer2.setContactInfo("bh79@cornell.edu");
        notificationProducers.add(notificationProducer);
        notificationProducers.add(notificationProducer2);
        Assert.assertNull((Object)notificationProducer.getId());
        Assert.assertNull((Object)notificationProducer.getId());
        this.businessObjectDao.save(notificationProducers);
        Assert.assertNotNull((Object)notificationProducer.getId());
        Assert.assertNotNull((Object)notificationProducer2.getId());
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", notificationProducer.getId());
        NotificationProducerBo saved = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertEquals((long)notificationProducer.getId(), (long)saved.getId());
        Assert.assertEquals((Object)notificationProducer.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)notificationProducer.getDescription(), (Object)saved.getDescription());
        Assert.assertEquals((Object)notificationProducer.getContactInfo(), (Object)saved.getContactInfo());
        primaryKeys = new HashMap();
        primaryKeys.put("id", notificationProducer2.getId());
        saved = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertEquals((long)notificationProducer2.getId(), (long)saved.getId());
        Assert.assertEquals((Object)notificationProducer2.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)notificationProducer2.getDescription(), (Object)saved.getDescription());
        Assert.assertEquals((Object)notificationProducer2.getContactInfo(), (Object)saved.getContactInfo());
    }

    @Test
    public void testSaveListViolateConstraint() {
        Object exceptionDescription = null;
        try {
            ArrayList<NotificationProducerBo> notificationProducers = new ArrayList<NotificationProducerBo>(2);
            NotificationProducerBo notificationProducer = new NotificationProducerBo();
            notificationProducer.setName("TestNotificationProducer");
            notificationProducer.setDescription("Notification Producer for Unit Tests");
            notificationProducer.setContactInfo("bh79@cornell.edu");
            NotificationProducerBo notificationProducer2 = new NotificationProducerBo();
            notificationProducer2.setName("TestNotificationProducer");
            notificationProducer2.setDescription("Notification Producer for Unit Tests");
            notificationProducer2.setContactInfo("bh79@cornell.edu");
            notificationProducers.add(notificationProducer);
            notificationProducers.add(notificationProducer2);
            Assert.assertNull((Object)notificationProducer.getId());
            Assert.assertNull((Object)notificationProducer.getId());
            this.businessObjectDao.save(notificationProducers);
            Assert.fail((String)"No exception was thrown; expected constraint violation");
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteObject() {
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", TestConstants.PRODUCER_2.getId());
        NotificationProducerBo notificationProducer = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        this.businessObjectDao.delete((Object)notificationProducer);
        NotificationProducerBo saved = (NotificationProducerBo)this.businessObjectDao.findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertNull((Object)saved);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("contactInfo", "producer_1_and_2@127.0.0.1");
        Assert.assertEquals((long)1L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
    }

    @Test
    public void testDeleteListOfObject() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("contactInfo", "producer_1_and_2@127.0.0.1");
        Assert.assertEquals((long)2L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
        Collection notificationProducers = this.businessObjectDao.findMatching(NotificationProducerBo.class, fieldValues);
        ArrayList listToDelete = new ArrayList(notificationProducers);
        this.businessObjectDao.delete(listToDelete);
        Assert.assertEquals((long)0L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
    }

    @Test
    public void testDeleteMatching() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("contactInfo", "producer_1_and_2@127.0.0.1");
        Assert.assertEquals((long)2L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
        this.businessObjectDao.deleteMatching(NotificationProducerBo.class, fieldValues);
        Assert.assertEquals((long)0L, (long)this.businessObjectDao.countMatching(NotificationProducerBo.class, fieldValues));
    }

    @Test
    public void testRetrieve() {
        NotificationProducerBo template = new NotificationProducerBo();
        template.setId(TestConstants.PRODUCER_2.getId());
        NotificationProducerBo notificationProducer = (NotificationProducerBo)this.businessObjectDao.retrieve((Object)template);
        Assert.assertEquals((long)TestConstants.PRODUCER_2.getId(), (long)notificationProducer.getId());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getName(), (Object)notificationProducer.getName());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getDescription(), (Object)notificationProducer.getDescription());
        Assert.assertEquals((Object)TestConstants.PRODUCER_2.getContactInfo(), (Object)notificationProducer.getContactInfo());
    }

    @Test
    public void testFindMatchingByExample() {
        NotificationProducerBo template = new NotificationProducerBo();
        template.setName(TestConstants.PRODUCER_1.getName());
        Collection producers = this.businessObjectDao.findMatchingByExample((Object)template);
        Assert.assertEquals((long)producers.size(), (long)1L);
    }

    static {
        producers.put(TestConstants.PRODUCER_1.getId(), TestConstants.PRODUCER_1);
        producers.put(TestConstants.PRODUCER_2.getId(), TestConstants.PRODUCER_2);
        producerOrder = new NotificationProducerBo[]{TestConstants.PRODUCER_1, TestConstants.PRODUCER_2};
    }
}

