/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.util.HashMap;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.dao.BusinessObjectPersistenceTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;
import org.kuali.rice.kim.api.KimConstants;

public class NotificationChannelReviewerDaoTest
extends BusinessObjectPersistenceTestCaseBase {
    private NotificationChannelBo mockChannel1 = MockObjectsUtil.getTestChannel1();
    private NotificationChannelReviewerBo mockReviewer = MockObjectsUtil.buildTestNotificationChannelReviewer(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, "aReviewer");

    @Override
    protected void setup() {
        super.setup();
        this.businessObjectDao.save((Object)this.mockChannel1);
    }

    @Override
    protected boolean delete() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("reviewerId", this.mockReviewer.getReviewerId());
        NotificationChannelReviewerBo reviewer = (NotificationChannelReviewerBo)this.businessObjectDao.findByUniqueKey(NotificationChannelReviewerBo.class, criteria);
        try {
            this.businessObjectDao.delete((Object)reviewer);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean insert() {
        this.mockReviewer.setChannel(this.mockChannel1);
        try {
            this.businessObjectDao.save((Object)this.mockReviewer);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean retrieve() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("reviewerId", this.mockReviewer.getReviewerId());
        NotificationChannelReviewerBo reviewer = (NotificationChannelReviewerBo)this.businessObjectDao.findByUniqueKey(NotificationChannelReviewerBo.class, criteria);
        boolean success = true;
        success &= reviewer != null;
        success &= reviewer.getReviewerId().equals(this.mockReviewer.getReviewerId());
        success &= reviewer.getReviewerType().equals(this.mockReviewer.getReviewerType());
        success &= reviewer.getChannel() != null;
        return success &= reviewer.getChannel().getId().equals(this.mockChannel1.getId());
    }

    @Override
    protected boolean update() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("reviewerId", this.mockReviewer.getReviewerId());
        NotificationChannelReviewerBo reviewer = (NotificationChannelReviewerBo)this.businessObjectDao.findByUniqueKey(NotificationChannelReviewerBo.class, criteria);
        reviewer.setReviewerId("updatedReviewerId");
        reviewer.setReviewerType(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
        try {
            this.businessObjectDao.save((Object)reviewer);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateChanges() {
        NotificationChannelReviewerBo reviewer = (NotificationChannelReviewerBo)this.businessObjectDao.findById(NotificationChannelReviewerBo.class, (Object)this.mockReviewer.getId());
        boolean success = reviewer != null;
        success &= reviewer.getReviewerId().equals("updatedReviewerId");
        return success &= reviewer.getReviewerType().equals(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
    }
}

