/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.util.HashMap;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationRecipientListBo;
import org.kuali.rice.ken.dao.BusinessObjectPersistenceTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;

public class NotificationRecipientListDaoTest
extends BusinessObjectPersistenceTestCaseBase {
    NotificationChannelBo channel1 = MockObjectsUtil.getTestChannel1();
    NotificationChannelBo channel2 = MockObjectsUtil.getTestChannel2();
    NotificationRecipientListBo recipientList1 = new NotificationRecipientListBo();
    NotificationRecipientListBo recipientList2 = new NotificationRecipientListBo();
    private String[] recipientTypes = new String[]{"Type 1", "Type 2"};
    private String[] recipientIds = new String[]{"ag266", "jaf30"};
    private String[] updatedRecipientIds = new String[]{"bh79", "arh14"};

    @Override
    protected void setup() {
        this.businessObjectDao.save((Object)this.channel1);
        this.businessObjectDao.save((Object)this.channel2);
    }

    @Override
    protected boolean delete() {
        try {
            this.businessObjectDao.delete((Object)this.recipientList1);
            this.businessObjectDao.delete((Object)this.recipientList2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean retrieve() {
        this.recipientList1 = new NotificationRecipientListBo();
        this.recipientList2 = new NotificationRecipientListBo();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("channel.id", this.channel1.getId());
        criteria.put("recipientType", this.recipientTypes[0]);
        criteria.put("recipientId", this.recipientIds[0]);
        this.recipientList1 = (NotificationRecipientListBo)this.businessObjectDao.findMatching(NotificationRecipientListBo.class, criteria).iterator().next();
        criteria.clear();
        criteria.put("channel.id", this.channel2.getId());
        criteria.put("recipientType", this.recipientTypes[1]);
        criteria.put("recipientId", this.recipientIds[1]);
        this.recipientList2 = (NotificationRecipientListBo)this.businessObjectDao.findMatching(NotificationRecipientListBo.class, criteria).iterator().next();
        boolean success = true;
        success &= this.recipientList1 != null;
        success &= this.recipientList1.getRecipientId().equals(this.recipientIds[0]);
        success &= this.recipientList2 != null;
        return success &= this.recipientList2.getRecipientId().equals(this.recipientIds[1]);
    }

    @Override
    protected boolean insert() {
        this.recipientList1.setChannel(this.channel1);
        this.recipientList1.setRecipientType(this.recipientTypes[0]);
        this.recipientList1.setRecipientId(this.recipientIds[0]);
        this.recipientList2.setChannel(this.channel2);
        this.recipientList2.setRecipientType(this.recipientTypes[1]);
        this.recipientList2.setRecipientId(this.recipientIds[1]);
        try {
            this.businessObjectDao.save((Object)this.recipientList1);
            this.businessObjectDao.save((Object)this.recipientList2);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error saving recipients", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean update() {
        this.recipientList1.setRecipientId(this.updatedRecipientIds[0]);
        this.recipientList2.setRecipientId(this.updatedRecipientIds[1]);
        try {
            this.businessObjectDao.save((Object)this.recipientList1);
            this.businessObjectDao.save((Object)this.recipientList2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateChanges() {
        this.recipientList1 = new NotificationRecipientListBo();
        this.recipientList2 = new NotificationRecipientListBo();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("channel.id", this.channel1.getId());
        criteria.put("recipientType", this.recipientTypes[0]);
        criteria.put("recipientId", this.updatedRecipientIds[0]);
        this.recipientList1 = (NotificationRecipientListBo)this.businessObjectDao.findMatching(NotificationRecipientListBo.class, criteria).iterator().next();
        criteria.clear();
        criteria.put("channel.id", this.channel2.getId());
        criteria.put("recipientType", this.recipientTypes[1]);
        criteria.put("recipientId", this.updatedRecipientIds[1]);
        this.recipientList2 = (NotificationRecipientListBo)this.businessObjectDao.findMatching(NotificationRecipientListBo.class, criteria).iterator().next();
        boolean success = true;
        success &= this.recipientList1.getRecipientId().equals(this.updatedRecipientIds[0]);
        return success &= this.recipientList2.getRecipientId().equals(this.updatedRecipientIds[1]);
    }
}

